/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.block.plant.submerged.kelplike;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.common.block.plant.submerged.AbstractSubmergedPlant;
import teksturepako.greenery.common.util.Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\nH\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J \u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0016JP\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0018\u0010'\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010(\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020+2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J(\u0010,\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010*\u001a\u00020+2\u0006\u0010-\u001a\u00020\u0005H\u0016J(\u0010.\u001a\u00020)2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010*\u001a\u00020+H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lteksturepako/greenery/common/block/plant/submerged/kelplike/KelpLikePlantBase;", "Lteksturepako/greenery/common/block/plant/submerged/AbstractSubmergedPlant;", "name", "", "maxAge", "", "(Ljava/lang/String;I)V", "topProperty", "Lnet/minecraft/block/properties/PropertyBool;", "canBlockStay", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "canGrow", "isClient", "createPlantContainer", "Lnet/minecraft/block/state/BlockStateContainer;", "getActualState", "Lnet/minecraft/world/IBlockAccess;", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "source", "getStateForPlacement", "world", "facing", "Lnet/minecraft/util/EnumFacing;", "hitX", "", "hitY", "hitZ", "meta", "placer", "Lnet/minecraft/entity/EntityLivingBase;", "hand", "Lnet/minecraft/util/EnumHand;", "getTopPosition", "grow", "", "rand", "Ljava/util/Random;", "placePlant", "flags", "updateTick", "Greenery"})
public abstract class KelpLikePlantBase
extends AbstractSubmergedPlant {
    @NotNull
    private final PropertyBool topProperty;

    public KelpLikePlantBase(@NotNull String name, int maxAge) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, maxAge);
        PropertyBool propertyBool = PropertyBool.func_177716_a((String)"top");
        Intrinsics.checkNotNullExpressionValue((Object)propertyBool, (String)"create(...)");
        this.topProperty = propertyBool;
        this.initBlockState();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)this.topProperty, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    @NotNull
    public BlockStateContainer createPlantContainer() {
        IProperty[] iPropertyArray = new IProperty[]{this.getAgeProperty(), this.topProperty};
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    @NotNull
    public IBlockState func_176221_a(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        boolean hasKelpAbove = Intrinsics.areEqual((Object)worldIn.func_180495_p(pos.func_177984_a()).func_177230_c(), (Object)((Object)this));
        IBlockState iBlockState = state.func_177226_a((IProperty)this.topProperty, (Comparable)Boolean.valueOf(!hasKelpAbove));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"withProperty(...)");
        return iBlockState;
    }

    @NotNull
    public IBlockState getStateForPlacement(@NotNull World world, @NotNull BlockPos pos, @NotNull EnumFacing facing, float hitX, float hitY, float hitZ, int meta, @NotNull EntityLivingBase placer, @NotNull EnumHand hand) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        Intrinsics.checkNotNullParameter((Object)placer, (String)"placer");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        IBlockState down = world.func_180495_p(pos.func_177977_b());
        int age = Intrinsics.areEqual((Object)down.func_177230_c(), (Object)((Object)this)) ? Math.min(((Number)((Object)down.func_177229_b((IProperty)this.getAgeProperty()))).intValue() + 1, this.getMaxAge()) : new Random().nextInt(this.getMaxAge() / 2);
        IBlockState iBlockState = this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"withProperty(...)");
        return iBlockState;
    }

    @Override
    public boolean canBlockStay(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        return Intrinsics.areEqual((Object)down.func_177230_c(), (Object)((Object)this)) ? true : this.getALLOWED_SOILS().contains(down.func_185904_a());
    }

    @Override
    public void placePlant(@NotNull World world, @NotNull BlockPos pos, @NotNull Random rand, int flags) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (this.canGenerateBlockAt(world, pos)) {
            int startingAge = rand.nextInt(this.getMaxAge() / 2);
            int i = 0;
            int height = this.getMaxAge() - startingAge;
            if (i <= height) {
                while (true) {
                    BlockPos kelpPos = pos.func_177981_b(i);
                    IBlockState state = this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(i + startingAge));
                    Intrinsics.checkNotNull((Object)kelpPos);
                    if (!this.canGenerateBlockAt(world, kelpPos)) break;
                    world.func_180501_a(kelpPos, state, flags);
                    if (i == height) break;
                    ++i;
                }
            }
        }
    }

    @Override
    public void func_180650_b(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (worldIn.field_72995_K) {
            return;
        }
        if (!worldIn.func_175667_e(pos.func_177984_a())) {
            return;
        }
        Integer age = (Integer)state.func_177229_b((IProperty)this.getAgeProperty());
        Intrinsics.checkNotNull((Object)age);
        if (age < this.getMaxAge() && rand.nextDouble() < 0.14) {
            BlockPos blockPos = pos.func_177984_a();
            Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
            if (this.canGenerateBlockAt(worldIn, blockPos)) {
                IBlockState newBlockState = this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(age + 1));
                BlockPos blockPos2 = pos.func_177984_a();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos2, (String)"up(...)");
                if (this.canBlockStay(worldIn, blockPos2, state)) {
                    worldIn.func_175656_a(pos.func_177984_a(), newBlockState);
                }
            }
        }
    }

    private final BlockPos getTopPosition(World worldIn, BlockPos pos) {
        BlockPos topPos = pos;
        while (Intrinsics.areEqual((Object)worldIn.func_180495_p(topPos.func_177984_a()).func_177230_c(), (Object)((Object)this))) {
            Intrinsics.checkNotNullExpressionValue((Object)topPos.func_177984_a(), (String)"up(...)");
        }
        return topPos;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_176473_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, boolean isClient) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockPos topPos = this.getTopPosition(worldIn, pos);
        Integer topAge = (Integer)worldIn.func_180495_p(topPos).func_177229_b((IProperty)this.getAgeProperty());
        Intrinsics.checkNotNull((Object)topAge);
        if (topAge >= this.getMaxAge()) return false;
        BlockPos blockPos = topPos.func_177984_a();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
        if (!this.canGenerateBlockAt(worldIn, blockPos)) return false;
        return true;
    }

    @Override
    public void func_176474_b(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        BlockPos topPos = this.getTopPosition(worldIn, pos);
        Integer topAge = (Integer)worldIn.func_180495_p(topPos).func_177229_b((IProperty)this.getAgeProperty());
        IBlockState newBlockState = this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(topAge + 1));
        worldIn.func_175656_a(topPos.func_177984_a(), newBlockState);
    }

    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        IBlockState actualState = this.func_176221_a(state, source, pos);
        return Intrinsics.areEqual((Object)actualState, (Object)actualState.func_177226_a((IProperty)this.topProperty, (Comparable)Boolean.valueOf(true))) ? Utils.INSTANCE.applyOffset(this.getTOP_AABB(), this.getHasOffset(), state, source, pos) : (Intrinsics.areEqual((Object)actualState, (Object)actualState.func_177226_a((IProperty)this.topProperty, (Comparable)Boolean.valueOf(false))) ? Utils.INSTANCE.applyOffset(this.getBOTTOM_AABB(), this.getHasOffset(), state, source, pos) : Utils.INSTANCE.applyOffset(this.getTOP_AABB(), this.getHasOffset(), state, source, pos));
    }
}

