/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.block.plant.submerged.tall;

import java.util.Locale;
import java.util.Random;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.common.block.plant.submerged.AbstractSubmergedPlant;
import teksturepako.greenery.common.util.Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J(\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u0005H\u0016R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lteksturepako/greenery/common/block/plant/submerged/tall/TallSubmergedPlantBase;", "Lteksturepako/greenery/common/block/plant/submerged/AbstractSubmergedPlant;", "name", "", "maxAge", "", "(Ljava/lang/String;I)V", "variantProperty", "Lnet/minecraft/block/properties/PropertyEnum;", "Lteksturepako/greenery/common/block/plant/submerged/tall/TallSubmergedPlantBase$Variant;", "canBlockStay", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "canGrow", "isClient", "createPlantContainer", "Lnet/minecraft/block/state/BlockStateContainer;", "getActualState", "Lnet/minecraft/world/IBlockAccess;", "getBoundingBox", "Lnet/minecraft/util/math/AxisAlignedBB;", "source", "grow", "", "rand", "Ljava/util/Random;", "placePlant", "world", "flags", "Variant", "Greenery"})
public abstract class TallSubmergedPlantBase
extends AbstractSubmergedPlant {
    @NotNull
    private final PropertyEnum<Variant> variantProperty;

    public TallSubmergedPlantBase(@NotNull String name, int maxAge) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, maxAge);
        PropertyEnum propertyEnum = PropertyEnum.func_177709_a((String)"variant", Variant.class);
        Intrinsics.checkNotNullExpressionValue((Object)propertyEnum, (String)"create(...)");
        this.variantProperty = propertyEnum;
        this.initBlockState();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(0)).func_177226_a((IProperty)this.variantProperty, (Comparable)((Object)Variant.SINGLE)));
    }

    @Override
    @NotNull
    public BlockStateContainer createPlantContainer() {
        IProperty[] iPropertyArray = new IProperty[]{this.getAgeProperty(), this.variantProperty};
        return new BlockStateContainer((Block)this, iPropertyArray);
    }

    @NotNull
    public IBlockState func_176221_a(@NotNull IBlockState state, @NotNull IBlockAccess worldIn, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        IBlockState iBlockState = state.func_177226_a((IProperty)this.variantProperty, (Comparable)((Object)(Intrinsics.areEqual((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c(), (Object)((Object)this)) ? Variant.TOP : (Intrinsics.areEqual((Object)worldIn.func_180495_p(pos.func_177984_a()).func_177230_c(), (Object)((Object)this)) ? Variant.BOTTOM : Variant.SINGLE))));
        Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"withProperty(...)");
        return iBlockState;
    }

    @Override
    public boolean canBlockStay(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        IBlockState down2 = worldIn.func_180495_p(pos.func_177979_c(2));
        return Intrinsics.areEqual((Object)down.func_177230_c(), (Object)((Object)this)) ? !Intrinsics.areEqual((Object)down2.func_177230_c(), (Object)((Object)this)) : this.getALLOWED_SOILS().contains(down.func_185904_a());
    }

    @Override
    public void placePlant(@NotNull World world, @NotNull BlockPos pos, @NotNull Random rand, int flags) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (this.canGenerateBlockAt(world, pos)) {
            IBlockState state = this.func_176223_P();
            world.func_180501_a(pos, state, flags);
            if (rand.nextDouble() < 0.05) {
                BlockPos blockPos = pos.func_177984_a();
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
                if (this.canGenerateBlockAt(world, blockPos)) {
                    world.func_180501_a(pos.func_177984_a(), state, flags);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean func_176473_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, boolean isClient) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        IBlockState actualState = state.func_185899_b((IBlockAccess)worldIn, pos);
        if (actualState.func_177229_b((IProperty)this.variantProperty) != Variant.SINGLE) return false;
        BlockPos blockPos = pos.func_177984_a();
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
        if (!this.canGenerateBlockAt(worldIn, blockPos)) return false;
        return true;
    }

    @Override
    public void func_176474_b(@NotNull World worldIn, @NotNull Random rand, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.func_176473_a(worldIn, pos, state, false)) {
            worldIn.func_175656_a(pos.func_177984_a(), state);
        }
    }

    @NotNull
    public AxisAlignedBB func_185496_a(@NotNull IBlockState state, @NotNull IBlockAccess source, @NotNull BlockPos pos) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        IBlockState actualState = this.func_176221_a(state, source, pos);
        return Intrinsics.areEqual((Object)actualState, (Object)actualState.func_177226_a((IProperty)this.variantProperty, (Comparable)((Object)Variant.TOP))) ? Utils.INSTANCE.applyOffset(this.getTOP_AABB(), this.getHasOffset(), state, source, pos) : (Intrinsics.areEqual((Object)actualState, (Object)actualState.func_177226_a((IProperty)this.variantProperty, (Comparable)((Object)Variant.SINGLE))) ? Utils.INSTANCE.applyOffset(this.getTOP_AABB(), this.getHasOffset(), state, source, pos) : (Intrinsics.areEqual((Object)actualState, (Object)actualState.func_177226_a((IProperty)this.variantProperty, (Comparable)((Object)Variant.BOTTOM))) ? Utils.INSTANCE.applyOffset(this.getBOTTOM_AABB(), this.getHasOffset(), state, source, pos) : Utils.INSTANCE.applyOffset(this.getTOP_AABB(), this.getHasOffset(), state, source, pos)));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lteksturepako/greenery/common/block/plant/submerged/tall/TallSubmergedPlantBase$Variant;", "", "Lnet/minecraft/util/IStringSerializable;", "(Ljava/lang/String;I)V", "getName", "", "toString", "SINGLE", "BOTTOM", "TOP", "Greenery"})
    private static final class Variant
    extends Enum<Variant>
    implements IStringSerializable {
        public static final /* enum */ Variant SINGLE = new Variant();
        public static final /* enum */ Variant BOTTOM = new Variant();
        public static final /* enum */ Variant TOP = new Variant();
        private static final /* synthetic */ Variant[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        @NotNull
        public String func_176610_l() {
            String string = this.name();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string2 = string.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
            return string2;
        }

        @NotNull
        public String toString() {
            return this.func_176610_l();
        }

        public static Variant[] values() {
            return (Variant[])$VALUES.clone();
        }

        public static Variant valueOf(String value) {
            return Enum.valueOf(Variant.class, value);
        }

        @NotNull
        public static EnumEntries<Variant> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = variantArray = new Variant[]{Variant.SINGLE, Variant.BOTTOM, Variant.TOP};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

