/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.block.plant.upland.tall;

import java.util.Random;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import teksturepako.greenery.Greenery;
import teksturepako.greenery.common.block.plant.GreeneryPlant;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J(\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0017H\u0016J:\u0010 \u001a\u00020!2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0016J(\u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u0005H\u0016J\u0018\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020+H\u0016R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0019\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u00060"}, d2={"Lteksturepako/greenery/common/block/plant/upland/tall/AbstractTallPlant;", "Lteksturepako/greenery/common/block/plant/GreeneryPlant;", "name", "", "maxAge", "", "(Ljava/lang/String;I)V", "ALLOWED_SOILS", "", "Lnet/minecraft/block/material/Material;", "getALLOWED_SOILS", "()Ljava/util/Set;", "GRASS_BOTTOM_AABB", "", "Lnet/minecraft/util/math/AxisAlignedBB;", "getGRASS_BOTTOM_AABB", "()[Lnet/minecraft/util/math/AxisAlignedBB;", "[Lnet/minecraft/util/math/AxisAlignedBB;", "GRASS_TOP_AABB", "getGRASS_TOP_AABB", "getName", "()Ljava/lang/String;", "canBlockStay", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "canGrow", "isClient", "harvestBlock", "", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "te", "Lnet/minecraft/tileentity/TileEntity;", "stack", "Lnet/minecraft/item/ItemStack;", "placePlant", "world", "rand", "Ljava/util/Random;", "flags", "quantityDroppedWithBonus", "fortune", "random", "Greenery"})
@SourceDebugExtension(value={"SMAP\nAbstractTallPlant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractTallPlant.kt\nteksturepako/greenery/common/block/plant/upland/tall/AbstractTallPlant\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n1#2:105\n*E\n"})
public abstract class AbstractTallPlant
extends GreeneryPlant {
    @NotNull
    private final String name;
    @NotNull
    private final Set<Material> ALLOWED_SOILS;
    @NotNull
    private final AxisAlignedBB[] GRASS_TOP_AABB;
    @NotNull
    private final AxisAlignedBB[] GRASS_BOTTOM_AABB;

    public AbstractTallPlant(@NotNull String name, int maxAge) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(maxAge);
        this.name = name;
        Material material = Material.field_151577_b;
        Intrinsics.checkNotNullExpressionValue((Object)material, (String)"GRASS");
        this.ALLOWED_SOILS = SetsKt.setOf((Object)material);
        AxisAlignedBB[] axisAlignedBBArray = new AxisAlignedBB[]{new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.5, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.625, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.75, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 0.875, 0.9)};
        this.GRASS_TOP_AABB = axisAlignedBBArray;
        axisAlignedBBArray = new AxisAlignedBB[]{new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 1.0, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 1.0, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 1.0, 0.9), new AxisAlignedBB(0.1, 0.025, 0.1, 0.9, 1.0, 0.9)};
        this.GRASS_BOTTOM_AABB = axisAlignedBBArray;
        this.setRegistryName("plant/upland/tall/" + this.name);
        this.func_149663_c("greenery." + this.name);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(Greenery.INSTANCE.getCreativeTab());
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Set<Material> getALLOWED_SOILS() {
        return this.ALLOWED_SOILS;
    }

    @NotNull
    public final AxisAlignedBB[] getGRASS_TOP_AABB() {
        return this.GRASS_TOP_AABB;
    }

    @NotNull
    public final AxisAlignedBB[] getGRASS_BOTTOM_AABB() {
        return this.GRASS_BOTTOM_AABB;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canBlockStay(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        IBlockState down = worldIn.func_180495_p(pos.func_177977_b());
        IBlockState down2 = worldIn.func_180495_p(pos.func_177979_c(2));
        if (this.ALLOWED_SOILS.contains(down.func_185904_a())) return true;
        if (Intrinsics.areEqual((Object)down.func_177230_c(), (Object)Blocks.field_150346_d)) return true;
        if (!Intrinsics.areEqual((Object)down.func_177230_c(), (Object)((Object)this))) return false;
        Intrinsics.checkNotNull((Object)down);
        if (this.getAge(down) != this.getMaxAge()) return false;
        if (!this.ALLOWED_SOILS.contains(down2.func_185904_a())) return false;
        return true;
    }

    @Override
    public boolean func_176473_a(@NotNull World worldIn, @NotNull BlockPos pos, @NotNull IBlockState state, boolean isClient) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return Intrinsics.areEqual((Object)worldIn.func_180495_p(pos.func_177984_a()).func_177230_c(), (Object)((Object)this)) ? false : (Intrinsics.areEqual((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c(), (Object)((Object)this)) ? this.getAge(state) < this.getMaxAge() : true);
    }

    @Override
    public void placePlant(@NotNull World world, @NotNull BlockPos pos, @NotNull Random rand, int flags) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        if (world.func_175623_d(pos)) {
            int startingAge = rand.nextInt(this.getMaxAge());
            IBlockState state = this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(startingAge));
            IBlockState maxState = this.func_176223_P().func_177226_a((IProperty)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getMaxAge()));
            Intrinsics.checkNotNull((Object)state);
            if (this.canBlockStay(world, pos, state)) {
                world.func_180501_a(pos, state, flags);
                if (rand.nextDouble() < 0.2) {
                    world.func_180501_a(pos, maxState, flags);
                    if (world.func_175623_d(pos.func_177984_a())) {
                        BlockPos blockPos = pos.func_177984_a();
                        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"up(...)");
                        if (this.canBlockStay(world, blockPos, state)) {
                            world.func_180501_a(pos.func_177984_a(), state, flags);
                        }
                    }
                }
            }
        }
    }

    public int func_149679_a(int fortune, @NotNull Random random) {
        Intrinsics.checkNotNullParameter((Object)random, (String)"random");
        return 1 + random.nextInt(fortune * 2 + 1);
    }

    public void func_180657_a(@NotNull World worldIn, @NotNull EntityPlayer player, @NotNull BlockPos pos, @NotNull IBlockState state, @Nullable TileEntity te, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)worldIn, (String)"worldIn");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        if (!worldIn.field_72995_K && stack.func_77973_b() == Items.field_151097_aZ) {
            StatBase statBase = StatList.func_188055_a((Block)this);
            if (statBase != null) {
                StatBase it = statBase;
                boolean bl = false;
                player.func_71029_a(it);
            }
            Block.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((Block)this, 1));
        } else {
            super.func_180657_a(worldIn, player, pos, state, te, stack);
        }
    }
}

