/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.config.json;

import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.common.config.json.Deserializer;
import teksturepako.greenery.common.config.json.PlantData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002J\n\u0010\u000e\u001a\u00020\u000f*\u00020\nJ\f\u0010\u0010\u001a\u00020\f*\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lteksturepako/greenery/common/config/json/Deserializer;", "", "()V", "camelRegex", "Lkotlin/text/Regex;", "json", "Lkotlinx/serialization/json/Json;", "getData", "Lteksturepako/greenery/common/config/json/PlantData;", "jsonFile", "Ljava/io/File;", "readFile", "", "file", "canDoWork", "", "toSnakeCase", "Greenery"})
@SourceDebugExtension(value={"SMAP\nDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Deserializer.kt\nteksturepako/greenery/common/config/json/Deserializer\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,40:1\n96#2:41\n*S KotlinDebug\n*F\n+ 1 Deserializer.kt\nteksturepako/greenery/common/config/json/Deserializer\n*L\n18#1:41\n*E\n"})
public final class Deserializer {
    @NotNull
    public static final Deserializer INSTANCE = new Deserializer();
    @NotNull
    private static final Json json = JsonKt.Json$default(null, (Function1)json.1.INSTANCE, (int)1, null);
    @NotNull
    private static final Regex camelRegex = new Regex("(?<=[a-zA-Z])[A-Z]");

    private Deserializer() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PlantData getData(@NotNull File jsonFile) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)jsonFile, (String)"jsonFile");
        Json json2 = json;
        String string = jsonFile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        String string$iv = this.readFile(string);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        PlantData data = (PlantData)this_$iv.decodeFromString((DeserializationStrategy)PlantData.Companion.serializer(), string$iv);
        data.setName(this.toSnakeCase(FilesKt.getNameWithoutExtension((File)jsonFile)));
        return data;
    }

    public final boolean canDoWork(@NotNull File $this$canDoWork) {
        Intrinsics.checkNotNullParameter((Object)$this$canDoWork, (String)"<this>");
        return $this$canDoWork.exists() && Intrinsics.areEqual((Object)FilesKt.getExtension((File)$this$canDoWork), (Object)"json");
    }

    private final String readFile(String file) {
        String string = FileUtils.readFileToString((File)new File(file), (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readFileToString(...)");
        return string;
    }

    private final String toSnakeCase(String $this$toSnakeCase) {
        String string = camelRegex.replace((CharSequence)$this$toSnakeCase, (Function1)toSnakeCase.1.INSTANCE);
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
        return string2;
    }
}

