/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.event;

import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.Greenery;
import teksturepako.greenery.common.config.Config;
import teksturepako.greenery.common.world.WorldGenParser;
import teksturepako.greenery.common.world.gen.IPlantGenerator;

@Mod.EventBusSubscriber
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J(\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J(\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0012"}, d2={"Lteksturepako/greenery/common/event/EventBonemeal;", "", "()V", "onBonemealUsed", "", "event", "Lnet/minecraftforge/event/entity/player/BonemealEvent;", "spawnParticles", "generationAttempts", "", "worldIn", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "rand", "Ljava/util/Random;", "useBonemeal", "world", "Greenery"})
public final class EventBonemeal {
    @NotNull
    public static final EventBonemeal INSTANCE = new EventBonemeal();

    private EventBonemeal() {
    }

    @SubscribeEvent
    @JvmStatic
    public static final void onBonemealUsed(@NotNull BonemealEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (!Config.INSTANCE.getGlobal().genPlantsFromBonemeal) {
            return;
        }
        World world = event.getWorld();
        IBlockState blockState = event.getBlock();
        BlockPos up = event.getPos().func_177984_a();
        Random rand = world.field_73012_v;
        event.isCanceled();
        if (Intrinsics.areEqual((Object)blockState.func_185904_a(), (Object)Material.field_151577_b) || FluidloggedUtils.isFluidloggableFluid((Block)world.func_180495_p(up).func_177230_c()) && !CollectionsKt.contains((Iterable)Greenery.INSTANCE.getPlants(), (Object)blockState.func_177230_c())) {
            Intrinsics.checkNotNull((Object)up);
            Intrinsics.checkNotNull((Object)world);
            Intrinsics.checkNotNull((Object)rand);
            INSTANCE.useBonemeal(event, up, world, rand);
        }
    }

    private final void useBonemeal(BonemealEvent event, BlockPos pos, World world, Random rand) {
        if (Greenery.INSTANCE.getGenerators().isEmpty()) {
            return;
        }
        for (IPlantGenerator generator : Greenery.INSTANCE.getGenerators()) {
            for (String input : generator.getBlock().getWorldGen()) {
                WorldGenParser config = new WorldGenParser(input, generator.getBlock().getWorldGen());
                if (!(rand.nextDouble() < config.getGenerationChance())) continue;
                Biome biome = world.func_180494_b(pos);
                Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"getBiome(...)");
                if (!config.canGenerate(biome, event.getWorld().field_73011_w.getDimension())) continue;
                if (!world.field_72995_K) {
                    event.setResult(Event.Result.ALLOW);
                    generator.generatePlants(config.getPlantAttempts() / 4, world, rand, pos, 11);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)event.getEntityPlayer(), (Object)Minecraft.func_71410_x().field_71439_g)) continue;
                EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
                EnumHand enumHand = event.getHand();
                Intrinsics.checkNotNull((Object)enumHand);
                entityPlayerSP.func_184609_a(enumHand);
                this.spawnParticles(config.getPatchAttempts() / 4, world, pos, rand);
            }
        }
    }

    private final void spawnParticles(int generationAttempts, World worldIn, BlockPos pos, Random rand) {
        for (int i = 0; i < generationAttempts; ++i) {
            BlockPos blockPos = pos.func_177982_a(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(2) - rand.nextInt(2), rand.nextInt(4) - rand.nextInt(4));
            double d1 = (float)blockPos.func_177958_n() + rand.nextFloat();
            double d2 = (float)blockPos.func_177956_o() + rand.nextFloat();
            double d3 = (float)blockPos.func_177952_p() + rand.nextFloat();
            if (i == 0 && !worldIn.func_180495_p(blockPos.func_177984_a()).func_185914_p()) {
                d2 = (double)blockPos.func_177956_o() + 0.0625 + 1.0;
            } else if (i == 1 && !worldIn.func_180495_p(blockPos.func_177977_b()).func_185914_p()) {
                d2 = (double)blockPos.func_177956_o() - 0.0625;
            } else if (i == 2 && !worldIn.func_180495_p(blockPos.func_177968_d()).func_185914_p()) {
                d3 = (double)blockPos.func_177952_p() + 0.0625 + 1.0;
            } else if (i == 3 && !worldIn.func_180495_p(blockPos.func_177978_c()).func_185914_p()) {
                d3 = (double)blockPos.func_177952_p() - 0.0625;
            } else if (i == 4 && !worldIn.func_180495_p(blockPos.func_177974_f()).func_185914_p()) {
                d1 = (double)blockPos.func_177958_n() + 0.0625 + 1.0;
            } else if (i == 5 && !worldIn.func_180495_p(blockPos.func_177976_e()).func_185914_p()) {
                d1 = (double)blockPos.func_177958_n() - 0.0625;
            }
            if (!(d1 < (double)blockPos.func_177958_n() || d1 > (double)(blockPos.func_177958_n() + 1) || d2 < 0.0 || d2 > (double)(blockPos.func_177956_o() + 1) || d3 < (double)blockPos.func_177952_p()) && !(d3 > (double)(blockPos.func_177952_p() + 1))) continue;
            worldIn.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, d1, d2, d3, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

