/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.registry;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.Greenery;
import teksturepako.greenery.common.block.BlockDriedKelp;
import teksturepako.greenery.common.block.BlockGrass;
import teksturepako.greenery.common.block.plant.GreeneryPlant;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0014H\u0007J\u0014\u0010\u0015\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00160\u000eJ\b\u0010\u0017\u001a\u00020\fH\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lteksturepako/greenery/common/registry/ModBlocks;", "", "()V", "blockDriedKelp", "Lteksturepako/greenery/common/block/BlockDriedKelp;", "getBlockDriedKelp", "()Lteksturepako/greenery/common/block/BlockDriedKelp;", "blockGrass", "Lteksturepako/greenery/common/block/BlockGrass;", "getBlockGrass", "()Lteksturepako/greenery/common/block/BlockGrass;", "register", "", "registry", "Lnet/minecraftforge/registries/IForgeRegistry;", "Lnet/minecraft/block/Block;", "registerBlockColorHandlers", "event", "Lnet/minecraftforge/client/event/ColorHandlerEvent$Block;", "registerItemBlockColorHandlers", "Lnet/minecraftforge/client/event/ColorHandlerEvent$Item;", "registerItemBlocks", "Lnet/minecraft/item/Item;", "registerModels", "Greenery"})
public final class ModBlocks {
    @NotNull
    public static final ModBlocks INSTANCE = new ModBlocks();
    @NotNull
    private static final BlockGrass blockGrass = new BlockGrass();
    @NotNull
    private static final BlockDriedKelp blockDriedKelp = new BlockDriedKelp();

    private ModBlocks() {
    }

    @NotNull
    public final BlockGrass getBlockGrass() {
        return blockGrass;
    }

    @NotNull
    public final BlockDriedKelp getBlockDriedKelp() {
        return blockDriedKelp;
    }

    public final void register(@NotNull IForgeRegistry<Block> registry) {
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        for (GreeneryPlant plant : Greenery.INSTANCE.getPlants()) {
            registry.register((IForgeRegistryEntry)plant);
        }
        registry.register((IForgeRegistryEntry)blockGrass);
        registry.register((IForgeRegistryEntry)blockDriedKelp);
    }

    public final void registerItemBlocks(@NotNull IForgeRegistry<Item> registry) {
        Intrinsics.checkNotNullParameter(registry, (String)"registry");
        for (GreeneryPlant plant : Greenery.INSTANCE.getPlants()) {
            registry.register((IForgeRegistryEntry)plant.createItemBlock());
        }
        registry.register((IForgeRegistryEntry)blockGrass.createItemBlock());
        registry.register((IForgeRegistryEntry)blockDriedKelp.createItemBlock());
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerModels() {
        for (GreeneryPlant plant : Greenery.INSTANCE.getPlants()) {
            plant.registerItemModel();
        }
        blockGrass.registerItemModel();
        blockDriedKelp.registerItemModel();
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerBlockColorHandlers(@NotNull ColorHandlerEvent.Block event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (GreeneryPlant plant : Greenery.INSTANCE.getPlants()) {
            if (!plant.getHasTintIndex()) continue;
            plant.registerBlockColorHandler(event);
        }
        blockGrass.registerBlockColorHandler(event);
    }

    @SideOnly(value=Side.CLIENT)
    public final void registerItemBlockColorHandlers(@NotNull ColorHandlerEvent.Item event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        for (GreeneryPlant plant : Greenery.INSTANCE.getPlants()) {
            if (!plant.getHasTintIndex()) continue;
            plant.registerItemColorHandler(event);
        }
        blockGrass.registerItemColorHandler(event);
    }
}

