/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.Greenery;
import teksturepako.greenery.common.world.WorldGenParser;
import teksturepako.greenery.common.world.gen.IPlantGenerator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0007H\u0002J\u001e\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u001e\u0010\f\u001a\u00020\t2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00072\u0006\u0010\u000b\u001a\u00020\tH\u0002J\u001c\u0010\u000f\u001a\u00020\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\u0012\u001a\u00020\tJ\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lteksturepako/greenery/common/util/ConfigUtil;", "", "()V", "validTypes", "", "Lnet/minecraftforge/common/BiomeDictionary$Type;", "getValidBiomeDictionaryTypes", "", "parseBiomeDictionaries", "", "types", "printErrors", "parseBiomes", "biomes", "Lnet/minecraft/util/ResourceLocation;", "parseGenerators", "generators", "Lteksturepako/greenery/common/world/gen/IPlantGenerator;", "printParsing", "printValidBiomeDictionaries", "", "Greenery"})
public final class ConfigUtil {
    @NotNull
    public static final ConfigUtil INSTANCE = new ConfigUtil();
    @NotNull
    private static final List<BiomeDictionary.Type> validTypes = new ArrayList();

    private ConfigUtil() {
    }

    public final boolean parseGenerators(@NotNull List<IPlantGenerator> generators, boolean printParsing) {
        Intrinsics.checkNotNullParameter(generators, (String)"generators");
        if (printParsing) {
            Greenery.INSTANCE.getLogger().info("Loading world generators:");
        }
        if (generators.isEmpty()) {
            if (printParsing) {
                Greenery.INSTANCE.getLogger().error("No generators found!");
            }
            return true;
        }
        boolean errored = false;
        for (IPlantGenerator generator : generators) {
            List<BiomeDictionary.Type> types = CollectionsKt.emptyList();
            List<ResourceLocation> biomes = CollectionsKt.emptyList();
            for (String input : generator.getBlock().getWorldGen()) {
                WorldGenParser config = new WorldGenParser(input, generator.getBlock().getWorldGen());
                types = config.getTypes();
                biomes = config.getBiomesResLocs();
                errored = this.parseBiomeDictionaries(types, false) || this.parseBiomes(biomes, false);
            }
            if (!printParsing) continue;
            if (errored) {
                Greenery.INSTANCE.getLogger().warn("  ! " + generator.getBlock().func_149732_F());
                Greenery.INSTANCE.getLogger().error("    > " + generator.getBlock().getWorldGen());
                this.parseBiomeDictionaries(types, true);
                this.parseBiomes(biomes, true);
                continue;
            }
            Greenery.INSTANCE.getLogger().info("  > " + generator.getBlock().func_149732_F());
            Greenery.INSTANCE.getLogger().info("     > " + generator.getBlock().getWorldGen());
        }
        if (printParsing && errored) {
            this.printValidBiomeDictionaries();
        }
        return errored;
    }

    private final boolean parseBiomeDictionaries(List<BiomeDictionary.Type> types, boolean printErrors) {
        for (BiomeDictionary.Type type : types) {
            if (this.getValidBiomeDictionaryTypes().contains(type)) continue;
            if (printErrors) {
                Logger logger = Greenery.INSTANCE.getLogger();
                StringBuilder stringBuilder = new StringBuilder().append("    > Invalid biome dictionary type: \"");
                String string = type.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
                logger.error(stringBuilder.append(string3).append('\"').toString());
            }
            return true;
        }
        return false;
    }

    private final void printValidBiomeDictionaries() {
        Greenery.INSTANCE.getLogger().warn("Valid biome dictionary types are:");
        Greenery.INSTANCE.getLogger().warn(String.valueOf(this.getValidBiomeDictionaryTypes()));
    }

    private final List<BiomeDictionary.Type> getValidBiomeDictionaryTypes() {
        Collection collection = BiomeDictionary.Type.getAll();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAll(...)");
        List allTypes = CollectionsKt.toList((Iterable)collection);
        if (validTypes.isEmpty()) {
            validTypes.addAll(allTypes);
        }
        return validTypes;
    }

    private final boolean parseBiomes(List<? extends ResourceLocation> biomes, boolean printErrors) {
        for (ResourceLocation resourceLocation : biomes) {
            if (ForgeRegistries.BIOMES.containsKey(resourceLocation)) continue;
            if (printErrors) {
                Greenery.INSTANCE.getLogger().error("    > Invalid biome: \"" + resourceLocation + '\"');
            }
            return true;
        }
        return false;
    }
}

