/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.util;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.common.util.DropsUtil;
import teksturepako.greenery.common.util.Utils;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JB\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\bH\u0002\u00a8\u0006\u0016"}, d2={"Lteksturepako/greenery/common/util/DropsUtil;", "", "()V", "getDrops", "", "Lnet/minecraft/item/ItemStack;", "dropsList", "", "", "world", "Lnet/minecraft/world/IBlockAccess;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/state/IBlockState;", "defaultItem", "Lnet/minecraft/item/Item;", "fortune", "", "isBlockStateValid", "", "input", "Greenery"})
@SourceDebugExtension(value={"SMAP\nDropsUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DropsUtil.kt\nteksturepako/greenery/common/util/DropsUtil\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,90:1\n429#2:91\n502#2,5:92\n1#3:97\n1224#4:98\n1225#4:102\n187#5,3:99\n*S KotlinDebug\n*F\n+ 1 DropsUtil.kt\nteksturepako/greenery/common/util/DropsUtil\n*L\n23#1:91\n23#1:92,5\n85#1:98\n85#1:102\n86#1:99,3\n*E\n"})
public final class DropsUtil {
    @NotNull
    public static final DropsUtil INSTANCE = new DropsUtil();

    private DropsUtil() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ItemStack> getDrops(@NotNull List<String> dropsList, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull IBlockState state, @NotNull Item defaultItem, int fortune) {
        Intrinsics.checkNotNullParameter(dropsList, (String)"dropsList");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)defaultItem, (String)"defaultItem");
        List drops = new ArrayList();
        Random random = ((World)world).field_73012_v;
        Iterator<String> iterator = dropsList.iterator();
        while (iterator.hasNext()) {
            double chance;
            ItemStack itemStack;
            void $this$filterTo$iv$iv;
            String stringInput;
            String $this$filter$iv = stringInput = iterator.next();
            boolean $i$f$filter22 = false;
            CharSequence charSequence = $this$filter$iv;
            Appendable destination$iv$iv = new StringBuilder();
            boolean $i$f$filterTo2 = false;
            int n = $this$filterTo$iv$iv.length();
            for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                char element$iv$iv;
                char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                if (!(!CharsKt.isWhitespace((char)it))) continue;
                destination$iv$iv.append(element$iv$iv);
            }
            String string = ((StringBuilder)destination$iv$iv).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
            String filteredInput = ((Object)StringsKt.trim((CharSequence)string)).toString();
            List raw = null;
            if (!StringsKt.contains$default((CharSequence)filteredInput, (CharSequence)"|", (boolean)false, (int)2, null)) continue;
            String[] $i$f$filter22 = new String[]{"|"};
            raw = StringsKt.split$default((CharSequence)filteredInput, (String[])$i$f$filter22, (boolean)false, (int)0, (int)6, null);
            boolean blockStateIsValid = true;
            if (Utils.INSTANCE.isNotNull(raw, 2)) {
                IBlockState iBlockState = state.func_185899_b(world, pos);
                Intrinsics.checkNotNullExpressionValue((Object)iBlockState, (String)"getActualState(...)");
                blockStateIsValid = this.isBlockStateValid(iBlockState, (String)raw.get(2));
            }
            List itemStackRaw = CollectionsKt.emptyList();
            int amount = 0;
            amount = 1;
            if (Utils.INSTANCE.isNotNull(raw, 0)) {
                String[] $i$f$filterTo2 = new String[]{":"};
                itemStackRaw = StringsKt.split$default((CharSequence)StringsKt.substringBefore$default((String)((String)raw.get(0)), (String)"*", null, (int)2, null), (String[])$i$f$filterTo2, (boolean)false, (int)0, (int)6, null);
                $i$f$filterTo2 = new String[]{"*"};
                List $this$getDrops_u24lambda_u241 = StringsKt.split$default((CharSequence)((CharSequence)raw.get(0)), (String[])$i$f$filterTo2, (boolean)false, (int)0, (int)6, null);
                boolean bl = false;
                if (Utils.INSTANCE.isNotNull($this$getDrops_u24lambda_u241, 1)) {
                    amount = Integer.parseInt((String)$this$getDrops_u24lambda_u241.get(1));
                }
            }
            if (Utils.INSTANCE.isNotNull(itemStackRaw, 0) && Utils.INSTANCE.isNotNull(itemStackRaw, 1)) {
                IForgeRegistryEntry iForgeRegistryEntry = ForgeRegistries.ITEMS.getValue(new ResourceLocation((String)itemStackRaw.get(0) + ':' + (String)itemStackRaw.get(1)));
                Intrinsics.checkNotNull((Object)iForgeRegistryEntry);
                itemStack = new ItemStack((Item)iForgeRegistryEntry);
            } else {
                ItemStack itemStack2;
                if (StringsKt.contains$default((CharSequence)((CharSequence)raw.get(0)), (CharSequence)"seeds", (boolean)false, (int)2, null)) {
                    ItemStack seed;
                    Intrinsics.checkNotNullExpressionValue((Object)ForgeHooks.getGrassSeed((Random)random, (int)fortune), (String)"getGrassSeed(...)");
                    itemStack2 = !seed.func_190926_b() ? seed : ItemStack.field_190927_a;
                } else {
                    itemStack2 = StringsKt.contains$default((CharSequence)((CharSequence)raw.get(0)), (CharSequence)"this", (boolean)false, (int)2, null) ? new ItemStack(defaultItem) : ItemStack.field_190927_a;
                }
                ItemStack $this$getDrops_u24lambda_u241 = itemStack2;
                Intrinsics.checkNotNull((Object)$this$getDrops_u24lambda_u241);
                itemStack = $this$getDrops_u24lambda_u241;
            }
            ItemStack itemStack3 = itemStack;
            itemStack3.func_190920_e(amount + fortune);
            double d = chance = Utils.INSTANCE.isNotNull(raw, 1) ? Double.parseDouble((String)raw.get(1)) : 0.0;
            if (!(random.nextDouble() < chance) || !blockStateIsValid) continue;
            drops.add(itemStack3);
        }
        return drops;
    }

    private final boolean isBlockStateValid(IBlockState state, String input) {
        boolean bl;
        block5: {
            String[] stringArray = new String[]{","};
            Sequence $this$all$iv = SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)StringsKt.split$default((CharSequence)input, (String[])stringArray, (boolean)false, (int)0, (int)6, null)), (Function1)isBlockStateValid.1.INSTANCE);
            boolean $i$f$all = false;
            for (Object element$iv : $this$all$iv) {
                boolean bl2;
                block4: {
                    List list = (List)element$iv;
                    boolean bl3 = false;
                    String key = (String)list.get(0);
                    String value = (String)list.get(1);
                    ImmutableMap immutableMap = state.func_177228_b();
                    Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"getProperties(...)");
                    Map $this$any$iv = (Map)immutableMap;
                    boolean $i$f$any = false;
                    if ($this$any$iv.isEmpty()) {
                        bl2 = false;
                    } else {
                        Iterator iterator = $this$any$iv.entrySet().iterator();
                        while (iterator.hasNext()) {
                            Map.Entry element$iv2;
                            Map.Entry it = element$iv2 = iterator.next();
                            boolean bl4 = false;
                            if (!(Intrinsics.areEqual((Object)((IProperty)it.getKey()).func_177701_a(), (Object)key) && Intrinsics.areEqual((Object)it.getValue().toString(), (Object)value))) continue;
                            bl2 = true;
                            break block4;
                        }
                        bl2 = false;
                    }
                }
                if (bl2) continue;
                bl = false;
                break block5;
            }
            bl = true;
        }
        return bl;
    }
}

