/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.util;

import biomesoplenty.api.biome.BOPBiomes;
import biomesoplenty.api.biome.IExtendedBiome;
import biomesoplenty.common.biome.vanilla.ExtendedBiomeWrapper;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.Loader;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u000f"}, d2={"Lteksturepako/greenery/common/util/WorldGenUtil;", "", "()V", "getBiomeInChunk", "Lnet/minecraft/world/biome/Biome;", "world", "Lnet/minecraft/world/World;", "chunkX", "", "chunkZ", "getExtendedBiome", "Lbiomesoplenty/api/biome/IExtendedBiome;", "biome", "removeUnwantedBOPGenerators", "", "Greenery"})
public final class WorldGenUtil {
    @NotNull
    public static final WorldGenUtil INSTANCE = new WorldGenUtil();

    private WorldGenUtil() {
    }

    public final void removeUnwantedBOPGenerators(@NotNull World world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        if (!Loader.isModLoaded((String)"biomesoplenty") || world.field_72995_K) {
            return;
        }
        for (Biome biome : BOPBiomes.REG_INSTANCE.getPresentBiomes()) {
            Intrinsics.checkNotNull((Object)biome);
            this.getExtendedBiome(biome).getGenerationManager().removeGenerator("grass");
            this.getExtendedBiome(biome).getGenerationManager().removeGenerator("ferns");
            this.getExtendedBiome(biome).getGenerationManager().removeGenerator("double_fern");
            this.getExtendedBiome(biome).getGenerationManager().removeGenerator("doublegrass");
            this.getExtendedBiome(biome).getGenerationManager().removeGenerator("barley");
        }
    }

    private final IExtendedBiome getExtendedBiome(Biome biome) {
        IExtendedBiome iExtendedBiome = BOPBiomes.REG_INSTANCE.getExtendedBiome(biome);
        if (iExtendedBiome == null) {
            WorldGenUtil it = this;
            boolean bl = false;
            ExtendedBiomeWrapper $this$getExtendedBiome_u24lambda_u241_u24lambda_u240 = new ExtendedBiomeWrapper(biome);
            boolean bl2 = false;
            IExtendedBiome iExtendedBiome2 = (IExtendedBiome)$this$getExtendedBiome_u24lambda_u241_u24lambda_u240;
            String string = $this$getExtendedBiome_u24lambda_u241_u24lambda_u240.getBaseBiome().func_185359_l();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getBiomeName(...)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            IExtendedBiome iExtendedBiome3 = BOPBiomes.REG_INSTANCE.registerBiome(iExtendedBiome2, string3);
            iExtendedBiome = iExtendedBiome3;
            Intrinsics.checkNotNullExpressionValue((Object)iExtendedBiome3, (String)"let(...)");
        }
        return iExtendedBiome;
    }

    @NotNull
    public final Biome getBiomeInChunk(@NotNull World world, int chunkX, int chunkZ) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Biome biome = world.getBiomeForCoordsBody(new BlockPos(chunkX * 16 + 8, 0, chunkZ * 16 + 8));
        Intrinsics.checkNotNullExpressionValue((Object)biome, (String)"getBiomeForCoordsBody(...)");
        return biome;
    }
}

