/*
 * Decompiled with CFR 0.152.
 */
package teksturepako.greenery.common.world.gen;

import java.util.Random;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import org.jetbrains.annotations.NotNull;
import teksturepako.greenery.common.block.plant.GreeneryPlant;
import teksturepako.greenery.common.block.plant.upland.tall.TallPlantBase;
import teksturepako.greenery.common.config.Config;
import teksturepako.greenery.common.util.WorldGenUtil;
import teksturepako.greenery.common.world.WorldGenParser;
import teksturepako.greenery.common.world.gen.IPlantGenerator;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J0\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lteksturepako/greenery/common/world/gen/PlantGenerator;", "Lteksturepako/greenery/common/world/gen/IPlantGenerator;", "block", "Lteksturepako/greenery/common/block/plant/GreeneryPlant;", "(Lteksturepako/greenery/common/block/plant/GreeneryPlant;)V", "getBlock", "()Lteksturepako/greenery/common/block/plant/GreeneryPlant;", "generate", "", "rand", "Ljava/util/Random;", "chunkX", "", "chunkZ", "world", "Lnet/minecraft/world/World;", "chunkGenerator", "Lnet/minecraft/world/gen/IChunkGenerator;", "chunkProvider", "Lnet/minecraft/world/chunk/IChunkProvider;", "generatePlants", "plantAttempts", "targetPos", "Lnet/minecraft/util/math/BlockPos;", "flags", "Greenery"})
public final class PlantGenerator
implements IPlantGenerator {
    @NotNull
    private final GreeneryPlant block;

    public PlantGenerator(@NotNull GreeneryPlant block) {
        Intrinsics.checkNotNullParameter((Object)((Object)block), (String)"block");
        this.block = block;
    }

    @Override
    @NotNull
    public GreeneryPlant getBlock() {
        return this.block;
    }

    public void generate(@NotNull Random rand, int chunkX, int chunkZ, @NotNull World world, @NotNull IChunkGenerator chunkGenerator, @NotNull IChunkProvider chunkProvider) {
        int genModifier;
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)chunkGenerator, (String)"chunkGenerator");
        Intrinsics.checkNotNullParameter((Object)chunkProvider, (String)"chunkProvider");
        Random random = world.field_73012_v;
        ChunkPos chunkPos = world.func_72964_e(chunkX, chunkZ).func_76632_l();
        Biome biome = WorldGenUtil.INSTANCE.getBiomeInChunk(world, chunkX, chunkZ);
        int dimension = world.field_73011_w.getDimension();
        int n = genModifier = this.getBlock() instanceof TallPlantBase ? 4 : 1;
        if (!Config.INSTANCE.getGlobal().genInSuperflat && Intrinsics.areEqual((Object)world.func_175624_G(), (Object)WorldType.field_77138_c)) {
            return;
        }
        block0: for (String input : this.getBlock().getWorldGen()) {
            int n2;
            int i;
            WorldGenParser parser = new WorldGenParser(input, this.getBlock().getWorldGen());
            if (!parser.canGenerate(biome, dimension) || !(random.nextDouble() < parser.getGenerationChance()) || (i = 0) > (n2 = parser.getPatchAttempts() * genModifier / RangesKt.coerceAtLeast((int)(this.getBlock().getWorldGen().size() - 1), (int)1))) continue;
            while (true) {
                int x = random.nextInt(16) + 8;
                int z = random.nextInt(16) + 8;
                int yRange = world.func_175645_m(chunkPos.func_180331_a(0, 0, 0).func_177982_a(x, 0, z)).func_177956_o() + 32;
                int y = random.nextInt(yRange);
                BlockPos pos = chunkPos.func_180331_a(0, 0, 0).func_177982_a(x, y, z);
                int n3 = parser.getPlantAttempts();
                Intrinsics.checkNotNull((Object)random);
                Intrinsics.checkNotNull((Object)pos);
                this.generatePlants(n3, world, random, pos, 2);
                if (i == n2) continue block0;
                ++i;
            }
        }
    }

    @Override
    public void generatePlants(int plantAttempts, @NotNull World world, @NotNull Random rand, @NotNull BlockPos targetPos, int flags) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        Intrinsics.checkNotNullParameter((Object)targetPos, (String)"targetPos");
        int i = 0;
        if (i <= plantAttempts) {
            while (true) {
                BlockPos pos;
                if (world.func_175667_e(pos = targetPos.func_177982_a(rand.nextInt(8) - rand.nextInt(8), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(8) - rand.nextInt(8)))) {
                    GreeneryPlant greeneryPlant = this.getBlock();
                    Intrinsics.checkNotNull((Object)pos);
                    greeneryPlant.placePlant(world, pos, rand, flags);
                }
                if (i == plantAttempts) break;
                ++i;
            }
        }
    }
}

