/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.block;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.client.gui.GuiHandlerAS;
import com.windanesz.ancientspellcraft.item.ItemRunicHammer;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import com.windanesz.ancientspellcraft.spell.IRunicHammerSpell;
import com.windanesz.ancientspellcraft.tileentity.TileArcaneAnvil;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BlockArcaneAnvil
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    protected static final AxisAlignedBB X_AXIS_AABB = new AxisAlignedBB(0.0, 0.0, 0.125, 1.0, 1.0, 0.875);
    protected static final AxisAlignedBB Z_AXIS_AABB = new AxisAlignedBB(0.125, 0.0, 0.0, 0.875, 1.0, 1.0);
    protected static final Logger LOGGER = LogManager.getLogger();

    public BlockArcaneAnvil() {
        super(Material.field_151574_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
        this.func_149713_g(0);
        this.func_149711_c(3.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(ASTabs.ANCIENTSPELLCRAFT);
        this.func_149672_a(SoundType.field_185858_k);
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing enumfacing = placer.func_174811_aO().func_176746_e();
        try {
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
        catch (IllegalArgumentException var11) {
            if (!worldIn.field_72995_K) {
                LOGGER.warn(String.format("Invalid damage property for arcane anvil at %s. Found %d, must be in [0, 1, 2]", pos, meta >> 2));
                if (placer instanceof EntityPlayer) {
                    placer.func_145747_a((ITextComponent)new TextComponentTranslation("Invalid damage property. Please pick in [0, 1, 2]", new Object[0]));
                }
            }
            return super.func_180642_a(worldIn, pos, facing, hitX, hitY, hitZ, 0, placer).func_177226_a((IProperty)FACING, (Comparable)enumfacing);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState block, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemRunicHammer && ((ItemRunicHammer)player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getCurrentSpell(player.func_184586_b(EnumHand.MAIN_HAND)) instanceof IRunicHammerSpell) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null || player.func_70093_af()) {
            return false;
        }
        player.openGui((Object)AncientSpellcraft.instance, GuiHandlerAS.ARCANE_ANVIL, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176740_k() == EnumFacing.Axis.X ? X_AXIS_AABB : Z_AXIS_AABB;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b();
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state.func_177230_c() != this ? state : state.func_177226_a((IProperty)FACING, (Comparable)rot.func_185831_a((EnumFacing)state.func_177229_b((IProperty)FACING)));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    @Nullable
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileArcaneAnvil();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState block) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileArcaneAnvil) {
            TileArcaneAnvil anvil = (TileArcaneAnvil)tileentity;
            for (int i = 0; i < 2; ++i) {
                ItemStack itemstack = anvil.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)anvil.func_174877_v().func_177958_n(), (double)anvil.func_174877_v().func_177956_o(), (double)anvil.func_174877_v().func_177952_p(), (ItemStack)itemstack);
            }
        }
        super.func_180663_b(world, pos, block);
    }

    public static ItemStack getItemOnLeftSlot(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileArcaneAnvil) {
            TileArcaneAnvil anvil = (TileArcaneAnvil)tileentity;
            return anvil.func_70301_a(0);
        }
        return ItemStack.field_190927_a;
    }
}

