/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.block;

import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.tileentity.TileEntityLightningBlock;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class BlockLightning
extends Block
implements ITileEntityProvider {
    public BlockLightning() {
        super(Material.field_151579_a);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_149713_g(1);
        this.func_149722_s();
        this.func_149752_b(6000000.0f);
    }

    @SubscribeEvent
    public static void onBlockPlaceEvent(BlockEvent.PlaceEvent event) {
        if (event.getPlacedAgainst() == WizardryBlocks.spectral_block) {
            event.setCanceled(true);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return field_185506_k;
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149637_q(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        for (int i = 0; i < 4; ++i) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK).pos((double)pos.func_177958_n() + random.nextDouble(), (double)pos.func_177956_o() + random.nextDouble(), (double)pos.func_177952_p() + random.nextDouble()).time(5).spawn(world);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity target) {
        TileEntity tile;
        if (target.field_70173_aa % 5 != 0) {
            return;
        }
        if (target instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)target), (Item)ASItems.ring_kinetic)) {
            ((EntityPlayer)target).func_70690_d(new PotionEffect(MobEffects.field_76424_c, 40, 1));
        }
        if ((tile = world.func_175625_s(pos)) instanceof TileEntityLightningBlock) {
            EntityLivingBase caster = ((TileEntityLightningBlock)tile).getCaster();
            if (caster != null && (target == caster || target instanceof EntityLivingBase && AllyDesignationSystem.isAllied((EntityLivingBase)caster, (EntityLivingBase)((EntityLivingBase)target)))) {
                return;
            }
            double velX = target.field_70159_w;
            double velY = target.field_70181_x;
            double velZ = target.field_70179_y;
            target.func_70097_a(caster != null ? MagicDamage.causeIndirectMagicDamage((Entity)caster, (Entity)caster, (MagicDamage.DamageType)MagicDamage.DamageType.SHOCK) : DamageSource.field_76376_m, ((TileEntityLightningBlock)tile).damage);
            target.field_70159_w = velX;
            target.field_70181_x = velY;
            target.field_70179_y = velZ;
        }
    }

    public static void setProperties(World world, BlockPos pos, EntityLivingBase caster, int blockLifetime, float damage) {
        TileEntity tile;
        if (!world.field_72995_K && world.func_180495_p(pos).func_177230_c() == ASBlocks.lightning_block && (tile = world.func_175625_s(pos)) instanceof TileEntityLightningBlock) {
            TileEntityLightningBlock lightningBlock = (TileEntityLightningBlock)tile;
            if (caster != null) {
                lightningBlock.setCaster(caster);
            }
            lightningBlock.setLifetime(blockLifetime);
            lightningBlock.setDamage(damage);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileEntityLightningBlock().setLifetime(600);
    }

    public int func_149745_a(Random par1Random) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        IBlockState iblockstate = blockAccess.func_180495_p(pos.func_177972_a(side));
        Block block = iblockstate.func_177230_c();
        return block == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }
}

