/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.block;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.client.gui.GuiHandlerAS;
import com.windanesz.ancientspellcraft.item.ItemRitualBook;
import com.windanesz.ancientspellcraft.item.ItemSageTome;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import com.windanesz.ancientspellcraft.spell.SpellLecternInteract;
import com.windanesz.ancientspellcraft.tileentity.TileSageLectern;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWrittenBook;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockSageLectern
extends BlockHorizontal
implements ITileEntityProvider {
    public BlockSageLectern() {
        super(Material.field_151576_e);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH));
        this.func_149647_a(ASTabs.ANCIENTSPELLCRAFT);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public static boolean isBookOpen(IBlockState state, World world, BlockPos pos) {
        BlockPos lookUpPos = new BlockPos(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        EnumFacing offset = (EnumFacing)state.func_177229_b((IProperty)BlockHorizontal.field_185512_D);
        if (offset != null) {
            lookUpPos = lookUpPos.func_177972_a(offset);
        }
        EntityPlayer player = world.func_184137_a((double)lookUpPos.func_177958_n() + 0.5, (double)lookUpPos.func_177956_o() + 0.5, (double)lookUpPos.func_177952_p() + 0.5, 1.0, false);
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileSageLectern && player != null && ((TileSageLectern)tile).shouldBookOpen(player);
    }

    public static ItemStack getItemOnLectern(World world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileSageLectern) {
            TileSageLectern lectern = (TileSageLectern)tileentity;
            return lectern.getBookSlotItem();
        }
        return ItemStack.field_190927_a;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer.Builder((Block)this).add(new IProperty[]{field_185512_D}).build();
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (enumfacing.func_176740_k() == EnumFacing.Axis.Y) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)enumfacing);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176745_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        if (BlockSageLectern.isBookOpen(state, world, pos)) {
            int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(((TileSageLectern)world.func_175625_s(pos)).getBookElement());
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos((double)((float)pos.func_177958_n() + rand.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + rand.nextFloat())).vel(0.0, 0.03, 0.0).clr(colours[1]).fade(colours[2]).time(40).shaded(false).spawn(world);
        }
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean canPlaceTorchOnTop(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.DOWN ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    public IBlockState func_180642_a(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)field_185512_D, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rotation) {
        return state.func_177226_a((IProperty)field_185512_D, (Comparable)rotation.func_185831_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirror) {
        return state.func_185907_a(mirror.func_185800_a((EnumFacing)state.func_177229_b((IProperty)field_185512_D)));
    }

    @Nullable
    public TileEntity func_149915_a(World world, int meta) {
        return new TileSageLectern();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState block, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemSageTome && ((ItemSageTome)player.func_184586_b(EnumHand.MAIN_HAND).func_77973_b()).getCurrentSpell(player.func_184586_b(EnumHand.MAIN_HAND)) instanceof SpellLecternInteract) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity == null) {
            return false;
        }
        if (tileEntity instanceof TileSageLectern) {
            TileSageLectern lectern = (TileSageLectern)tileEntity;
            boolean lecternHasItem = lectern.hasItem();
            ItemStack heldStack = player.func_184586_b(hand);
            if (player.func_70093_af()) {
                if (lecternHasItem && heldStack.func_190926_b()) {
                    ASUtils.giveStackToPlayer(player, lectern.getBookSlotItem().func_77946_l());
                    lectern.func_70299_a(0, ItemStack.field_190927_a);
                }
                return true;
            }
            String heldStackRegistryName = heldStack.func_77973_b().getRegistryName().toString();
            if (!lecternHasItem && (heldStack.func_77973_b() instanceof ItemSpellBook || heldStack.func_77973_b() instanceof ItemSageTome || Arrays.asList(Settings.generalSettings.sage_lectern_item_whitelist).contains(heldStackRegistryName))) {
                lectern.func_70299_a(0, player.func_184586_b(hand).func_77979_a(1));
                return true;
            }
            if (!player.func_70093_af()) {
                lectern.getSpellEffects().forEach(effect -> effect.persistentEffectOnLecternClick(lectern, player));
                if (!player.func_70093_af() && lectern.getBookSlotItem().func_77973_b() instanceof ItemSageTome) {
                    if (!lectern.shouldBookOpen(player)) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("tile.ancientspellcraft:sage_lectern.failed_attempt_to_read_tome", new Object[0]), true);
                        return false;
                    }
                    player.openGui((Object)AncientSpellcraft.instance, GuiHandlerAS.SAGE_LECTERN, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                    return true;
                }
                if (lecternHasItem && !(lectern.getBookSlotItem().func_77973_b() instanceof ItemSageTome)) {
                    if (lectern.getBookSlotItem().func_77973_b() instanceof ItemSpellBook || lectern.getBookSlotItem().func_77973_b() instanceof ItemRitualBook) {
                        player.openGui((Object)AncientSpellcraft.instance, GuiHandlerAS.SPELL_GUI_LECTERN, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                        return true;
                    }
                    if (lectern.getBookSlotItem().func_77973_b() instanceof ItemWrittenBook) {
                        AncientSpellcraft.proxy.openBookGUI(player, lectern.getBookSlotItem());
                        player.func_71029_a(StatList.func_188057_b((Item)lectern.getBookSlotItem().func_77973_b()));
                    } else {
                        lectern.getBookSlotItem().func_77973_b().func_77659_a(world, player, EnumHand.MAIN_HAND);
                    }
                    return true;
                }
            }
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState block) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof TileSageLectern) {
            TileSageLectern lectern = (TileSageLectern)tileentity;
            for (int i = 0; i < 2; ++i) {
                ItemStack itemstack = lectern.func_70301_a(i);
                if (itemstack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)world, (double)lectern.func_174877_v().func_177958_n(), (double)lectern.func_174877_v().func_177956_o(), (double)lectern.func_174877_v().func_177952_p(), (ItemStack)itemstack);
            }
        }
        super.func_180663_b(world, pos, block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack itemstack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(itemstack, world, tooltip, advanced);
        if (GameSettings.func_100015_a((KeyBinding)Minecraft.func_71410_x().field_71474_y.field_74311_E)) {
            AncientSpellcraft.proxy.addMultiLineDescription(tooltip, I18n.func_135052_a((String)"tooltip.ancientspellcraft:sage_lectern.more_info", (Object[])new Object[0]), new Object[0]);
        } else {
            tooltip.add(I18n.func_135052_a((String)"tooltip.ancientspellcraft:more_info", (Object[])new Object[0]));
        }
    }
}

