/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.client;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.CommonProxy;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.block.BlockCrystalLeaves;
import com.windanesz.ancientspellcraft.block.BlockMagicMushroom;
import com.windanesz.ancientspellcraft.client.GuiRadialMenu;
import com.windanesz.ancientspellcraft.client.model.ItemColorizer;
import com.windanesz.ancientspellcraft.client.particle.ParticleConstantBeam;
import com.windanesz.ancientspellcraft.client.particle.ParticleSoulChain;
import com.windanesz.ancientspellcraft.client.particle.ParticleTimeKnot;
import com.windanesz.ancientspellcraft.client.renderer.RenderArcaneBarrierEventBased;
import com.windanesz.ancientspellcraft.client.renderer.RenderMerchantWizard;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderAnimatedItem;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderDevoritiumArrow;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderEntityMageLight;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderEvilClassWizard;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderFireSpider;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderMoltenBoulder;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderSkeletonHorseMinion;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderSkeletonMage;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderSpiritBear;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderStoneGuardian;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderVoidCreeper;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderVolcano;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderWisp;
import com.windanesz.ancientspellcraft.client.renderer.entity.RenderWolfMinion;
import com.windanesz.ancientspellcraft.client.renderer.entity.layers.LayerFire;
import com.windanesz.ancientspellcraft.client.renderer.tileentity.RenderArcaneWall;
import com.windanesz.ancientspellcraft.client.renderer.tileentity.RenderRune;
import com.windanesz.ancientspellcraft.client.renderer.tileentity.RenderSageLectern;
import com.windanesz.ancientspellcraft.client.renderer.tileentity.RenderSkullWatch;
import com.windanesz.ancientspellcraft.client.renderer.tileentity.RenderTileSentinel;
import com.windanesz.ancientspellcraft.client.renderer.tileentity.RenderTileSphereCognizance;
import com.windanesz.ancientspellcraft.data.RitualDiscoveryData;
import com.windanesz.ancientspellcraft.entity.EntityMageLight;
import com.windanesz.ancientspellcraft.entity.EntityWisp;
import com.windanesz.ancientspellcraft.entity.construct.EntityAntiMagicField;
import com.windanesz.ancientspellcraft.entity.construct.EntityArcaneBarrier;
import com.windanesz.ancientspellcraft.entity.construct.EntityBarterConstruct;
import com.windanesz.ancientspellcraft.entity.construct.EntityBuilder;
import com.windanesz.ancientspellcraft.entity.construct.EntityHealingSigil;
import com.windanesz.ancientspellcraft.entity.construct.EntityMoltenBoulder;
import com.windanesz.ancientspellcraft.entity.construct.EntitySilencingSigil;
import com.windanesz.ancientspellcraft.entity.construct.EntitySpellTicker;
import com.windanesz.ancientspellcraft.entity.construct.EntitySpiritWard;
import com.windanesz.ancientspellcraft.entity.construct.EntityTransportationPortal;
import com.windanesz.ancientspellcraft.entity.living.EntityAnimatedItem;
import com.windanesz.ancientspellcraft.entity.living.EntityCreeperMinion;
import com.windanesz.ancientspellcraft.entity.living.EntityEvilClassWizard;
import com.windanesz.ancientspellcraft.entity.living.EntityFireAnt;
import com.windanesz.ancientspellcraft.entity.living.EntityPigZombieMinion;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonHorseMinion;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonMage;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonMageMinion;
import com.windanesz.ancientspellcraft.entity.living.EntitySpellCaster;
import com.windanesz.ancientspellcraft.entity.living.EntitySpiritBear;
import com.windanesz.ancientspellcraft.entity.living.EntityStoneGuardian;
import com.windanesz.ancientspellcraft.entity.living.EntityVoidCreeper;
import com.windanesz.ancientspellcraft.entity.living.EntityVolcano;
import com.windanesz.ancientspellcraft.entity.living.EntityWizardMerchant;
import com.windanesz.ancientspellcraft.entity.living.EntityWolfMinion;
import com.windanesz.ancientspellcraft.entity.projectile.EntityAOEProjectile;
import com.windanesz.ancientspellcraft.entity.projectile.EntityContingencyProjectile;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDevoritiumArrow;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDevoritiumBomb;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDispelGreaterMagic;
import com.windanesz.ancientspellcraft.entity.projectile.EntityDispelMagic;
import com.windanesz.ancientspellcraft.entity.projectile.EntityFlint;
import com.windanesz.ancientspellcraft.entity.projectile.EntityHeart;
import com.windanesz.ancientspellcraft.entity.projectile.EntityManaVortex;
import com.windanesz.ancientspellcraft.entity.projectile.EntityMasterBolt;
import com.windanesz.ancientspellcraft.entity.projectile.EntityMetamagicProjectile;
import com.windanesz.ancientspellcraft.entity.projectile.EntitySafeIceShard;
import com.windanesz.ancientspellcraft.entity.projectile.EntityStoneGuardianShard;
import com.windanesz.ancientspellcraft.integration.antiqueatlas.ASAntiqueAtlasIntegration;
import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.packet.PacketContinuousRitual;
import com.windanesz.ancientspellcraft.packet.PacketMushroomActivation;
import com.windanesz.ancientspellcraft.packet.PacketStartRitual;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.tileentity.TileArcaneWall;
import com.windanesz.ancientspellcraft.tileentity.TileRune;
import com.windanesz.ancientspellcraft.tileentity.TileSageLectern;
import com.windanesz.ancientspellcraft.tileentity.TileSentinel;
import com.windanesz.ancientspellcraft.tileentity.TileSkullWatch;
import com.windanesz.ancientspellcraft.tileentity.TileSphereCognizance;
import com.windanesz.ancientspellcraft.util.ASParticles;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.client.gui.handbook.GuiWizardHandbook;
import electroblob.wizardry.client.particle.ParticleWizardry;
import electroblob.wizardry.client.renderer.entity.RenderBlank;
import electroblob.wizardry.client.renderer.entity.RenderMagicArrow;
import electroblob.wizardry.client.renderer.entity.RenderProjectile;
import electroblob.wizardry.client.renderer.entity.RenderSigil;
import electroblob.wizardry.client.renderer.entity.layers.LayerTiledOverlay;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.spell.Spell;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiScreenBook;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.entity.RenderCreeper;
import net.minecraft.client.renderer.entity.RenderPigZombie;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(value={Side.CLIENT})
public class ClientProxy
extends CommonProxy {
    private static final int TOOLTIP_WRAP_WIDTH = 140;
    public static KeyBinding KEY_ACTIVATE_CHARM_BAUBLE;
    public static KeyBinding KEY_ACTIVATE_RING1_BAUBLE;
    public static KeyBinding KEY_ACTIVATE_RING2_BAUBLE;
    public static KeyBinding KEY_ACTIVATE_RADIAL_SPELL_MENU;

    @SubscribeEvent
    public static void handleKeys(InputEvent ev) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!Settings.clientSettings.radial_menu_enabled) {
            return;
        }
        while (KEY_ACTIVATE_RADIAL_SPELL_MENU.func_151468_f()) {
            ItemStack inHand;
            if (mc.field_71462_r != null || !((inHand = mc.field_71439_g.func_184614_ca()).func_77973_b() instanceof ISpellCastingItem)) continue;
            mc.func_147108_a((GuiScreen)new GuiRadialMenu(inHand));
        }
    }

    static void wipeOpen() {
        while (KEY_ACTIVATE_RADIAL_SPELL_MENU.func_151468_f()) {
        }
    }

    @Override
    public void initialiseLayers() {
        LayerTiledOverlay.initialiseLayers(LayerFire::new);
    }

    @Override
    public void init() {
        this.registerKeybindings();
        ItemColorizer.init();
    }

    private void registerKeybindings() {
        KEY_ACTIVATE_RADIAL_SPELL_MENU = new KeyBinding("key.ancientspellcraft.open_radial_spell_menu", 19, "key.ancientspellcraft.category");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_ACTIVATE_RADIAL_SPELL_MENU);
        KEY_ACTIVATE_CHARM_BAUBLE = new KeyBinding("key.ancientspellcraft.charm_bauble_activate", 37, "key.ancientspellcraft.category");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_ACTIVATE_CHARM_BAUBLE);
        KEY_ACTIVATE_RING1_BAUBLE = new KeyBinding("key.ancientspellcraft.charm_ring_1_activate", 22, "key.ancientspellcraft.category");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_ACTIVATE_RING1_BAUBLE);
        KEY_ACTIVATE_RING2_BAUBLE = new KeyBinding("key.ancientspellcraft.charm_ring_2_activate", 36, "key.ancientspellcraft.category");
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_ACTIVATE_RING2_BAUBLE);
    }

    @Override
    public void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityWisp.class, manager -> new RenderWisp(manager, 0.7f, new ResourceLocation("ancientspellcraft", "textures/entity/wisp.png"), true));
        RenderingRegistry.registerEntityRenderingHandler(EntityMageLight.class, manager -> new RenderEntityMageLight(manager, 0.7f, new ResourceLocation("ancientspellcraft", "textures/entity/wisp.png"), true));
        RenderingRegistry.registerEntityRenderingHandler(EntityVoidCreeper.class, RenderVoidCreeper::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySkeletonMageMinion.class, RenderSkeletonMage::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySkeletonMage.class, RenderSkeletonMage::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySkeletonHorseMinion.class, RenderSkeletonHorseMinion::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityWolfMinion.class, RenderWolfMinion::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiritBear.class, RenderSpiritBear::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityFireAnt.class, RenderFireSpider::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityCreeperMinion.class, RenderCreeper::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityPigZombieMinion.class, RenderPigZombie::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStoneGuardian.class, RenderStoneGuardian::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityVolcano.class, RenderVolcano::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDispelMagic.class, manager -> new RenderProjectile(manager, 0.4f, new ResourceLocation("ancientspellcraft", "textures/entity/dispel_magic.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityDispelGreaterMagic.class, manager -> new RenderProjectile(manager, 0.7f, new ResourceLocation("ancientspellcraft", "textures/entity/dispel_magic.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityContingencyProjectile.class, manager -> new RenderProjectile(manager, 0.7f, new ResourceLocation("ancientspellcraft", "textures/entity/contingency_projectile.png"), true));
        RenderingRegistry.registerEntityRenderingHandler(EntityMetamagicProjectile.class, manager -> new RenderProjectile(manager, 0.7f, new ResourceLocation("ancientspellcraft", "textures/entity/dispel_magic.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityHeart.class, manager -> new RenderProjectile(manager, 0.7f, new ResourceLocation("ancientspellcraft", "textures/entity/healing_heart.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityDevoritiumBomb.class, manager -> new RenderProjectile(manager, 0.6f, new ResourceLocation("ancientspellcraft", "textures/items/devoritium_bomb.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntityFlint.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ancientspellcraft", "textures/entity/flint_shard.png"), false, 6.0, 1.0, 9, 8, true));
        RenderingRegistry.registerEntityRenderingHandler(EntityAOEProjectile.class, manager -> new RenderProjectile(manager, 0.7f, new ResourceLocation("ancientspellcraft", "textures/entity/aoe_projectile.png"), false));
        RenderingRegistry.registerEntityRenderingHandler(EntitySafeIceShard.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/ice_shard.png"), false, 8.0, 2.0, 16, 5, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityMasterBolt.class, manager -> new RenderMagicArrow(manager, new ResourceLocation("ebwizardry", "textures/entity/lightning_arrow.png"), true, 8.0, 2.0, 16, 5, false));
        ClientRegistry.bindTileEntitySpecialRenderer(TileSphereCognizance.class, (TileEntitySpecialRenderer)new RenderTileSphereCognizance());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSkullWatch.class, (TileEntitySpecialRenderer)new RenderSkullWatch());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSentinel.class, (TileEntitySpecialRenderer)new RenderTileSentinel());
        ClientRegistry.bindTileEntitySpecialRenderer(TileRune.class, (TileEntitySpecialRenderer)new RenderRune());
        ClientRegistry.bindTileEntitySpecialRenderer(TileSageLectern.class, (TileEntitySpecialRenderer)new RenderSageLectern());
        ClientRegistry.bindTileEntitySpecialRenderer(TileArcaneWall.class, (TileEntitySpecialRenderer)new RenderArcaneWall());
        RenderingRegistry.registerEntityRenderingHandler(EntityTransportationPortal.class, manager -> new RenderSigil(manager, new ResourceLocation("ancientspellcraft", "textures/entity/transportation_portal.png"), 0.0f, false));
        RenderingRegistry.registerEntityRenderingHandler(EntitySpiritWard.class, manager -> new RenderSigil(manager, new ResourceLocation("ancientspellcraft", "textures/entity/spirit_ward.png"), 0.0f, false));
        RenderingRegistry.registerEntityRenderingHandler(EntitySilencingSigil.class, manager -> new RenderSigil(manager, new ResourceLocation("ancientspellcraft", "textures/entity/silencing_sigil.png"), 0.0f, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityHealingSigil.class, manager -> new RenderSigil(manager, new ResourceLocation("ancientspellcraft", "textures/entity/healing_sigil.png"), 0.0f, false));
        RenderingRegistry.registerEntityRenderingHandler(EntityAntiMagicField.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityManaVortex.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityDevoritiumArrow.class, RenderDevoritiumArrow::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellCaster.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityWizardMerchant.class, RenderMerchantWizard::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityEvilClassWizard.class, RenderEvilClassWizard::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBarterConstruct.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntitySpellTicker.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityBuilder.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityAnimatedItem.class, RenderAnimatedItem::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityArcaneBarrier.class, RenderBlank::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityMoltenBoulder.class, RenderMoltenBoulder::new);
        RenderingRegistry.registerEntityRenderingHandler(EntityStoneGuardianShard.class, manager -> new RenderProjectile(manager, 0.15f, new ResourceLocation("ancientspellcraft", "textures/entity/stone_guardian_shard.png"), false));
    }

    @Override
    public void registerParticles() {
        ParticleWizardry.registerParticle((ResourceLocation)ASParticles.SOUL_CHAIN, ParticleSoulChain::new);
        ParticleWizardry.registerParticle((ResourceLocation)ASParticles.TIME_KNOT, ParticleTimeKnot::new);
        ParticleWizardry.registerParticle((ResourceLocation)ASParticles.CONSTANT_BEAM, ParticleConstantBeam::new);
    }

    @Override
    public void setGraphicsLevel(BlockCrystalLeaves block, boolean fancyEnabled) {
        block.func_150122_b(fancyEnabled);
    }

    @Override
    public void handleRitualStartPacket(PacketStartRitual.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity caster = world.func_73045_a(message.casterID);
        Ritual ritual = Ritual.byNetworkID(message.ritualID);
        if (caster instanceof EntityPlayer) {
            BlockPos centerPos = new BlockPos(message.x, message.y, message.z);
            if (world.func_175625_s(centerPos) instanceof TileRune) {
                TileRune centerPiece = (TileRune)world.func_175625_s(centerPos);
                ritual.initialEffect((World)world, (EntityPlayer)caster, centerPiece);
            }
        } else {
            Wizardry.logger.warn("Receieved a PacketStartRitual, but the caster ID was not the ID of a player");
        }
    }

    @Override
    public void handleContinuousRitualPacket(PacketContinuousRitual.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity caster = world.func_73045_a(message.casterID);
        Ritual ritual = Ritual.byNetworkID(message.ritualID);
        if (caster instanceof EntityPlayer) {
            BlockPos centerPos = new BlockPos(message.x, message.y, message.z);
            if (world.func_175625_s(centerPos) instanceof TileRune) {
                TileRune centerPiece = (TileRune)world.func_175625_s(centerPos);
                ritual.effect((World)world, (EntityPlayer)caster, centerPiece);
            }
        } else {
            Wizardry.logger.warn("Receieved a PacketStartRitual, but the caster ID was not the ID of a player");
        }
    }

    @Override
    public boolean shouldDisplayDiscovered(Ritual ritual, @Nullable ItemStack stack) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return false;
        }
        if (player.func_184812_l_()) {
            return true;
        }
        return WizardData.get((EntityPlayer)player) != null && RitualDiscoveryData.hasRitualBeenDiscovered((EntityPlayer)player, ritual);
    }

    @Override
    public String translate(String key, Style style, Object ... args) {
        return style.func_150218_j() + I18n.func_135052_a((String)key, (Object[])args);
    }

    @Override
    public void handleRemoveBarrier(EntityArcaneBarrier entityArcaneBarrier) {
        RenderArcaneBarrierEventBased.barrierList.remove((Object)entityArcaneBarrier);
    }

    @Override
    public void handleAddBarrier(EntityArcaneBarrier entityArcaneBarrier) {
        if (!RenderArcaneBarrierEventBased.barrierList.contains((Object)entityArcaneBarrier) && Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71439_g.field_71093_bK == entityArcaneBarrier.field_71093_bK) {
            RenderArcaneBarrierEventBased.barrierList.add(entityArcaneBarrier);
        }
    }

    @Override
    public void addMultiLineDescription(List<String> tooltip, String key, Style style, Object ... args) {
        tooltip.addAll(Minecraft.func_71410_x().field_71466_p.func_78271_c(this.translate(key, style, args), 140));
    }

    @Override
    public void handleMushroomActivationPacket(PacketMushroomActivation.Message message) {
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        BlockPos pos = message.pos;
        Block block = world.func_180495_p(pos).func_177230_c();
        Entity entity = world.func_73045_a(message.activatorEntityID);
        if (block instanceof BlockMagicMushroom && message.activatorEntityID != -1 && entity != null) {
            ((BlockMagicMushroom)block).applyEffect((World)world, block, pos, world.func_180495_p(pos), entity);
        }
    }

    @Override
    public String getIceCreamDisplayName(ItemStack stack) {
        String potionString;
        Potion potion;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("potion") && (potion = (Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(potionString = stack.func_77978_p().func_74779_i("potion")))) != null) {
            String potionDisplayName = I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]);
            return I18n.func_135052_a((String)"item.ancientspellcraft:ice_cream.potion_name", (Object[])new Object[]{potionDisplayName}).trim();
        }
        return net.minecraft.util.text.translation.I18n.func_74838_a((String)"item.ancientspellcraft:ice_cream.name").trim();
    }

    @Override
    public void registerAtlasMarkers() {
        ASAntiqueAtlasIntegration.registerMarkers();
    }

    @Override
    public void initialiseAnimations() {
    }

    @Override
    public void checkTranslationKeys() {
        String localizedDesc;
        String nameKey;
        String registryName;
        if (!FMLLaunchHandler.isDeobfuscatedEnvironment()) {
            return;
        }
        Collection spells = Spell.getSpellNames();
        for (ResourceLocation resourceLocation : spells) {
            registryName = resourceLocation.toString();
            nameKey = "spell." + registryName;
            String descKey = nameKey + ".desc";
            String localizedName = I18n.func_135052_a((String)nameKey, (Object[])new Object[0]);
            localizedDesc = I18n.func_135052_a((String)descKey, (Object[])new Object[0]);
            if (nameKey.equals(localizedName)) {
                this.missingKeyWarning("Spell", registryName, nameKey);
            }
            if (!descKey.equals(localizedDesc)) continue;
            this.missingKeyWarning("Spell", registryName, descKey);
        }
        for (Item item : Item.field_150901_e) {
            String descKey;
            String localizedName;
            if (!item.getRegistryName().func_110624_b().equals("ancientspellcraft")) continue;
            registryName = item.getRegistryName().toString();
            nameKey = "item." + registryName + ".name";
            if (item instanceof ItemBlock) {
                nameKey = "tile." + registryName + ".name";
            }
            if (nameKey.equals(localizedName = I18n.func_135052_a((String)nameKey, (Object[])new Object[0]))) {
                this.missingKeyWarning("Item", registryName, nameKey);
            }
            if (!(item instanceof ItemArtefact) && !(item instanceof ItemNewArtefact) || !(descKey = "item." + registryName + ".desc").equals(localizedDesc = I18n.func_135052_a((String)descKey, (Object[])new Object[0]))) continue;
            this.missingKeyWarning("Artefact", registryName, descKey);
        }
    }

    private void missingKeyWarning(String type, String registryName, String expectedKey) {
        AncientSpellcraft.logger.warn(type + " " + registryName + " is missing a translation key: \"" + expectedKey + "\"");
    }

    @Override
    public void openBookGUI(EntityPlayer player, ItemStack book) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiScreenBook((EntityPlayer)Minecraft.func_71410_x().field_71439_g, book, false));
    }

    @Override
    public void registerExtraHandbookContent() {
        GuiWizardHandbook.registerAddonHandbookContent((String)"ancientspellcraft");
    }
}

