/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.constants;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;

public enum EnumFacingIntercardinal implements IStringSerializable
{
    DOWN(0, 1, -1, "down", AxisDirection.NEGATIVE, Axis.Y, new Vec3i(0, -1, 0)),
    UP(1, 0, -1, "up", AxisDirection.POSITIVE, Axis.Y, new Vec3i(0, 1, 0)),
    NORTH(2, 3, 2, "north", AxisDirection.NEGATIVE, Axis.Z, new Vec3i(0, 0, -1)),
    SOUTH(3, 2, 0, "south", AxisDirection.POSITIVE, Axis.Z, new Vec3i(0, 0, 1)),
    WEST(4, 5, 1, "west", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 0)),
    EAST(5, 4, 3, "east", AxisDirection.POSITIVE, Axis.X, new Vec3i(1, 0, 0)),
    NORTHEAST(6, 8, 4, "northeast", AxisDirection.NEGATIVE, Axis.X, new Vec3i(1, 0, -1)),
    SOUTHEAST(7, 9, 5, "southeast", AxisDirection.NEGATIVE, Axis.X, new Vec3i(1, 0, 1)),
    SOUTHWEST(8, 6, 6, "southwest", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, 1)),
    NORTHWEST(9, 7, 7, "northwest", AxisDirection.NEGATIVE, Axis.X, new Vec3i(-1, 0, -1));

    private final int index;
    private final int opposite;
    private final int horizontalIndex;
    private final String name;
    private final Axis axis;
    private final AxisDirection axisDirection;
    private final Vec3i directionVec;
    public static final EnumFacingIntercardinal[] VALUES;
    public static final EnumFacingIntercardinal[] HORIZONTALS;
    private static final Map<String, EnumFacingIntercardinal> NAME_LOOKUP;

    private EnumFacingIntercardinal(int indexIn, int oppositeIn, int horizontalIndexIn, String nameIn, AxisDirection axisDirectionIn, Axis axisIn, Vec3i directionVecIn) {
        this.index = indexIn;
        this.horizontalIndex = horizontalIndexIn;
        this.opposite = oppositeIn;
        this.name = nameIn;
        this.axis = axisIn;
        this.axisDirection = axisDirectionIn;
        this.directionVec = directionVecIn;
    }

    public int getIndex() {
        return this.index;
    }

    public int getHorizontalIndex() {
        return this.horizontalIndex;
    }

    public AxisDirection getAxisDirection() {
        return this.axisDirection;
    }

    public EnumFacingIntercardinal getOpposite() {
        return EnumFacingIntercardinal.byIndex(this.opposite);
    }

    public EnumFacingIntercardinal rotateAround(Axis axis) {
        switch (axis) {
            case X: {
                if (this != WEST && this != EAST) {
                    return this.rotateX();
                }
                return this;
            }
            case Y: {
                if (this != UP && this != DOWN) {
                    return this.rotateY();
                }
                return this;
            }
            case Z: {
                if (this != NORTH && this != SOUTH) {
                    return this.rotateZ();
                }
                return this;
            }
        }
        throw new IllegalStateException("Unable to get CW facing for axis " + (Object)((Object)axis));
    }

    public EnumFacingIntercardinal rotateY() {
        switch (this) {
            case NORTH: {
                return EAST;
            }
            case EAST: {
                return SOUTH;
            }
            case SOUTH: {
                return WEST;
            }
            case WEST: {
                return NORTH;
            }
        }
        throw new IllegalStateException("Unable to get Y-rotated facing of " + (Object)((Object)this));
    }

    private EnumFacingIntercardinal rotateX() {
        switch (this) {
            case NORTH: {
                return DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get X-rotated facing of " + (Object)((Object)this));
            }
            case SOUTH: {
                return UP;
            }
            case UP: {
                return NORTH;
            }
            case DOWN: 
        }
        return SOUTH;
    }

    private EnumFacingIntercardinal rotateZ() {
        switch (this) {
            case EAST: {
                return DOWN;
            }
            default: {
                throw new IllegalStateException("Unable to get Z-rotated facing of " + (Object)((Object)this));
            }
            case WEST: {
                return UP;
            }
            case UP: {
                return EAST;
            }
            case DOWN: 
        }
        return WEST;
    }

    public EnumFacingIntercardinal rotateYCCW() {
        switch (this) {
            case NORTH: {
                return WEST;
            }
            case EAST: {
                return NORTH;
            }
            case SOUTH: {
                return EAST;
            }
            case WEST: {
                return SOUTH;
            }
        }
        throw new IllegalStateException("Unable to get CCW facing of " + (Object)((Object)this));
    }

    public int getXOffset() {
        switch (this) {
            case NORTHEAST: {
                return 1;
            }
            case SOUTHEAST: {
                return 1;
            }
            case SOUTHWEST: {
                return -1;
            }
            case NORTHWEST: {
                return -1;
            }
        }
        return this.axis == Axis.X ? this.axisDirection.getOffset() : 0;
    }

    public int getYOffset() {
        switch (this) {
            case NORTHEAST: {
                return 0;
            }
            case SOUTHEAST: {
                return 0;
            }
            case SOUTHWEST: {
                return 0;
            }
            case NORTHWEST: {
                return 0;
            }
        }
        return this.axis == Axis.Y ? this.axisDirection.getOffset() : 0;
    }

    public int getZOffset() {
        switch (this) {
            case NORTHEAST: {
                return -1;
            }
            case SOUTHEAST: {
                return 1;
            }
            case SOUTHWEST: {
                return 1;
            }
            case NORTHWEST: {
                return -1;
            }
        }
        return this.axis == Axis.Z ? this.axisDirection.getOffset() : 0;
    }

    public String getName2() {
        return this.name;
    }

    public Axis getAxis() {
        return this.axis;
    }

    @Nullable
    public static EnumFacingIntercardinal byName(String name) {
        return name == null ? null : NAME_LOOKUP.get(name.toLowerCase(Locale.ROOT));
    }

    public static EnumFacingIntercardinal byIndex(int index) {
        return VALUES[MathHelper.func_76130_a((int)(index % VALUES.length))];
    }

    public static EnumFacingIntercardinal byHorizontalIndex(int horizontalIndexIn) {
        return HORIZONTALS[MathHelper.func_76130_a((int)(horizontalIndexIn % HORIZONTALS.length))];
    }

    public static EnumFacingIntercardinal fromAngle(double angle) {
        return EnumFacingIntercardinal.byHorizontalIndex(MathHelper.func_76128_c((double)(angle / 90.0 + 0.5)) & 3);
    }

    public float getHorizontalAngle() {
        return (this.horizontalIndex & 3) * 90;
    }

    public static EnumFacingIntercardinal random(Random rand) {
        return EnumFacingIntercardinal.values()[rand.nextInt(EnumFacingIntercardinal.values().length)];
    }

    public static EnumFacingIntercardinal getFacingFromVector(float x, float y, float z) {
        EnumFacingIntercardinal enumfacing = NORTH;
        float f = Float.MIN_VALUE;
        for (EnumFacingIntercardinal enumfacing1 : EnumFacingIntercardinal.values()) {
            float f1 = x * (float)enumfacing1.directionVec.func_177958_n() + y * (float)enumfacing1.directionVec.func_177956_o() + z * (float)enumfacing1.directionVec.func_177952_p();
            if (!(f1 > f)) continue;
            f = f1;
            enumfacing = enumfacing1;
        }
        return enumfacing;
    }

    public String toString() {
        return this.name;
    }

    public String func_176610_l() {
        return this.name;
    }

    public static EnumFacingIntercardinal getFacingFromAxis(AxisDirection axisDirectionIn, Axis axisIn) {
        for (EnumFacingIntercardinal enumfacing : EnumFacingIntercardinal.values()) {
            if (enumfacing.getAxisDirection() != axisDirectionIn || enumfacing.getAxis() != axisIn) continue;
            return enumfacing;
        }
        throw new IllegalArgumentException("No such direction: " + (Object)((Object)axisDirectionIn) + " " + (Object)((Object)axisIn));
    }

    public Vec3i getDirectionVec() {
        return this.directionVec;
    }

    static {
        VALUES = new EnumFacingIntercardinal[10];
        HORIZONTALS = new EnumFacingIntercardinal[8];
        NAME_LOOKUP = Maps.newHashMap();
        EnumFacingIntercardinal[] enumFacingIntercardinalArray = EnumFacingIntercardinal.values();
        int n = enumFacingIntercardinalArray.length;
        for (int i = 0; i < n; ++i) {
            EnumFacingIntercardinal enumfacing;
            EnumFacingIntercardinal.VALUES[enumfacing.index] = enumfacing = enumFacingIntercardinalArray[i];
            if (enumfacing.getAxis().isHorizontal()) {
                EnumFacingIntercardinal.HORIZONTALS[enumfacing.horizontalIndex] = enumfacing;
            }
            NAME_LOOKUP.put(enumfacing.getName2().toLowerCase(Locale.ROOT), enumfacing);
        }
    }

    public static enum Plane implements Predicate<EnumFacingIntercardinal>,
    Iterable<EnumFacingIntercardinal>
    {
        HORIZONTAL,
        VERTICAL;


        public EnumFacingIntercardinal[] facings() {
            switch (this) {
                case HORIZONTAL: {
                    return new EnumFacingIntercardinal[]{NORTH, EAST, SOUTH, WEST};
                }
                case VERTICAL: {
                    return new EnumFacingIntercardinal[]{UP, DOWN};
                }
            }
            throw new Error("Someone's been tampering with the universe!");
        }

        public EnumFacingIntercardinal random(Random rand) {
            EnumFacingIntercardinal[] aenumfacing = this.facings();
            return aenumfacing[rand.nextInt(aenumfacing.length)];
        }

        public boolean apply(@Nullable EnumFacingIntercardinal p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_.getAxis().getPlane() == this;
        }

        @Override
        public Iterator<EnumFacingIntercardinal> iterator() {
            return Iterators.forArray((Object[])this.facings());
        }
    }

    public static enum AxisDirection {
        POSITIVE(1, "Towards positive"),
        NEGATIVE(-1, "Towards negative");

        private final int offset;
        private final String description;

        private AxisDirection(int offset, String description) {
            this.offset = offset;
            this.description = description;
        }

        public int getOffset() {
            return this.offset;
        }

        public String toString() {
            return this.description;
        }
    }

    public static enum Axis implements Predicate<EnumFacingIntercardinal>,
    IStringSerializable
    {
        X("x", Plane.HORIZONTAL),
        Y("y", Plane.VERTICAL),
        Z("z", Plane.HORIZONTAL);

        private static final Map<String, Axis> NAME_LOOKUP;
        private final String name;
        private final Plane plane;

        private Axis(String name, Plane plane) {
            this.name = name;
            this.plane = plane;
        }

        @Nullable
        public static Axis byName(String name) {
            return name == null ? null : NAME_LOOKUP.get(name.toLowerCase(Locale.ROOT));
        }

        public String getName2() {
            return this.name;
        }

        public boolean isVertical() {
            return this.plane == Plane.VERTICAL;
        }

        public boolean isHorizontal() {
            return this.plane == Plane.HORIZONTAL;
        }

        public String toString() {
            return this.name;
        }

        public boolean apply(@Nullable EnumFacingIntercardinal p_apply_1_) {
            return p_apply_1_ != null && p_apply_1_.getAxis() == this;
        }

        public Plane getPlane() {
            return this.plane;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            NAME_LOOKUP = Maps.newHashMap();
            for (Axis enumfacing$axis : Axis.values()) {
                NAME_LOOKUP.put(enumfacing$axis.getName2().toLowerCase(Locale.ROOT), enumfacing$axis);
            }
        }
    }
}

