/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.JsonUtils;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class SpellCategorization {
    private static final Gson gson = new Gson();
    private static HashMap<Spell, SpellCategory> spellCategoryHashMap = new HashMap();
    private static HashMap<SpellCategory, List<Spell>> categorisedSpells = new HashMap<SpellCategory, List<Spell>>(){
        {
            this.put(SpellCategory.UNCATEGORISED, new ArrayList());
            this.put(SpellCategory.DISENGAGE, new ArrayList());
            this.put(SpellCategory.DISABLE, new ArrayList());
            this.put(SpellCategory.RANGED_ATTACK, new ArrayList());
            this.put(SpellCategory.CLOSE_COMBAT, new ArrayList());
            this.put(SpellCategory.CURSE, new ArrayList());
            this.put(SpellCategory.MINION, new ArrayList());
            this.put(SpellCategory.BUFF, new ArrayList());
            this.put(SpellCategory.LIFE_SAVING, new ArrayList());
        }
    };

    private SpellCategorization() {
    }

    public static SpellCategory getCategoryFor(Spell spell) {
        return spellCategoryHashMap.getOrDefault(spell, SpellCategory.UNCATEGORISED);
    }

    public static Spell getRandomSpellForCategory(SpellCategory category) {
        if (categorisedSpells.get((Object)category).size() > 0) {
            return categorisedSpells.get((Object)category).get(AncientSpellcraft.rand.nextInt(categorisedSpells.get((Object)category).size()) - 1);
        }
        return Spells.none;
    }

    public static List<Spell> getSpellsForCategory(SpellCategory category) {
        return new ArrayList<Spell>((Collection)categorisedSpells.get((Object)category));
    }

    public static void init() {
        SpellCategorization.loadSpellData();
    }

    private static boolean loadSpellData() {
        ModContainer mod = Loader.instance().getModList().stream().filter(m -> m.getModId().equals("ancientspellcraft")).findFirst().orElse(null);
        boolean success = CraftingHelper.findFiles((ModContainer)mod, (String)"assets/ancientspellcraft/spelldata", null, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString())) || relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            BufferedReader reader = null;
            try {
                reader = Files.newBufferedReader(file);
                JsonObject json = (JsonObject)JsonUtils.func_193839_a((Gson)gson, (Reader)reader, JsonObject.class);
                JsonObject enabled = JsonUtils.func_152754_s((JsonObject)json, (String)"spells");
                for (Map.Entry entry : enabled.entrySet()) {
                    Spell spell = Spell.get((String)((String)entry.getKey()));
                    if (spell == null) continue;
                    String category = ((JsonElement)entry.getValue()).getAsString();
                    if (!Arrays.stream(SpellCategory.values()).anyMatch(v -> v.toString().toLowerCase().equals(category.toLowerCase()))) continue;
                    SpellCategory spellCategory = SpellCategory.valueOf(category.toUpperCase());
                    spellCategoryHashMap.put(spell, spellCategory);
                    categorisedSpells.get((Object)spellCategory).add(spell);
                }
            }
            catch (JsonParseException jsonparseexception) {
                AncientSpellcraft.logger.error("Parsing error loading spell data property file " + file, (Throwable)jsonparseexception);
                Boolean bl = false;
                return bl;
            }
            catch (IOException ioexception) {
                AncientSpellcraft.logger.error("Couldn't read spell data property file " + file, (Throwable)ioexception);
                Boolean bl = false;
                return bl;
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
            return true;
        }, (boolean)true, (boolean)true);
        return success;
    }

    public static enum SpellCategory {
        UNCATEGORISED,
        DISENGAGE,
        DISABLE,
        RANGED_ATTACK,
        CLOSE_COMBAT,
        CURSE,
        MINION,
        BUFF,
        LIFE_SAVING;

    }
}

