/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.ai;

import com.windanesz.ancientspellcraft.util.SpellcastUtils;
import electroblob.wizardry.constants.SpellType;
import electroblob.wizardry.entity.living.ISpellCaster;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.packet.PacketNPCCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.spell.SpellMinion;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class EntityAIAttackSpellWithCost<T extends EntityLiving>
extends EntityAIBase {
    private final T attacker;
    private EntityLivingBase target;
    private int cooldown = -1;
    private final int baseCooldown;
    private int continuousSpellTimer;
    private boolean proxyBuffs;
    private final int continuousSpellDuration;
    private final double speed;
    private int seeTime;
    private final float maxAttackDistance;

    public EntityAIAttackSpellWithCost(T attacker, double speed, float maxDistance, int baseCooldown, int continuousSpellDuration, boolean proxyBuffs) {
        this.attacker = attacker;
        this.baseCooldown = baseCooldown;
        this.continuousSpellDuration = continuousSpellDuration;
        this.speed = speed;
        this.maxAttackDistance = maxDistance * maxDistance;
        this.proxyBuffs = proxyBuffs;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        this.target = entitylivingbase;
        return true;
    }

    public boolean func_75253_b() {
        return this.func_75250_a() || !this.attacker.func_70661_as().func_75500_f();
    }

    public void func_75251_c() {
        this.target = null;
        this.seeTime = 0;
        this.cooldown = -1;
        this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
        this.continuousSpellTimer = 0;
    }

    private void setContinuousSpellAndNotify(Spell spell, SpellModifiers modifiers) {
        ((ISpellCaster)this.attacker).setContinuousSpell(spell);
        WizardryPacketHandler.net.sendToAllAround((IMessage)new PacketNPCCastSpell.Message(this.attacker.func_145782_y(), this.target == null ? -1 : this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers), new NetworkRegistry.TargetPoint(((EntityLiving)this.attacker).field_71093_bK, ((EntityLiving)this.attacker).field_70165_t, ((EntityLiving)this.attacker).field_70163_u, ((EntityLiving)this.attacker).field_70161_v, 128.0));
    }

    public void func_75246_d() {
        double distanceSq = this.attacker.func_70092_e(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v);
        boolean targetIsVisible = this.attacker.func_70635_at().func_75522_a((Entity)this.target);
        this.seeTime = targetIsVisible ? ++this.seeTime : 0;
        if (distanceSq <= (double)this.maxAttackDistance && this.seeTime >= 20) {
            this.attacker.func_70661_as().func_75499_g();
        } else {
            this.attacker.func_70661_as().func_75497_a((Entity)this.target, this.speed);
        }
        this.attacker.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
        if (this.continuousSpellTimer > 0) {
            if (this.target == null || this.target.field_70128_L) {
                this.func_75251_c();
            }
            --this.continuousSpellTimer;
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible || MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Tick(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), this.attacker, ((ISpellCaster)this.attacker).getModifiers(), this.continuousSpellDuration - this.continuousSpellTimer)) || !((ISpellCaster)this.attacker).getContinuousSpell().cast(((EntityLiving)this.attacker).field_70170_p, this.attacker, EnumHand.MAIN_HAND, this.continuousSpellDuration - this.continuousSpellTimer, this.target, ((ISpellCaster)this.attacker).getModifiers()) || this.continuousSpellTimer == 0) {
                this.continuousSpellTimer = 0;
                this.cooldown = ((ISpellCaster)this.attacker).getContinuousSpell().getCooldown() + this.baseCooldown;
                this.setContinuousSpellAndNotify(Spells.none, new SpellModifiers());
                return;
            }
            if (this.continuousSpellDuration - this.continuousSpellTimer == 1) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, ((ISpellCaster)this.attacker).getContinuousSpell(), this.attacker, ((ISpellCaster)this.attacker).getModifiers()));
            }
        } else if (--this.cooldown == 0) {
            if (distanceSq > (double)this.maxAttackDistance || !targetIsVisible) {
                return;
            }
            double dx = this.target.field_70165_t - ((EntityLiving)this.attacker).field_70165_t;
            double dz = this.target.field_70161_v - ((EntityLiving)this.attacker).field_70161_v;
            ArrayList<Spell> spells = new ArrayList<Spell>(((ISpellCaster)this.attacker).getSpells());
            spells.removeIf(spell -> spell == Spells.none);
            if (spells.size() > 0 && !((EntityLiving)this.attacker).field_70170_p.field_72995_K) {
                while (!spells.isEmpty()) {
                    Spell spell2 = (Spell)spells.get(((EntityLiving)this.attacker).field_70170_p.field_73012_v.nextInt(spells.size()));
                    if (this.attacker.func_184614_ca().func_77973_b() instanceof ItemWand) {
                        ItemStack wandStack = this.attacker.func_184614_ca();
                        int requiredMana = spell2.getCost();
                        int currentMana = ((ItemWand)wandStack.func_77973_b()).getMana(wandStack);
                        if (currentMana < requiredMana) {
                            spells.remove(spell2);
                        }
                    }
                    if (this.proxyBuffs && (spell2 instanceof SpellBuff || spell2.getType() == SpellType.BUFF || spell2.getType() == SpellType.DEFENCE) && this.attacker instanceof ISummonedCreature && ((ISummonedCreature)this.attacker).getCaster() != null && this.attacker.func_70032_d((Entity)((ISummonedCreature)this.attacker).getCaster()) < 20.0f) {
                        EntityLiving living;
                        if (((ISummonedCreature)this.attacker).getCaster() instanceof EntityPlayer) {
                            EntityPlayer player = (EntityPlayer)((ISummonedCreature)this.attacker).getCaster();
                            if (SpellcastUtils.tryCastSpellAsPlayer(player, spell2, EnumHand.MAIN_HAND, SpellCastEvent.Source.WAND, new SpellModifiers(), 60)) {
                                this.cooldown = this.baseCooldown + spell2.getCooldown() * 2;
                            }
                        } else if (((ISummonedCreature)this.attacker).getCaster() instanceof EntityLiving && SpellcastUtils.tryCastSpellAsMob(living = (EntityLiving)((ISummonedCreature)this.attacker).getCaster(), spell2, null)) {
                            this.cooldown = this.baseCooldown + spell2.getCooldown() * 2;
                        }
                    }
                    SpellModifiers modifiers = ((ISpellCaster)this.attacker).getModifiers();
                    if (spell2 != null && this.attemptCastSpell(spell2, modifiers)) {
                        ((EntityLiving)this.attacker).field_70177_z = (float)(Math.atan2(dz, dx) * 180.0 / Math.PI) - 90.0f;
                        if (spell2 instanceof SpellMinion && ((ISummonedCreature)this.attacker).getCaster() != null) {
                            double radius = spell2.getProperty("summon_radius").floatValue() + 1.0f;
                            for (EntityLivingBase entity : EntityUtils.getEntitiesWithinRadius((double)radius, (double)((EntityLiving)this.attacker).field_70165_t, (double)((EntityLiving)this.attacker).field_70163_u, (double)((EntityLiving)this.attacker).field_70161_v, (World)((EntityLiving)this.attacker).field_70170_p, EntityLivingBase.class)) {
                                if (!(entity instanceof ISummonedCreature) || ((ISummonedCreature)entity).func_70902_q() != this.attacker) continue;
                                ((ISummonedCreature)entity).setCaster(((ISummonedCreature)this.attacker).getCaster());
                            }
                        }
                        return;
                    }
                    spells.remove(spell2);
                }
            }
        } else if (this.cooldown < 0) {
            this.cooldown = this.baseCooldown;
        }
    }

    private boolean attemptCastSpell(Spell spell, SpellModifiers modifiers) {
        if (MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Pre(SpellCastEvent.Source.NPC, spell, this.attacker, modifiers))) {
            return false;
        }
        if (spell.cast(((EntityLiving)this.attacker).field_70170_p, this.attacker, EnumHand.MAIN_HAND, 0, this.target, modifiers)) {
            if (spell.isContinuous) {
                this.continuousSpellTimer = this.continuousSpellDuration - 1;
                this.setContinuousSpellAndNotify(spell, modifiers);
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.NPC, spell, this.attacker, modifiers));
                this.cooldown = this.baseCooldown + spell.getCooldown() * 2;
                if (spell.requiresPacket()) {
                    PacketNPCCastSpell.Message msg = new PacketNPCCastSpell.Message(this.attacker.func_145782_y(), this.target.func_145782_y(), EnumHand.MAIN_HAND, spell, modifiers);
                    WizardryPacketHandler.net.sendToDimension((IMessage)msg, ((EntityLiving)this.attacker).field_70170_p.field_73011_w.getDimension());
                }
                if (!((EntityLiving)this.attacker).field_70170_p.field_72995_K && this.attacker.func_184614_ca().func_77973_b() instanceof ItemScroll) {
                    this.attacker.func_184614_ca().func_190918_g(1);
                }
            }
            return true;
        }
        return false;
    }
}

