/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.projectile;

import com.windanesz.ancientspellcraft.spell.SpellProjectileAOEPotion;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityAOEProjectile
extends EntityMagicProjectile {
    private int lifetime = 16;
    private SpellProjectileAOEPotion relatedSpell;

    public EntityAOEProjectile(World world) {
        super(world);
        this.func_70105_a(0.5f, 0.5f);
    }

    public float getDamage() {
        return this.relatedSpell != null && this.relatedSpell.hasProperty("damage") ? this.relatedSpell.getProperty("damage").floatValue() : 0.0f;
    }

    protected void func_70184_a(@Nullable RayTraceResult rayTrace) {
        if (!this.field_70170_p.field_72995_K) {
            for (EntityLivingBase entity : this.getEntitiesWithinRadius(rayTrace)) {
                this.affectEntity((Entity)entity);
            }
        } else {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(this.field_70165_t, this.field_70163_u, this.field_70161_v).scale(4.0f).time(60).clr(1.0f, 1.0f, 0.65f).fade(0.85f, 0.5f, 0.8f).spawn(this.field_70170_p);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    private void affectEntity(Entity entity) {
        if (entity != null) {
            float damage = this.getDamage() * this.damageMultiplier;
            if (damage > 0.0f) {
                entity.func_70097_a(this.getDamageSource(), damage);
            }
            if (!MagicDamage.isEntityImmune((MagicDamage.DamageType)this.relatedSpell.getDamageType(), (Entity)entity)) {
                this.relatedSpell.applyPotionEffects((EntityLivingBase)entity, new SpellModifiers());
            }
        }
    }

    protected List<EntityLivingBase> getEntitiesWithinRadius(RayTraceResult rayTraceResult) {
        List<Object> affectedEntities = new ArrayList<EntityLivingBase>();
        if (rayTraceResult != null) {
            BlockPos hitPos = rayTraceResult.field_72308_g != null ? rayTraceResult.field_72308_g.func_180425_c() : rayTraceResult.func_178782_a().func_177972_a(rayTraceResult.field_178784_b);
            affectedEntities = EntityUtils.getEntitiesWithinRadius((double)this.relatedSpell.getProperty("effect_radius").intValue(), (double)hitPos.func_177958_n(), (double)hitPos.func_177956_o(), (double)hitPos.func_177952_p(), (World)this.field_70170_p, EntityLivingBase.class).stream().filter(e -> e != this.field_70192_c).collect(Collectors.toList());
        }
        return affectedEntities;
    }

    protected DamageSource getDamageSource() {
        return MagicDamage.causeIndirectMagicDamage((Entity)this, (Entity)this.func_85052_h(), (MagicDamage.DamageType)MagicDamage.DamageType.MAGIC).func_76349_b();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double dx = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double dy = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70131_O;
                double dz = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double v = 0.06;
                ParticleBuilder.create((ResourceLocation)this.relatedSpell.getParticle()).clr(this.relatedSpell.getR(), this.relatedSpell.getG(), this.relatedSpell.getB()).pos(this.func_174791_d().func_72441_c(dx - this.field_70159_w / 2.0, dy, dz - this.field_70179_y / 2.0)).vel(-v * dx, -v * dy, -v * dz).scale(this.field_70130_N * 2.0f).time(10).spawn(this.field_70170_p);
                if (this.field_70173_aa <= 1) continue;
                dx = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                dy = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70131_O + (double)(this.field_70131_O / 2.0f) - 0.1;
                dz = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                ParticleBuilder.create((ResourceLocation)this.relatedSpell.getParticle()).clr(this.relatedSpell.getR(), this.relatedSpell.getG(), this.relatedSpell.getB()).pos(this.func_174791_d().func_72441_c(dx - this.field_70159_w, dy, dz - this.field_70179_y)).vel(-v * dx, -v * dy, -v * dz).scale(this.field_70130_N * 2.0f).time(10).spawn(this.field_70170_p);
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        if (source.func_76346_g() != null) {
            Vec3d vec3d = source.func_76346_g().func_70040_Z();
            if (vec3d != null) {
                double speed = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
                this.field_70159_w = vec3d.field_72450_a * speed;
                this.field_70181_x = vec3d.field_72448_b * speed;
                this.field_70179_y = vec3d.field_72449_c * speed;
                this.lifetime = 160;
            }
            if (source.func_76346_g() instanceof EntityLivingBase) {
                this.setCaster((EntityLivingBase)source.func_76346_g());
            }
            return true;
        }
        return false;
    }

    public void setRelatedSpell(SpellProjectileAOEPotion relatedSpell) {
        this.relatedSpell = relatedSpell;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.lifetime);
        buffer.writeInt(this.relatedSpell.networkID());
        super.writeSpawnData(buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.lifetime = buffer.readInt();
        this.relatedSpell = (SpellProjectileAOEPotion)Spell.byNetworkID((int)buffer.readInt());
        super.readSpawnData(buffer);
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.lifetime = nbt.func_74762_e("lifetime");
        this.relatedSpell = (SpellProjectileAOEPotion)Spell.get((String)nbt.func_74779_i("spell"));
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("lifetime", this.lifetime);
        nbt.func_74778_a("spell", this.relatedSpell.getRegistryName().toString());
    }
}

