/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.entity.projectile;

import com.windanesz.ancientspellcraft.entity.construct.EntitySilencingSigil;
import com.windanesz.ancientspellcraft.entity.living.EntitySpiritBear;
import com.windanesz.ancientspellcraft.registry.ASSounds;
import com.windanesz.ancientspellcraft.spell.Contingency;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.construct.EntityBlackHole;
import electroblob.wizardry.entity.construct.EntityBoulder;
import electroblob.wizardry.entity.construct.EntityFireSigil;
import electroblob.wizardry.entity.construct.EntityForcefield;
import electroblob.wizardry.entity.construct.EntityFrostSigil;
import electroblob.wizardry.entity.construct.EntityLightningSigil;
import electroblob.wizardry.entity.construct.EntityMagicConstruct;
import electroblob.wizardry.entity.living.EntitySpiritHorse;
import electroblob.wizardry.entity.living.EntitySpiritWolf;
import electroblob.wizardry.entity.living.EntitySummonedCreature;
import electroblob.wizardry.entity.living.ISummonedCreature;
import electroblob.wizardry.entity.projectile.EntityMagicProjectile;
import electroblob.wizardry.potion.Curse;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class EntityDispelMagic
extends EntityMagicProjectile {
    private int lifetime = 16;
    private Tier tier = Tier.APPRENTICE;

    public EntityDispelMagic(World world) {
        super(world);
        this.func_70105_a(0.4f, 0.4f);
    }

    protected void func_70184_a(RayTraceResult rayTrace) {
        WizardData data;
        Entity entity = rayTrace.field_72308_g;
        if (this.tier == Tier.ADVANCED && entity instanceof EntityPlayer && (data = WizardData.get((EntityPlayer)((EntityPlayer)entity))) != null) {
            if (data.getVariable(Contingency.ACTIVE_CONTINGENCY_LISTENER) != null) {
                data.setVariable(Contingency.ACTIVE_CONTINGENCY_LISTENER, null);
            }
            if (data.getVariable(Contingency.ACTIVE_CONTINGENCIES) != null) {
                data.setVariable(Contingency.ACTIVE_CONTINGENCIES, null);
            }
            data.sync();
        }
        if (!this.field_70170_p.field_72995_K) {
            if (entity == null) {
                List entitiesWithinRadius = EntityUtils.getEntitiesWithinRadius((double)1.0, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (World)this.field_70170_p, Entity.class);
                entitiesWithinRadius.remove((Object)this);
                if (!entitiesWithinRadius.isEmpty()) {
                    entity = (Entity)entitiesWithinRadius.get(0);
                }
            }
            if (entity != null) {
                if (entity instanceof EntityMagicProjectile) {
                    ((EntityMagicProjectile)entity).func_70106_y();
                } else if (entity instanceof EntityMagicConstruct) {
                    EntityMagicConstruct construct = (EntityMagicConstruct)entity;
                    if (construct.lifetime == -1) {
                        construct.func_70106_y();
                    }
                    construct.lifetime = (int)((double)construct.lifetime * 0.1);
                    Tier tier = this.getConstructTier(construct);
                } else if (entity instanceof EntityLivingBase) {
                    EntityLivingBase entityLivingBase = (EntityLivingBase)entity;
                    if (EntityDispelMagic.isMagicEntityOrSummon(entity)) {
                        if (entity instanceof ISummonedCreature) {
                            ((ISummonedCreature)entity).onDespawn();
                        }
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ASSounds.DISPEL_ENTITY, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                        entity.func_70106_y();
                        if (this.field_70170_p.field_72995_K) {
                            for (int i = 0; i < 15; ++i) {
                                this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_LARGE, this.field_70165_t + (double)this.field_70146_Z.nextFloat(), this.field_70163_u + 1.0 + (double)this.field_70146_Z.nextFloat(), this.field_70161_v + (double)this.field_70146_Z.nextFloat(), 0.0, 0.0, 0.0, new int[0]);
                            }
                        }
                        this.func_70106_y();
                    } else {
                        Collection effects = entityLivingBase.func_70651_bq();
                        ArrayList<Potion> activePotions = new ArrayList<Potion>();
                        for (PotionEffect effect : effects) {
                            activePotions.add(effect.func_188419_a());
                        }
                        for (Potion potion : activePotions) {
                            if (!(potion instanceof Curse) && entityLivingBase.func_70644_a(potion)) {
                                entityLivingBase.func_184589_d(potion);
                            }
                            if (this.tier == Tier.ADVANCED) continue;
                            break;
                        }
                        this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ASSounds.DISPEL, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
                        this.func_70106_y();
                    }
                }
            }
            this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, ASSounds.DISPEL, SoundCategory.HOSTILE, 1.0f, 1.0f, false);
            this.func_70106_y();
        }
    }

    private Tier getConstructTier(EntityMagicConstruct construct) {
        if (construct instanceof EntityBlackHole || construct instanceof EntityBoulder) {
            return Tier.MASTER;
        }
        if (construct instanceof EntityFireSigil || construct instanceof EntityFrostSigil || construct instanceof EntityLightningSigil || construct instanceof EntitySilencingSigil) {
            return Tier.APPRENTICE;
        }
        return Tier.ADVANCED;
    }

    public static boolean isMagicEntityOrSummon(Entity entity) {
        return entity instanceof ISummonedCreature || entity instanceof EntitySummonedCreature || entity instanceof EntitySpiritWolf || entity instanceof EntitySpiritBear || entity instanceof EntitySpiritHorse || entity instanceof EntityIronGolem && ((EntityIronGolem)entity).func_70850_q();
    }

    public void func_70071_h_() {
        double search_border_size;
        EntityForcefield forcefield;
        float radius;
        List list;
        List test;
        super.func_70071_h_();
        if (!(this.field_70170_p.field_72995_K || this.tier != Tier.ADVANCED || (test = EntityUtils.getEntitiesWithinRadius((double)5.0, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (World)this.field_70170_p, EntityForcefield.class)).isEmpty() || (list = EntityUtils.getEntitiesWithinRadius((double)((double)(radius = (forcefield = (EntityForcefield)test.get(0)).getRadius()) + (search_border_size = 4.0)), (double)forcefield.field_70165_t, (double)forcefield.field_70163_u, (double)forcefield.field_70161_v, (World)this.field_70170_p, EntityDispelMagic.class)).isEmpty())) {
            forcefield.lifetime = (int)((double)forcefield.lifetime * 0.2);
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 5; ++i) {
                double dx = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double dy = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70131_O + (double)(this.field_70131_O / 2.0f) - 0.1;
                double dz = (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N;
                double v = 0.06;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SCORCH).clr(255, 255, 255).pos(this.func_174791_d().func_72441_c(dx - this.field_70159_w / 2.0, dy, dz - this.field_70179_y / 2.0)).vel(-v * dx, -v * dy, -v * dz).scale(this.field_70130_N * 2.0f).time(10).spawn(this.field_70170_p);
                if (this.field_70173_aa <= 1) continue;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)this.field_70146_Z, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.03, (boolean)true).clr(255, 255, 255).fade(0, 0, 0).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
                if (this.field_70173_aa <= 1) continue;
                double x = this.field_70165_t - this.field_70159_w / 2.0;
                double y = this.field_70163_u - this.field_70181_x / 2.0;
                double z = this.field_70161_v - this.field_70179_y / 2.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH, (Random)this.field_70146_Z, (double)x, (double)y, (double)z, (double)0.03, (boolean)true).clr(255, 255, 255).fade(0, 0, 0).time(20 + this.field_70146_Z.nextInt(10)).spawn(this.field_70170_p);
            }
        }
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public void setLifetime(int lifetime) {
        this.lifetime = lifetime;
    }

    public int getLifetime() {
        return this.lifetime;
    }

    public boolean func_189652_ae() {
        return true;
    }

    public boolean func_90999_ad() {
        return false;
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.lifetime);
        super.writeSpawnData(buffer);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.lifetime = buffer.readInt();
        super.readSpawnData(buffer);
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.lifetime = nbttagcompound.func_74762_e("lifetime");
        this.tier = Tier.fromName((String)nbttagcompound.func_74779_i("tier"));
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74768_a("lifetime", this.lifetime);
        nbttagcompound.func_74778_a("tier", this.tier.getUnlocalisedName());
    }

    public Tier getTier() {
        return this.tier;
    }

    public void setTier(Tier tier) {
        this.tier = tier;
    }
}

