/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.integration.antiqueatlas;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import hunternif.mc.atlas.AntiqueAtlasMod;
import hunternif.mc.atlas.api.AtlasAPI;
import hunternif.mc.atlas.marker.GlobalMarkersData;
import hunternif.mc.atlas.marker.Marker;
import hunternif.mc.atlas.registry.MarkerType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class ASAntiqueAtlasIntegration {
    public static final String ANTIQUE_ATLAS_MOD_ID = "antiqueatlas";
    private static final ResourceLocation BATTLEMAGE_CAMP_MARKER = new ResourceLocation("ancientspellcraft", "battlemage_camp");
    private static final ResourceLocation BATTLEMAGE_KEEP_MARKER = new ResourceLocation("ancientspellcraft", "battlemage_keep");
    private static final ResourceLocation SAGE_HILL_MARKER = new ResourceLocation("ancientspellcraft", "sage_hill");
    private static final ResourceLocation ANCIENT_VAULT_MARKER = new ResourceLocation("ancientspellcraft", "ancient_vault");
    private static boolean antiqueAtlasLoaded;

    public static void init() {
        antiqueAtlasLoaded = Loader.isModLoaded((String)ANTIQUE_ATLAS_MOD_ID);
        AncientSpellcraft.proxy.registerAtlasMarkers();
    }

    public static boolean enabled() {
        return Settings.generalSettings.antique_atlas_integration && antiqueAtlasLoaded;
    }

    public static void markBattlemageCamp(World world, int x, int z) {
        if (ASAntiqueAtlasIntegration.enabled() && Settings.generalSettings.auto_battlemage_camp_markers) {
            AtlasAPI.getMarkerAPI().putGlobalMarker(world, false, BATTLEMAGE_CAMP_MARKER.toString(), "integration.antiqueatlas.marker." + BATTLEMAGE_CAMP_MARKER.toString().replace(':', '.'), x, z);
        }
    }

    public static void markBattlemageKeep(World world, int x, int z) {
        if (ASAntiqueAtlasIntegration.enabled() && Settings.generalSettings.auto_battlemage_keep_markers) {
            AtlasAPI.getMarkerAPI().putGlobalMarker(world, false, BATTLEMAGE_KEEP_MARKER.toString(), "integration.antiqueatlas.marker." + BATTLEMAGE_KEEP_MARKER.toString().replace(':', '.'), x, z);
        }
    }

    public static void markSageHill(World world, int x, int z) {
        if (ASAntiqueAtlasIntegration.enabled() && Settings.generalSettings.auto_battlemage_keep_markers) {
            AtlasAPI.getMarkerAPI().putGlobalMarker(world, false, SAGE_HILL_MARKER.toString(), "integration.antiqueatlas.marker." + SAGE_HILL_MARKER.toString().replace(':', '.'), x, z);
        }
    }

    public static void markMysteryStructure(World world, int x, int z) {
        if (ASAntiqueAtlasIntegration.enabled() && Settings.generalSettings.ancient_vault_markers) {
            AtlasAPI.getMarkerAPI().putGlobalMarker(world, false, ANCIENT_VAULT_MARKER.toString(), "integration.antiqueatlas.marker." + ANCIENT_VAULT_MARKER.toString().replace(':', '.'), x, z);
        }
    }

    public static void registerMarkers() {
        if (!ASAntiqueAtlasIntegration.enabled()) {
            return;
        }
        AtlasAPI.getMarkerAPI().registerMarker(new MarkerType(BATTLEMAGE_CAMP_MARKER, new ResourceLocation[]{new ResourceLocation("ancientspellcraft", "textures/integration/antiqueatlas/battlemage_camp.png")}));
        AtlasAPI.getMarkerAPI().registerMarker(new MarkerType(BATTLEMAGE_KEEP_MARKER, new ResourceLocation[]{new ResourceLocation("ancientspellcraft", "textures/integration/antiqueatlas/battlemage_keep.png")}));
        AtlasAPI.getMarkerAPI().registerMarker(new MarkerType(SAGE_HILL_MARKER, new ResourceLocation[]{new ResourceLocation("ancientspellcraft", "textures/integration/antiqueatlas/sage_hill.png")}));
        AtlasAPI.getMarkerAPI().registerMarker(new MarkerType(ANCIENT_VAULT_MARKER, new ResourceLocation[]{new ResourceLocation("ancientspellcraft", "textures/integration/antiqueatlas/ancient_vault.png")}));
    }

    @SubscribeEvent
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        if (!ASAntiqueAtlasIntegration.enabled()) {
            return;
        }
        GlobalMarkersData data = AntiqueAtlasMod.globalMarkersData.getData();
        for (Marker marker : data.getMarkersInDimension(event.getWorld().field_73011_w.getDimension())) {
            if (!marker.getLabel().contains(":")) continue;
            data.removeMarker(marker.getId());
            AtlasAPI.getMarkerAPI().putGlobalMarker(event.getWorld(), marker.isVisibleAhead(), marker.getType(), marker.getLabel().replace(':', '.'), marker.getX(), marker.getZ());
        }
    }
}

