/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.google.common.collect.Multimap;
import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.client.gui.GuiHandlerAS;
import com.windanesz.ancientspellcraft.item.IItemWithSlots;
import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.WizardArmourUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.IWorkbenchItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.packet.PacketCastSpell;
import electroblob.wizardry.packet.WizardryPacketHandler;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryRecipes;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.Slot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBattlemageShield
extends Item
implements ISpellCastingItem,
IManaStoringItem,
IWorkbenchItem,
IItemWithSlots {
    private static final UUID SHIELD_ARMOR_BONUS = UUID.fromString("2b5b1f50-b6b5-473a-a402-e45a24d83c13");
    private static final UUID SHIELD_ARMOR_PERCENT_BONUS = UUID.fromString("3c1acb30-dafb-4c27-a142-680f12ed9c36");
    private static final UUID SHIELD_TOUGHNESS_BONUS = UUID.fromString("84d9a7e1-5346-4073-98e9-0e04d6d28da5");

    public ItemBattlemageShield() {
        this.func_77664_n();
        this.field_77777_bU = 1;
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_GEAR);
        this.func_77656_e(Settings.generalSettings.runic_shield_durability);
        this.func_185043_a(new ResourceLocation("blocking"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)ItemArmor.field_96605_cw);
        WizardryRecipes.addToManaFlaskCharging((Item)this);
    }

    public int getSpellSlotCount(ItemStack stack) {
        return 0;
    }

    public boolean onApplyButtonPressed(EntityPlayer player, Slot centre, Slot crystals, Slot upgrade, Slot[] spellBooks) {
        boolean changed = false;
        if (upgrade.func_75216_d()) {
            ItemStack original = centre.func_75211_c().func_77946_l();
            centre.func_75215_d(this.applyUpgrade(player, centre.func_75211_c(), upgrade.func_75211_c()));
            boolean bl = changed = !ItemStack.func_77989_b((ItemStack)centre.func_75211_c(), (ItemStack)original);
        }
        if (crystals.func_75211_c() != ItemStack.field_190927_a && !this.isManaFull(centre.func_75211_c())) {
            int chargeDepleted = this.getManaCapacity(centre.func_75211_c()) - this.getMana(centre.func_75211_c());
            if (crystals.func_75211_c().func_190916_E() * 100 < chargeDepleted) {
                this.rechargeMana(centre.func_75211_c(), crystals.func_75211_c().func_190916_E() * 100);
                crystals.func_75209_a(crystals.func_75211_c().func_190916_E());
            } else {
                this.setMana(centre.func_75211_c(), this.getManaCapacity(centre.func_75211_c()));
                crystals.func_75209_a((int)Math.ceil((double)chargeDepleted / 100.0));
            }
            changed = true;
        }
        return changed;
    }

    public int getMaxDamage(ItemStack stack) {
        return (int)((float)super.getMaxDamage(stack) * (1.0f + 0.15f * (float)WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.storage_upgrade)) + 0.5f);
    }

    public ItemStack applyUpgrade(@Nullable EntityPlayer player, ItemStack shield, ItemStack upgrade) {
        Item specialUpgrade;
        if (WandHelper.isWandUpgrade((Item)upgrade.func_77973_b()) && ((specialUpgrade = upgrade.func_77973_b()) == WizardryItems.storage_upgrade || specialUpgrade == WizardryItems.siphon_upgrade || specialUpgrade == WizardryItems.condenser_upgrade || specialUpgrade == ASItems.soulbound_upgrade)) {
            int maxUpgrades = 9;
            if (WandHelper.getTotalUpgrades((ItemStack)shield) < maxUpgrades && WandHelper.getUpgradeLevel((ItemStack)shield, (Item)specialUpgrade) < 3) {
                int prevMana = this.getMana(shield);
                WandHelper.applyUpgrade((ItemStack)shield, (Item)specialUpgrade);
                if (specialUpgrade == WizardryItems.storage_upgrade) {
                    this.setMana(shield, prevMana);
                }
                upgrade.func_190918_g(1);
                if (player != null) {
                    WizardryAdvancementTriggers.special_upgrade.triggerFor(player);
                }
            }
        }
        return shield;
    }

    public boolean showTooltip(ItemStack stack) {
        return true;
    }

    public int getMana(ItemStack stack) {
        return this.getManaCapacity(stack) - this.getDamage(stack);
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, damage);
    }

    public void setMana(ItemStack stack, int mana) {
        super.setDamage(stack, this.getManaCapacity(stack) - mana);
    }

    public int getManaCapacity(ItemStack stack) {
        return this.getMaxDamage(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag advanced) {
        Wizardry.proxy.addMultiLineDescription(tooltip, "item." + this.getRegistryName() + ".desc", new Object[0]);
        if (advanced.func_194127_a()) {
            tooltip.add("\u00a79" + I18n.func_135052_a((String)"item.ebwizardry:wand.mana", (Object[])new Object[]{this.getMana(stack), this.getManaCapacity(stack)}));
        }
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BLOCK;
    }

    public int func_77626_a(ItemStack stack) {
        return 20000;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.isBattlemage(player)) {
            ASUtils.sendMessage((Entity)player, "Only a battlemage can use this", false, new Object[0]);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (hand == EnumHand.MAIN_HAND && player.func_70093_af()) {
            player.openGui((Object)AncientSpellcraft.instance, GuiHandlerAS.BATTLEMAGE_SHIELD, player.field_70170_p, 0, 0, 0);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
        }
        if (this.isManaEmpty(stack)) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        player.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public boolean canContinueUsing(ItemStack oldStack, ItemStack newStack) {
        if (ItemStack.func_185132_d((ItemStack)oldStack, (ItemStack)newStack)) {
            return true;
        }
        return super.canContinueUsing(oldStack, newStack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase user, int count) {
        super.onUsingTick(stack, user, count);
    }

    public boolean isBattlemage(EntityPlayer player) {
        return WizardArmourUtils.isWearingFullSet((EntityLivingBase)player, null, ItemWizardArmour.ArmourClass.BATTLEMAGE);
    }

    public String func_77653_i(ItemStack stack) {
        return super.func_77653_i(stack);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (!(oldStack.func_190926_b() && newStack.func_190926_b() || oldStack.func_77973_b() != newStack.func_77973_b() || slotChanged)) {
            return false;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean cast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        World world = caster.field_70170_p;
        if (world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
            return false;
        }
        if (spell.cast(world, caster, hand, castingTick, modifiers)) {
            if (castingTick == 0) {
                MinecraftForge.EVENT_BUS.post((Event)new SpellCastEvent.Post(SpellCastEvent.Source.OTHER, spell, (EntityLivingBase)caster, modifiers));
            }
            if (!world.field_72995_K && !spell.isContinuous && spell.requiresPacket()) {
                PacketCastSpell.Message msg = new PacketCastSpell.Message(caster.func_145782_y(), hand, spell, modifiers);
                WizardryPacketHandler.net.sendToDimension((IMessage)msg, world.field_73011_w.getDimension());
            }
            return true;
        }
        return false;
    }

    @Nonnull
    public Spell getCurrentSpell(ItemStack stack) {
        return Spells.shield;
    }

    public boolean showSpellHUD(EntityPlayer player, ItemStack stack) {
        return false;
    }

    public boolean canCast(ItemStack stack, Spell spell, EntityPlayer caster, EnumHand hand, int castingTick, SpellModifiers modifiers) {
        return true;
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot slot) {
        Multimap multimap = super.func_111205_h(slot);
        if (slot == EntityEquipmentSlot.OFFHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_188791_g.func_111108_a(), (Object)new AttributeModifier(SHIELD_ARMOR_BONUS, "Armor modifier", (double)Settings.generalSettings.runic_shield_armor, 0));
            multimap.put((Object)SharedMonsterAttributes.field_189429_h.func_111108_a(), (Object)new AttributeModifier(SHIELD_TOUGHNESS_BONUS, "Armor toughness", (double)Settings.generalSettings.runic_shield_armor_toughness, 0));
        }
        return multimap;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (entity instanceof EntityPlayer && this.isBattlemage((EntityPlayer)entity)) {
            NBTTagCompound nbt;
            EntityPlayer player = (EntityPlayer)entity;
            if (!ItemStack.func_77989_b((ItemStack)player.func_184592_cb(), (ItemStack)stack)) {
                return;
            }
            if (stack.func_77973_b() instanceof ItemBattlemageShield && stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("Items")) {
                int count = stack.func_77978_p().func_150295_c("Items", 10).func_74745_c();
                for (int i = 0; i < count; ++i) {
                    this.tickArtefact(new ItemStack(stack.func_77978_p().func_150295_c("Items", 10).func_150305_b(i)), player);
                }
            }
            if (!world.field_72995_K && !this.isManaFull(stack) && world.func_82737_E() % 50L == 0L) {
                this.rechargeMana(stack, WandHelper.getUpgradeLevel((ItemStack)stack, (Item)WizardryItems.condenser_upgrade));
            }
            if (!world.field_72995_K && player.func_184811_cZ().func_185141_a(stack.func_77973_b()) && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_glyph_shield_disable)) {
                player.func_184811_cZ().func_185142_b((Item)this);
            }
        }
    }

    public static List<ItemStack> getArtefacts(ItemStack shield) {
        NBTTagCompound nbt;
        ArrayList<ItemStack> artefacts = new ArrayList<ItemStack>();
        if (shield.func_77973_b() instanceof ItemBattlemageShield && shield.func_77942_o() && (nbt = shield.func_77978_p()).func_74764_b("Items")) {
            int count = shield.func_77978_p().func_150295_c("Items", 10).func_74745_c();
            for (int i = 0; i < count; ++i) {
                artefacts.add(new ItemStack(shield.func_77978_p().func_150295_c("Items", 10).func_150305_b(i)));
            }
        }
        return artefacts;
    }

    public void tickArtefact(ItemStack stack, EntityPlayer player) {
        if (stack.func_77973_b() instanceof ITickableArtefact) {
            ((ITickableArtefact)stack.func_77973_b()).onWornTick(stack, (EntityLivingBase)player);
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isShield(ItemStack stack, @Nullable EntityLivingBase entity) {
        return true;
    }

    @Override
    public int getSlotCount() {
        return 3;
    }

    @Override
    public boolean hasGUI() {
        return true;
    }

    @Override
    public int getRowCount() {
        return 1;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isItemValid(Item item) {
        return false;
    }
}

