/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ITickableArtefact;
import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.item.IManaStoringItem;
import electroblob.wizardry.item.ItemWandUpgrade;
import electroblob.wizardry.registry.WizardryItems;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBeltScrollHolder
extends ItemNewArtefact
implements ITickableArtefact {
    public static final String SCROLL_TAG = "scroll";

    public ItemBeltScrollHolder(EnumRarity rarity, ItemNewArtefact.AdditionalType type) {
        super(rarity, type);
    }

    public static ItemStack getScroll(ItemStack stack) {
        Item item;
        if (stack.func_77973_b() instanceof ItemBeltScrollHolder && stack.func_77942_o() && stack.func_77978_p().func_74764_b(SCROLL_TAG) && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(stack.func_77978_p().func_74779_i(SCROLL_TAG)))) != null) {
            return new ItemStack(item);
        }
        return ItemStack.field_190927_a;
    }

    public static boolean setScroll(ItemStack holder, @Nullable ItemStack scroll) {
        if (ItemBeltScrollHolder.getScroll(holder) != ItemStack.field_190927_a && scroll != null) {
            return false;
        }
        NBTTagCompound nbt = holder.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        if (scroll != null && scroll.func_77973_b() instanceof ItemWandUpgrade && scroll.func_77973_b() != ASItems.soulbound_upgrade && scroll.func_77973_b() != WizardryItems.melee_upgrade && scroll.func_77973_b() != WizardryItems.storage_upgrade && scroll.func_77973_b() != WizardryItems.siphon_upgrade && scroll.func_77973_b() != WizardryItems.attunement_upgrade) {
            nbt.func_74778_a(SCROLL_TAG, scroll.func_77973_b().getRegistryName().toString());
        } else if (nbt.func_74764_b(SCROLL_TAG)) {
            nbt.func_82580_o(SCROLL_TAG);
        }
        holder.func_77982_d(nbt);
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer player, EnumHand hand) {
        this.use(player, hand);
        return new ActionResult(EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    public boolean use(EntityPlayer player, EnumHand hand) {
        ItemStack scroll;
        ItemStack stack = player.func_184586_b(hand);
        ItemStack otherStack = player.func_184586_b(hand == EnumHand.MAIN_HAND ? EnumHand.OFF_HAND : EnumHand.MAIN_HAND);
        if (otherStack.func_190926_b() && (scroll = ItemBeltScrollHolder.getScroll(stack)) != ItemStack.field_190927_a) {
            if (!player.field_70170_p.field_72995_K) {
                ItemBeltScrollHolder.setScroll(stack, null);
                ASUtils.giveStackToPlayer(player, scroll);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:belt_scroll_holder.removed_scroll", new Object[]{scroll.func_77973_b().func_77653_i(scroll)}), false);
            }
            return true;
        }
        if (otherStack.func_77973_b() instanceof ItemWandUpgrade) {
            if (!player.field_70170_p.field_72995_K) {
                scroll = ItemBeltScrollHolder.getScroll(stack);
                if (scroll != ItemStack.field_190927_a) {
                    ItemBeltScrollHolder.setScroll(stack, null);
                    ASUtils.giveStackToPlayer(player, scroll);
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:belt_scroll_holder.removed_scroll", new Object[]{scroll.func_77973_b().func_77653_i(scroll)}), false);
                }
                ItemBeltScrollHolder.setScroll(stack, otherStack);
                player.func_146105_b((ITextComponent)new TextComponentTranslation("item.ancientspellcraft:belt_scroll_holder.added_scroll", new Object[]{otherStack.func_77973_b().func_77653_i(otherStack)}), false);
                otherStack.func_190918_g(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public void onWornTick(ItemStack itemstack, EntityLivingBase player) {
        if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_82737_E() % 50L == 0L && ItemBeltScrollHolder.getScroll(itemstack).func_77973_b() == WizardryItems.condenser_upgrade) {
            if (player.func_184614_ca().func_77973_b() instanceof IManaStoringItem && !((IManaStoringItem)player.func_184614_ca().func_77973_b()).isManaFull(player.func_184614_ca())) {
                ((IManaStoringItem)player.func_184614_ca().func_77973_b()).rechargeMana(player.func_184614_ca(), 1);
            }
            if (player.func_184592_cb().func_77973_b() instanceof IManaStoringItem && !((IManaStoringItem)player.func_184592_cb().func_77973_b()).isManaFull(player.func_184614_ca())) {
                ((IManaStoringItem)player.func_184592_cb().func_77973_b()).rechargeMana(player.func_184614_ca(), 1);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(stack, world, tooltip, advanced);
        Wizardry.proxy.addMultiLineDescription(tooltip, "item.ancientspellcraft:belt_scroll_holder.usage_1", new Object[0]);
        Wizardry.proxy.addMultiLineDescription(tooltip, "item.ancientspellcraft:belt_scroll_holder.usage_2", new Object[0]);
        ItemStack scroll = ItemBeltScrollHolder.getScroll(stack);
        if (scroll != ItemStack.field_190927_a) {
            Wizardry.proxy.addMultiLineDescription(tooltip, "item.ancientspellcraft:belt_scroll_holder.current_scroll", new Object[]{scroll.func_77973_b().func_77653_i(scroll)});
        } else {
            Wizardry.proxy.addMultiLineDescription(tooltip, "item.ancientspellcraft:belt_scroll_holder.empty", new Object[0]);
        }
    }
}

