/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.item.ItemRareScroll;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.tileentity.TileEntityImbuementAltar;
import electroblob.wizardry.tileentity.TileEntityReceptacle;
import electroblob.wizardry.util.GeometryUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.Arrays;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ItemImbuementScroll
extends ItemRareScroll {
    public EnumAction func_77661_b(ItemStack stack) {
        return SpellActions.IMBUE;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.func_180495_p(pos).func_177230_c() == WizardryBlocks.imbuement_altar && world.func_175625_s(pos) instanceof TileEntityImbuementAltar) {
            TileEntityImbuementAltar tile = (TileEntityImbuementAltar)world.func_175625_s(pos);
            Element[] dustElements = ItemImbuementScroll.getReceptacleElements(world, pos);
            if (Arrays.stream(dustElements).distinct().count() == 1L) {
                Element element = dustElements[0];
                ItemStack oldStack = tile.getStack();
                if (element != null && (oldStack.func_77973_b() instanceof ItemWand || oldStack.func_77973_b() instanceof ItemWizardArmour) && oldStack.func_77973_b().getRegistryName().func_110624_b().equals("ebwizardry")) {
                    if (!world.field_72995_K) {
                        ItemStack newStack = ItemStack.field_190927_a;
                        if (oldStack.func_77973_b() instanceof ItemWand) {
                            newStack = new ItemStack(ItemWand.getWand((Tier)((ItemWand)oldStack.func_77973_b()).tier, (Element)element));
                        } else if (oldStack.func_77973_b() instanceof ItemWizardArmour) {
                            newStack = new ItemStack(ItemWizardArmour.getArmour((Element)element, (ItemWizardArmour.ArmourClass)((ItemWizardArmour)oldStack.func_77973_b()).armourClass, (EntityEquipmentSlot)((ItemWizardArmour)oldStack.func_77973_b()).field_77881_a));
                        }
                        if (!newStack.func_190926_b()) {
                            newStack.func_77964_b(oldStack.func_77952_i());
                            newStack.func_77982_d(oldStack.func_77978_p());
                            tile.setStack(newStack);
                            if (!player.func_184812_l_()) {
                                ItemImbuementScroll.consumeScroll(player, hand);
                            }
                            this.consumeReceptacleContents(world, pos);
                            return EnumActionResult.SUCCESS;
                        }
                    }
                    if (world.field_72995_K) {
                        int i;
                        int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(element);
                        Vec3d origin = new Vec3d((double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5);
                        Vec3d centre = GeometryUtils.getCentre((BlockPos)pos);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(centre).scale(0.35f).time(48).clr(colours[0]).spawn(world);
                        double r = 0.12;
                        for (i = 0; i < 20; ++i) {
                            double x = r * (world.field_73012_v.nextDouble() * 4.0 - 1.0);
                            double y = r * (world.field_73012_v.nextDouble() * 4.0 - 1.0);
                            double z = r * (world.field_73012_v.nextDouble() * 4.0 - 1.0);
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(centre.field_72450_a + x, centre.field_72448_b + y + 1.0, centre.field_72449_c + z).vel(x * -0.03, 0.02, z * -0.03).time(44 + world.field_73012_v.nextInt(8)).clr(colours[1]).fade(colours[2]).spawn(world);
                        }
                        for (i = 0; i < 40; ++i) {
                            double particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                            double particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos(particleX, origin.field_72448_b, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).clr(colours[0], colours[1], colours[2]).spawn(world);
                            particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                            particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(particleX, origin.field_72448_b, particleZ).vel(particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c).time(30).clr(colours[0], colours[1], colours[2]).spawn(world);
                            particleX = origin.field_72450_a - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                            particleZ = origin.field_72449_c - 1.0 + 2.0 * world.field_73012_v.nextDouble();
                            IBlockState block = world.func_180495_p(new BlockPos(origin.field_72450_a, origin.field_72448_b - 0.5, origin.field_72449_c));
                            if (block == null) continue;
                            world.func_175688_a(EnumParticleTypes.BLOCK_DUST, particleX, origin.field_72448_b, particleZ, particleX - origin.field_72450_a, 0.0, particleZ - origin.field_72449_c, new int[]{Block.func_176210_f((IBlockState)block)});
                        }
                    }
                    this.consumeReceptacleContents(world, pos);
                    return EnumActionResult.SUCCESS;
                }
            }
        }
        return super.onItemUseFirst(player, world, pos, side, hitX, hitY, hitZ, hand);
    }

    private static Element[] getReceptacleElements(World world, BlockPos pos) {
        Element[] elements = new Element[4];
        for (EnumFacing side : EnumFacing.field_176754_o) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
            elements[side.func_176736_b()] = tileEntity instanceof TileEntityReceptacle ? ((TileEntityReceptacle)tileEntity).getElement() : null;
        }
        return elements;
    }

    private void consumeReceptacleContents(World world, BlockPos pos) {
        for (EnumFacing side : EnumFacing.field_176754_o) {
            TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
            if (!(tileEntity instanceof TileEntityReceptacle)) continue;
            ((TileEntityReceptacle)tileEntity).setElement(null);
        }
    }
}

