/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.item;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.client.gui.GuiHandlerAS;
import com.windanesz.ancientspellcraft.registry.ASTabs;
import com.windanesz.ancientspellcraft.registry.Rituals;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.util.LangUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.WizardData;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRitualBook
extends Item {
    public ItemRitualBook() {
        this.func_77627_a(true);
        this.func_77625_d(16);
        this.func_77637_a(ASTabs.ANCIENTSPELLCRAFT_RITUALS);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ASTabs.ANCIENTSPELLCRAFT_RITUALS) {
            List<Ritual> rituals = Ritual.getAllRituals();
            rituals.removeIf(r -> !r.applicableForItem(this));
            for (Ritual ritual : rituals) {
                ItemStack stack = new ItemStack((Item)this);
                ItemRitualBook.setRitual(stack, ritual);
                list.add((Object)stack);
            }
        }
    }

    public static Ritual getRitual(ItemStack stack) {
        String ritual;
        Ritual rit;
        if (stack.func_77973_b() instanceof ItemRitualBook && stack.func_77942_o() && stack.func_77978_p().func_74764_b("ritual") && (rit = (Ritual)Ritual.registry.getValue(new ResourceLocation(ritual = stack.func_77978_p().func_74779_i("ritual")))) != null) {
            return rit;
        }
        return Rituals.none;
    }

    public static void setRitual(ItemStack stack, Ritual ritual) {
        if (stack.func_77973_b() instanceof ItemRitualBook) {
            NBTTagCompound compound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            compound.func_74778_a("ritual", ritual.getRegistryName().toString());
            stack.func_77982_d(compound);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (ItemRitualBook.getRitual(stack) != Rituals.none) {
            player.openGui((Object)AncientSpellcraft.instance, GuiHandlerAS.RITUAL_BOOK, world, 0, 0, 0);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_77624_a(itemstack, world, tooltip, advanced);
        if (world == null) {
            world = Wizardry.proxy.getTheWorld();
        }
        if (world != null && itemstack.func_77942_o() && ItemRitualBook.getRitual(itemstack) != Rituals.none) {
            Ritual ritual = ItemRitualBook.getRitual(itemstack);
            EntityPlayer player = Wizardry.proxy.getThePlayer();
            boolean discovered = AncientSpellcraft.proxy.shouldDisplayDiscovered(ritual, itemstack);
            if (!ritual.isEnabled()) {
                tooltip.add(AncientSpellcraft.proxy.translate("item.ancientspellcraft:ritual_book.desc_disabled", new Object[0]));
            } else if (!player.func_184812_l_() && WizardData.get((EntityPlayer)player) != null && !discovered) {
                tooltip.add(LangUtils.toElderFuthark(ritual.getDisplayName()));
                tooltip.add(AncientSpellcraft.proxy.translate("item.ancientspellcraft:ritual_book.desc", new Object[0]));
            } else {
                tooltip.add(ritual.getDisplayName());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public FontRenderer getFontRenderer(ItemStack stack) {
        return Wizardry.proxy.getFontRenderer(stack);
    }
}

