/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.misc;

import com.windanesz.ancientspellcraft.entity.living.EntityFireAnt;
import com.windanesz.ancientspellcraft.entity.living.EntitySkeletonMageMinion;
import com.windanesz.ancientspellcraft.entity.living.EntityWolfMinion;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.spell.AttireAlteration;
import com.windanesz.ancientspellcraft.spell.CurseArmor;
import com.windanesz.ancientspellcraft.spell.FairyRing;
import com.windanesz.ancientspellcraft.spell.QuicksandRing;
import com.windanesz.ancientspellcraft.spell.ShockZone;
import com.windanesz.ancientspellcraft.spell.TemporalCasualty;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.entity.construct.EntityBubble;
import electroblob.wizardry.entity.living.EntitySpectralGolem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.misc.Forfeit;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.tileentity.TileEntityTimer;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ASForfeits {
    public static <T> void spawnMobs(Function<World, T> minionFactory, int count, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            BlockPos pos;
            for (int i = 0; i < count && (pos = BlockUtils.findNearbyFloorSpace((Entity)player, (int)4, (int)2)) != null; ++i) {
                T minion = minionFactory.apply(world);
                ((EntityLivingBase)minion).func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                ((EntityLivingBase)minion).func_70604_c((EntityLivingBase)player);
                world.func_72838_d((Entity)((EntityLivingBase)minion));
            }
        }
    }

    public static void add(Tier tier, Element element, Forfeit forfeit) {
        Forfeit.add((Tier)tier, (Element)element, (Forfeit)forfeit);
    }

    private static Forfeit create(String name, BiConsumer<World, EntityPlayer> effect) {
        return Forfeit.create((ResourceLocation)new ResourceLocation("ancientspellcraft", name), effect);
    }

    public static void register() {
        ASForfeits.add(Tier.NOVICE, Element.LIGHTNING, ASForfeits.create("self_glow", (w, p) -> p.func_70690_d(new PotionEffect(MobEffects.field_188423_x, 4000))));
        ASForfeits.add(Tier.ADVANCED, Element.LIGHTNING, ASForfeits.create("area_shock", (w, p) -> {
            if (!w.field_72995_K) {
                ShockZone.makeZone(w, null, p.func_180425_c(), new SpellModifiers());
            }
        }));
        ASForfeits.add(Tier.NOVICE, Element.FIRE, ASForfeits.create("burn_area", (w, p) -> {
            for (int i = 0; i < 4; ++i) {
                BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)p, (int)2, (int)2);
                if (pos == null) continue;
                w.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        }));
        ASForfeits.add(Tier.NOVICE, Element.FIRE, ASForfeits.create("fire_ant", (w, p) -> ASForfeits.spawnMobs(EntityFireAnt::new, 2, w, p)));
        ASForfeits.add(Tier.ADVANCED, Element.FIRE, ASForfeits.create("creeper", (w, p) -> ASForfeits.spawnMobs(EntityCreeper::new, 1, w, p)));
        ASForfeits.add(Tier.ADVANCED, Element.FIRE, ASForfeits.create("fire_ant_swarm", (w, p) -> ASForfeits.spawnMobs(EntityFireAnt::new, 12, w, p)));
        ASForfeits.add(Tier.MASTER, Element.FIRE, ASForfeits.create("nether_portals", (w, p) -> {
            for (int i = 0; i < 8; ++i) {
                BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)p, (int)2, (int)3);
                if (pos == null) continue;
                w.func_175656_a(pos, ASBlocks.NETHER_FIRE.func_176223_P());
            }
        }));
        ASForfeits.add(Tier.NOVICE, Element.EARTH, ASForfeits.create("spider", (w, p) -> ASForfeits.spawnMobs(EntitySpider::new, 1, w, p)));
        ASForfeits.add(Tier.ADVANCED, Element.EARTH, ASForfeits.create("wolf_swarm", (w, p) -> {
            if (!w.field_72995_K) {
                BlockPos pos;
                for (int i = 0; i < 4 && (pos = BlockUtils.findNearbyFloorSpace((Entity)p, (int)4, (int)2)) != null; ++i) {
                    EntityWolfMinion mob = new EntityWolfMinion((World)w);
                    mob.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
                    mob.func_70624_b((EntityLivingBase)p);
                    w.func_72838_d((Entity)mob);
                }
            }
        }));
        ASForfeits.add(Tier.APPRENTICE, Element.EARTH, ASForfeits.create("quicksand_ring", (w, p) -> {
            if (!w.field_72995_K) {
                QuicksandRing.summonQuickSandRing(w, null, p.func_180425_c(), new SpellModifiers());
            }
        }));
        ASForfeits.add(Tier.ADVANCED, Element.EARTH, ASForfeits.create("mushroom_ring", (w, p) -> {
            if (!w.field_72995_K) {
                FairyRing.summonMushroomRing(w, null, p.func_180425_c(), new SpellModifiers());
            }
        }));
        ASForfeits.add(Tier.ADVANCED, Element.EARTH, ASForfeits.create("trapped_in_bubble", (w, p) -> {
            if (!w.field_72995_K) {
                EntityBubble bubble = new EntityBubble(w);
                bubble.func_70107_b(p.field_70165_t, p.field_70163_u, p.field_70161_v);
                bubble.lifetime = 160;
                bubble.isDarkOrb = false;
                w.func_72838_d((Entity)bubble);
                p.func_184220_m((Entity)bubble);
            }
        }));
        ASForfeits.add(Tier.ADVANCED, Element.NECROMANCY, ASForfeits.create("curse_armour", (w, p) -> {
            if (!(w.field_72995_K || ItemArtefact.isArtefactActive((EntityPlayer)p, (Item)ASItems.amulet_curse_ward) || p.func_70644_a(ASPotions.curse_ward))) {
                CurseArmor.curseRandomArmourPiece((EntityLivingBase)p, w);
            }
        }));
        ASForfeits.add(Tier.MASTER, Element.NECROMANCY, ASForfeits.create("unluck", (w, p) -> p.func_70690_d(new PotionEffect(MobEffects.field_189112_A, Integer.MAX_VALUE))));
        ASForfeits.add(Tier.MASTER, Element.NECROMANCY, ASForfeits.create("self_curse_of_enfeeblement", (w, p) -> p.func_70690_d(new PotionEffect(WizardryPotions.curse_of_enfeeblement, Integer.MAX_VALUE))));
        ASForfeits.add(Tier.MASTER, Element.NECROMANCY, ASForfeits.create("self_curse_of_gills", (w, p) -> p.func_70690_d(new PotionEffect(ASPotions.curse_of_gills, Integer.MAX_VALUE))));
        ASForfeits.add(Tier.MASTER, Element.NECROMANCY, ASForfeits.create("self_curse_of_umbra", (w, p) -> p.func_70690_d(new PotionEffect(ASPotions.curse_of_umbra, Integer.MAX_VALUE))));
        ASForfeits.add(Tier.ADVANCED, Element.NECROMANCY, ASForfeits.create("skeleton_mage_swarm", (w, p) -> {
            if (!w.field_72995_K) {
                BlockPos pos;
                for (int i = 0; i < 4 && (pos = BlockUtils.findNearbyFloorSpace((Entity)p, (int)4, (int)2)) != null; ++i) {
                    Element element = Element.values()[w.field_73012_v.nextInt(Element.values().length - 1) + 1];
                    EntitySkeletonMageMinion mob = new EntitySkeletonMageMinion((World)w, element);
                    mob.func_184201_a(EntityEquipmentSlot.HEAD, new ItemStack(ASItems.wizard_hat_ancient));
                    mob.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 1, (double)pos.func_177952_p() + 0.5);
                    w.func_72838_d((Entity)mob);
                }
            }
        }));
        ASForfeits.add(Tier.MASTER, Element.NECROMANCY, ASForfeits.create("self_curse_of_ender", (w, p) -> p.func_70690_d(new PotionEffect(ASPotions.curse_of_ender, Integer.MAX_VALUE))));
        ASForfeits.add(Tier.MASTER, Element.NECROMANCY, ASForfeits.create("self_curse_of_death", (w, p) -> p.func_70690_d(new PotionEffect(ASPotions.curse_of_death, 168000))));
        ASForfeits.add(Tier.MASTER, Element.SORCERY, ASForfeits.create("spectral_golem", (w, p) -> ASForfeits.spawnMobs(EntitySpectralGolem::new, 1, w, p)));
        ASForfeits.add(Tier.MASTER, Element.SORCERY, ASForfeits.create("warp_armour", (w, p) -> {
            if (!w.field_72995_K && ASSpells.attire_alteration.isEnabled(new SpellProperties.Context[0]) && WizardData.get((EntityPlayer)p) != null && WizardData.get((EntityPlayer)p).hasSpellBeenDiscovered(ASSpells.attire_alteration)) {
                AttireAlteration.swapArmour(p, w, new SpellModifiers(), 0);
            }
        }));
        ASForfeits.add(Tier.MASTER, Element.SORCERY, ASForfeits.create("contained_in_sphere", (w, p) -> {
            if (!w.field_72995_K) {
                for (BlockPos currPos : ASUtils.getHollowSphere((EntityLivingBase)p, new SpellModifiers(), 4.0f)) {
                    if (!BlockUtils.canBlockBeReplaced((World)w, (BlockPos)currPos) || w.field_72995_K) continue;
                    w.func_175656_a(currPos, WizardryBlocks.spectral_block.func_176223_P());
                    if (!(w.func_175625_s(currPos) instanceof TileEntityTimer)) continue;
                    ((TileEntityTimer)w.func_175625_s(currPos)).setLifetime(1200);
                }
            }
        }));
        ASForfeits.add(Tier.MASTER, Element.SORCERY, ASForfeits.create("summon_tnt", (w, p) -> {
            if (!w.field_72995_K) {
                EntityTNTPrimed tnt = new EntityTNTPrimed(w, p.field_70165_t, p.field_70163_u, p.field_70161_v, null);
                tnt.func_184534_a(60);
                w.func_72838_d((Entity)tnt);
                w.func_184148_a(null, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }));
        ASForfeits.add(Tier.MASTER, Element.SORCERY, ASForfeits.create("self_temporal_curse", (w, p) -> TemporalCasualty.cursePlayer(p)));
        ASForfeits.add(Tier.ADVANCED, Element.HEALING, ASForfeits.create("self_transience", (w, p) -> p.func_70690_d(new PotionEffect(WizardryPotions.transience, 900))));
    }
}

