/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.ritual;

import com.windanesz.ancientspellcraft.entity.construct.EntityArcaneBarrier;
import com.windanesz.ancientspellcraft.misc.DonorPerks;
import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.ritual.IRitualBlockRequirement;
import com.windanesz.ancientspellcraft.ritual.IRitualIngredient;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.tileentity.TileRune;
import com.windanesz.ancientspellcraft.util.ASParticles;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryBlocks;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class ArcaneBarrier
extends Ritual
implements IRitualIngredient,
IRitualBlockRequirement {
    private ItemStack stack = ItemStack.field_190927_a;
    private String BLOCK_TYPE_TAG = "block_type";

    public ArcaneBarrier() {
        super("ancientspellcraft", "arcane_barrier", SpellActions.SUMMON, false);
    }

    @Override
    public void initialEffect(World world, EntityPlayer caster, TileRune centerPiece) {
        if (caster != null && !world.field_72995_K) {
            EntityArcaneBarrier barrier = new EntityArcaneBarrier(world);
            barrier.func_70107_b(centerPiece.getXCenter(), centerPiece.getY(), centerPiece.getZCenter());
            barrier.setCaster((EntityLivingBase)caster);
            barrier.lifetime = 40;
            barrier.setRadius(1.0f);
            world.func_72838_d((Entity)barrier);
        }
    }

    @Override
    public void onRitualFinish(World world, EntityPlayer caster, TileRune centerPiece) {
        super.onRitualFinish(world, caster, centerPiece);
    }

    @Override
    public boolean areContinuousRequirementsMet(World world, TileRune centerPiece) {
        NBTTagCompound ritualData = centerPiece.getRitualData();
        if (ritualData.func_74764_b(this.BLOCK_TYPE_TAG)) {
            String blockName = ritualData.func_74779_i(this.BLOCK_TYPE_TAG);
            for (BlockPos pos : BlockPos.func_177980_a((BlockPos)centerPiece.func_174877_v().func_177985_f(2).func_177964_d(2).func_177977_b(), (BlockPos)centerPiece.func_174877_v().func_177965_g(2).func_177970_e(2).func_177977_b())) {
                if (world.func_180495_p(pos).func_177230_c().getRegistryName().func_110623_a().equals(blockName)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public void effect(World world, EntityPlayer caster, TileRune centerPiece) {
        List barriers;
        super.effect(world, caster, centerPiece);
        if (world.func_82737_E() % 100L == 0L) {
            EntityItem dye;
            List entityItemList;
            if (!this.areContinuousRequirementsMet(world, centerPiece) && world.func_180495_p(centerPiece.func_174877_v()).func_177230_c() == ASBlocks.PLACED_RUNE) {
                world.func_175713_t(centerPiece.func_174877_v());
                world.func_175656_a(centerPiece.func_174877_v(), ASBlocks.RUNE_USED.func_176223_P());
            }
            if (!(entityItemList = EntityUtils.getEntitiesWithinRadius((double)1.0, (double)centerPiece.func_174877_v().func_177958_n(), (double)centerPiece.func_174877_v().func_177956_o(), (double)centerPiece.func_174877_v().func_177952_p(), (World)world, EntityItem.class)).isEmpty() && (dye = (EntityItem)entityItemList.get(0)).func_92059_d().func_77973_b() == Items.field_151100_aR) {
                EntityArcaneBarrier barrier;
                int index = dye.func_92059_d().func_77960_j();
                List barriers2 = EntityUtils.getEntitiesWithinRadius((double)1.0, (double)centerPiece.getX(), (double)centerPiece.getY(), (double)centerPiece.getZ(), (World)world, EntityArcaneBarrier.class);
                if (!barriers2.isEmpty() && (barrier = (EntityArcaneBarrier)((Object)barriers2.get(0))).func_184753_b() != null && !DonorPerks.isDonor(barrier.func_184753_b())) {
                    barrier.setColour(index);
                    dye.func_92059_d().func_190918_g(1);
                }
            }
        }
        if ((barriers = EntityUtils.getEntitiesWithinRadius((double)1.0, (double)centerPiece.getX(), (double)centerPiece.getY(), (double)centerPiece.getZ(), (World)world, EntityArcaneBarrier.class)).isEmpty()) {
            return;
        }
        EntityArcaneBarrier barrier = (EntityArcaneBarrier)((Object)barriers.get(0));
        if (barrier != null) {
            float currentRadius = barrier.getRadius();
            ++((EntityArcaneBarrier)((Object)barriers.get((int)0))).lifetime;
            if (currentRadius < (float)this.getSizeLimit(centerPiece) && !world.field_72995_K) {
                ((EntityArcaneBarrier)((Object)barriers.get(0))).setRadius(currentRadius * 1.001f);
            }
            if (world.field_72995_K) {
                float r = barrier.getColour().getR();
                float g = barrier.getColour().getG();
                float b = barrier.getColour().getB();
                double posX = centerPiece.getXCenter();
                double posY = centerPiece.getY();
                double posZ = centerPiece.getZCenter();
                Random rand = world.field_73012_v;
                if (!barriers.isEmpty()) {
                    float radius = ((EntityArcaneBarrier)((Object)barriers.get(0))).getRadius();
                    if (world.func_82737_E() % 3L == 0L) {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)rand, (double)(posX + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.5 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).vel(0.0, 0.3, 0.0).clr(r, g, b).time(20 + rand.nextInt((int)radius)).spawn(world);
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE, (Random)rand, (double)(posX + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)posY, (double)(posZ + rand.nextDouble() * 0.2 * (double)(rand.nextBoolean() ? 1 : -1)), (double)0.03, (boolean)true).spin(0.7, 0.05).vel(0.0, 0.3, 0.0).clr(r, g, b).fade(230, 230, 230).time(20 + rand.nextInt((int)radius)).spawn(world);
                    }
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(r, g, b).face(EnumFacing.UP).pos(posX, posY + (double)0.01f, posZ).scale(2.0f).spawn(world);
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(r, g, b).pos(posX, posY + (double)0.01f, posZ).scale(0.9f).spawn(world);
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(r, g, b).face(EnumFacing.UP).pos(posX, (double)((float)centerPiece.getY() + radius - 0.4f), posZ).scale(Math.min(4.0f, radius * 0.3f)).spawn(world);
                    Vec3d target = new Vec3d(posX, (double)((float)centerPiece.getY() + radius - 0.4f), posZ);
                    ParticleBuilder.create((ResourceLocation)ASParticles.CONSTANT_BEAM).clr(r, g, b).pos(posX, posY, posZ).target(target).scale(1.5f).shaded(true).time(2).spawn(world);
                }
            }
        }
    }

    @Override
    public boolean areInitialRequirementsMet(World world, TileRune centerPiece) {
        ArrayList<Block> blockList = new ArrayList<Block>();
        blockList.add(Blocks.field_150368_y);
        blockList.add(WizardryBlocks.crystal_block);
        blockList.add(Blocks.field_150340_R);
        blockList.add(Blocks.field_150475_bE);
        blockList.add(Blocks.field_150484_ah);
        for (Block block : blockList) {
            boolean allMatches = true;
            Iterable posIterable = BlockPos.func_177980_a((BlockPos)centerPiece.func_174877_v().func_177985_f(2).func_177964_d(2).func_177977_b(), (BlockPos)centerPiece.func_174877_v().func_177965_g(2).func_177970_e(2).func_177977_b());
            for (BlockPos pos : posIterable) {
                if (world.func_180495_p(pos).func_177230_c() == block) continue;
                allMatches = false;
                break;
            }
            allMatches = true;
            if (!true) continue;
            NBTTagCompound ritualData = centerPiece.getRitualData();
            Block currBlock = world.func_180495_p(centerPiece.func_174877_v().func_177977_b()).func_177230_c();
            if (currBlock.getRegistryName() == null) continue;
            ritualData.func_74778_a(this.BLOCK_TYPE_TAG, currBlock.getRegistryName().func_110623_a());
            centerPiece.setRitualData(ritualData);
            centerPiece.sendUpdates();
            return true;
        }
        return false;
    }

    private int getSizeLimit(TileRune centerPiece) {
        NBTTagCompound ritualData = centerPiece.getRitualData();
        if (ritualData.func_74764_b(this.BLOCK_TYPE_TAG)) {
            String blockName = ritualData.func_74779_i(this.BLOCK_TYPE_TAG);
            return SizeLimits.getRadiusLimit(blockName);
        }
        return SizeLimits.LAPIS_BLOCK.radiusLimit;
    }

    @Override
    public List<List<ItemStack>> getRequiredIngredients() {
        ArrayList<List<ItemStack>> ingredients = new ArrayList<List<ItemStack>>();
        ArrayList<ItemStack> grandCrystal = new ArrayList<ItemStack>();
        grandCrystal.add(new ItemStack(WizardryItems.grand_crystal));
        ingredients.add(grandCrystal);
        return ingredients;
    }

    private static enum SizeLimits {
        LAPIS_BLOCK("lapis_block", 10),
        MAGIC_CRYSTAL("CRYSTAL_BLOCK", 20),
        EMERALD_BLOCK("emerald_block", 25),
        GOLD_BLOCK("gold_block", 30),
        DIAMOND_BLOCK("diamond_block", 35);

        private String block;
        private int radiusLimit;

        private SizeLimits(String block, int radiusLimit) {
            this.block = block;
            this.radiusLimit = radiusLimit;
        }

        public static int getRadiusLimit(String checkBlock) {
            for (int i = 0; i < SizeLimits.values().length; ++i) {
                if (!SizeLimits.values()[i].block.equals(checkBlock.toLowerCase())) continue;
                return SizeLimits.values()[i].radiusLimit;
            }
            return 15;
        }
    }
}

