/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.ritual;

import com.windanesz.ancientspellcraft.ritual.IRitualIngredient;
import com.windanesz.ancientspellcraft.ritual.Ritual;
import com.windanesz.ancientspellcraft.tileentity.TileRune;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

public class Forest
extends Ritual
implements IRitualIngredient {
    public static final IStoredVariable<BlockPos> RITUAL_MARK_LOCATION = IStoredVariable.StoredVariable.ofBlockPos((String)"ritual_mark_location", (Persistence)Persistence.ALWAYS).setSynced();

    public Forest() {
        super("ancientspellcraft", "forest", SpellActions.SUMMON, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{RITUAL_MARK_LOCATION});
    }

    @Override
    public void initialEffect(World world, EntityPlayer caster, TileRune centerPiece) {
        this.ruinNonCenterPieceRunes(centerPiece, world);
    }

    @Override
    public void effect(World world, EntityPlayer caster, TileRune centerPiece) {
        block7: {
            block8: {
                super.effect(world, caster, centerPiece);
                if (world.field_72995_K) break block7;
                if (centerPiece.getRitualData() != null && centerPiece.getRitualData().func_74764_b("wood_type")) break block8;
                List actualIngredients = this.getActualIngredients(world, centerPiece, 1);
                if (actualIngredients.isEmpty()) break block7;
                NBTTagCompound compound = new NBTTagCompound();
                if (((EntityItem)actualIngredients.get(0)).func_92059_d().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150345_g)) break block7;
                compound.func_74768_a("wood_type", ((EntityItem)actualIngredients.get(0)).func_92059_d().func_77960_j());
                centerPiece.setRitualData(compound);
                centerPiece.func_70296_d();
                ((EntityItem)actualIngredients.get(0)).func_92059_d().func_190918_g(1);
                break block7;
            }
            if (world.func_82737_E() % 40L == 0L) {
                int woodType = centerPiece.getRitualData().func_74762_e("wood_type");
                BlockPos centerPos = centerPiece.func_174877_v();
                int x = centerPos.func_177958_n();
                int y = centerPos.func_177956_o();
                int z = centerPos.func_177952_p();
                x += Math.max(world.field_73012_v.nextInt(30), 3) * (world.field_73012_v.nextBoolean() ? 1 : -1);
                z += Math.max(world.field_73012_v.nextInt(30), 3) * (world.field_73012_v.nextBoolean() ? 1 : -1);
                boolean test = false;
                for (int i = 0; i < 20 && !test; ++i) {
                    BlockPos testPos;
                    IBlockState soil;
                    int j = i;
                    if (i > 10) {
                        j = -1 * j - 10;
                    }
                    if (!(soil = world.func_180495_p((testPos = new BlockPos(x, y += j, z)).func_177977_b())).func_177230_c().canSustainPlant(soil, (IBlockAccess)world, testPos.func_177977_b(), EnumFacing.UP, (IPlantable)((BlockSapling)Blocks.field_150345_g))) continue;
                    BlockPos treePos = new BlockPos(x, y, z);
                    if (BlockUtils.canPlaceBlock((Entity)caster, (World)world, (BlockPos)treePos)) {
                        world.func_175656_a(treePos, Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.func_176837_a((int)woodType)));
                        if (BlockPlanks.EnumType.func_176837_a((int)woodType) == BlockPlanks.EnumType.DARK_OAK) {
                            // empty if block
                        }
                    }
                    if (world.func_180495_p(treePos).func_177230_c() != Blocks.field_150345_g) continue;
                    ((BlockSapling)world.func_180495_p(treePos).func_177230_c()).func_176476_e(world, treePos, world.func_180495_p(treePos), world.field_73012_v);
                    test = true;
                }
            }
        }
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).clr(83, 173, 23).pos((double)((float)centerPiece.getX() + 0.5f), (double)((float)centerPiece.getY() + 0.5f), (double)((float)centerPiece.getZ() + 0.5f)).scale(2.0f).spawn(world);
            for (int i = 0; i < 4; ++i) {
                double dx = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                double dy = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                double dz = world.field_73012_v.nextDouble() * (double)(world.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.LEAF).clr(50, 168, 72).pos((double)centerPiece.getXCenter(), (double)centerPiece.getYCenter(), (double)centerPiece.getZCenter()).vel(dx, dy, dz).time(60).spawn(world);
            }
        }
    }

    @Override
    public List<List<ItemStack>> getRequiredIngredients() {
        ArrayList<List<ItemStack>> ingredients = new ArrayList<List<ItemStack>>();
        ArrayList<ItemStack> woods = new ArrayList<ItemStack>();
        for (BlockPlanks.EnumType value : BlockPlanks.EnumType.values()) {
            woods.add(new ItemStack(Blocks.field_150345_g, 1, value.func_176839_a()));
        }
        ingredients.add(woods);
        return ingredients;
    }
}

