/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.living.EntityAnimatedItem;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.item.IConjuredItem;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellMinion;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class Animate
extends SpellMinion<EntityAnimatedItem> {
    public Animate(String modid, String name) {
        super(modid, name, EntityAnimatedItem::new);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!this.spawnMinions(world, (EntityLivingBase)caster, modifiers, true)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!this.spawnMinions(world, (EntityLivingBase)caster, modifiers, true)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public static void equipFromOffhand(EntityAnimatedItem minion, BlockPos pos, @Nullable EntityLivingBase caster, SpellModifiers modifiers) {
        if (caster != null && !caster.func_184592_cb().func_190926_b()) {
            ItemStack stack = caster.func_184592_cb().func_77946_l();
            stack.func_190920_e(1);
            caster.func_184592_cb().func_190918_g(1);
            minion.func_184611_a(EnumHand.MAIN_HAND, stack);
            minion.setItemType(stack.func_77973_b().getRegistryName().toString());
            minion.setHasArmour(false);
        }
    }

    public static void equipWith(EntityAnimatedItem minion, ItemStack stack) {
        minion.func_184611_a(EnumHand.MAIN_HAND, stack);
        minion.setItemType(stack.func_77973_b().getRegistryName().toString());
        minion.setHasArmour(false);
    }

    public static ItemStack conjureItem(SpellModifiers modifiers, Item item) {
        if (item instanceof IConjuredItem) {
            ItemStack stack = new ItemStack(item);
            IConjuredItem.setDurationMultiplier((ItemStack)stack, (float)modifiers.get(WizardryItems.duration_upgrade));
            IConjuredItem.setDamageMultiplier((ItemStack)stack, (float)modifiers.get("potency"));
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public static ItemStack findAmmo(EntityPlayer player) {
        if (Animate.isArrow(player.func_184586_b(EnumHand.OFF_HAND))) {
            return player.func_184586_b(EnumHand.OFF_HAND);
        }
        if (Animate.isArrow(player.func_184586_b(EnumHand.MAIN_HAND))) {
            return player.func_184586_b(EnumHand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!Animate.isArrow(itemstack)) continue;
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    protected static boolean isArrow(ItemStack stack) {
        return stack.func_77973_b() instanceof ItemArrow;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }

    public boolean spawnMinions(World world, EntityLivingBase caster, SpellModifiers modifiers, boolean damageScalesWithPotency) {
        if (!world.field_72995_K) {
            for (int i = 0; i < this.getProperty("minion_count").intValue(); ++i) {
                IAttributeInstance attribute;
                int range = this.getProperty("summon_radius").intValue();
                BlockPos pos = BlockUtils.findNearbyFloorSpace((Entity)caster, (int)range, (int)(range * 2));
                if (this.flying) {
                    pos = pos != null ? pos.func_177981_b(2) : caster.func_180425_c().func_177964_d(world.field_73012_v.nextInt(range * 2) - range).func_177965_g(world.field_73012_v.nextInt(range * 2) - range);
                } else if (pos == null) {
                    return false;
                }
                EntityAnimatedItem minion = (EntityAnimatedItem)this.createMinion(world, caster, modifiers);
                minion.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                minion.setCaster(caster);
                minion.setLifetime((int)(this.getProperty("minion_lifetime").floatValue() * modifiers.get(WizardryItems.duration_upgrade)));
                if (damageScalesWithPotency && (attribute = minion.func_110148_a(SharedMonsterAttributes.field_111264_e)) != null) {
                    attribute.func_111121_a(new AttributeModifier("potency", (double)(modifiers.get("potency") - 1.0f), 2));
                }
                minion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("minion_health", (double)(modifiers.get("minion_health") - 1.0f), 2));
                minion.func_70606_j(minion.func_110138_aP());
                this.addMinionExtras((EntityLiving)minion, pos, caster, modifiers, i);
                world.func_72838_d((Entity)minion);
            }
        }
        return true;
    }
}

