/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.entity.EntityMeteor;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellAreaEffect;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class Armageddon
extends SpellAreaEffect {
    public static final String BURN_DURATION = "burn_duration";
    public static final String MAX_DAMAGE = "max_damage";

    public Armageddon() {
        super("ancientspellcraft", "armageddon", SpellActions.SUMMON, true);
        this.addProperties(new String[]{BURN_DURATION, MAX_DAMAGE});
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        boolean f = super.cast(world, caster, hand, ticksInUse, modifiers);
        if (!world.field_72995_K) {
            float radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
            List sphere = BlockUtils.getBlockSphere((BlockPos)caster.func_180425_c().func_177981_b(6), (double)radius);
            int yPos = caster.func_180425_c().func_177956_o() + 16;
            List validSpawnLocations = sphere.stream().filter(p -> {
                if (p.func_177956_o() != yPos) return false;
                BlockPos blockPos = new BlockPos(caster.field_70165_t, (double)p.func_177956_o(), caster.field_70161_v);
                if (!(p.func_177951_i((Vec3i)blockPos) > 9.0)) return false;
                return true;
            }).collect(Collectors.toList());
            for (int i = 0; i < 1 && !validSpawnLocations.isEmpty(); ++i) {
                BlockPos currPos = (BlockPos)validSpawnLocations.remove(world.field_73012_v.nextInt(validSpawnLocations.size()));
                System.out.println("distance: " + currPos.func_177951_i((Vec3i)caster.func_180425_c()));
                EntityMeteor meteor = new EntityMeteor(world, (double)currPos.func_177958_n() + 0.5, (double)currPos.func_177956_o(), (double)currPos.func_177952_p() + 0.5, 0.5f, true);
                meteor.field_70159_w = 0.0;
                meteor.field_70181_x = -1.0;
                meteor.field_70179_y = 0.0;
                world.func_72838_d((Entity)meteor);
            }
        } else {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).clr(255, 255, 247).vel(0.0, 0.1, 0.0).fade(1.0f, 1.0f, 1.0f).spin((double)0.8f, (double)0.03f).time(40).entity((Entity)caster).scale(1.2f).spawn(world);
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_FIRE).clr(255, 255, 247).vel(0.0, 0.1, 0.0).fade(1.0f, 1.0f, 1.0f).spin((double)0.8f, (double)-0.03f).time(40).entity((Entity)caster).scale(1.2f).spawn(world);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    protected boolean affectEntity(World world, Vec3d origin, @Nullable EntityLivingBase caster, EntityLivingBase target, int targetCount, int ticksInUse, SpellModifiers modifiers) {
        return !(caster instanceof EntityPlayer) || !AllyDesignationSystem.isAllied((EntityLivingBase)((EntityPlayer)caster), (EntityLivingBase)target);
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

