/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.living.EntityAnimatedItem;
import com.windanesz.ancientspellcraft.item.ItemSageTome;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.Animate;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AwakenTome
extends Animate
implements IClassSpell {
    public static final IStoredVariable<UUID> UUID_KEY = IStoredVariable.StoredVariable.ofUUID((String)"awakenedTomeUUID", (Persistence)Persistence.ALWAYS).setSynced();

    public AwakenTome() {
        super("ancientspellcraft", "awaken_tome");
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{UUID_KEY});
    }

    public static void equipWithTome(EntityAnimatedItem minion, @Nullable EntityLivingBase caster) {
        if (caster != null && caster.func_184614_ca().func_77973_b() instanceof ItemSageTome) {
            ItemStack stack = caster.func_184614_ca().func_77946_l();
            stack.func_190920_e(1);
            caster.func_184614_ca().func_190918_g(1);
            minion.func_184611_a(EnumHand.MAIN_HAND, stack);
            minion.setItemType(stack.func_77973_b().getRegistryName().toString());
            minion.setHasArmour(false);
            AwakenTome.setTome((EntityPlayer)caster, minion);
            caster.func_184611_a(EnumHand.MAIN_HAND, new ItemStack(ASItems.tome_controller));
        }
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster.func_184586_b(hand).func_77973_b() instanceof ItemSageTome)) {
            return false;
        }
        EntityAnimatedItem oldTome = AwakenTome.getTome(caster);
        if (oldTome != null) {
            AwakenTome.recallTome(oldTome);
            this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
            return true;
        }
        if (!this.spawnMinions(world, (EntityLivingBase)caster, modifiers, true)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    protected void addMinionExtras(EntityAnimatedItem minion, BlockPos pos, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int alreadySpawned) {
        super.addMinionExtras((EntityLiving)minion, pos, caster, modifiers, alreadySpawned);
        AwakenTome.equipWithTome(minion, caster);
        AwakenTome.setTome((EntityPlayer)caster, minion);
    }

    @Nullable
    public static EntityAnimatedItem getTome(EntityPlayer caster) {
        Entity oldTome;
        WizardData data;
        if (caster != null && (data = WizardData.get((EntityPlayer)caster)) != null && (oldTome = EntityUtils.getEntityByUUID((World)caster.field_70170_p, (UUID)((UUID)data.getVariable(UUID_KEY)))) instanceof EntityAnimatedItem) {
            return (EntityAnimatedItem)oldTome;
        }
        return null;
    }

    public static void setTome(EntityPlayer caster, EntityAnimatedItem tome) {
        WizardData data;
        if (caster != null && (data = WizardData.get((EntityPlayer)caster)) != null) {
            data.setVariable(UUID_KEY, (Object)tome.func_110124_au());
            data.sync();
        }
    }

    public static void recallTome(EntityAnimatedItem tome) {
        if (tome != null) {
            tome.onDespawn();
            tome.func_70106_y();
        }
    }

    public static void removeController(EntityPlayer player) {
        ASUtils.shrinkInventoryStackByOne(player, new ItemStack(ASItems.tome_controller));
    }
}

