/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Tier;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWand;
import electroblob.wizardry.registry.WizardryAdvancementTriggers;
import electroblob.wizardry.registry.WizardrySounds;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.WandHelper;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Conduit
extends Spell {
    private static int TRANSFER_AMOUNT = 2;
    private static String TRANSFER_EFFICIENCY = "transfer_efficiency";
    private static String TRANSFER_AMOUNT_PER_TICK = "transfer_amount_per_tick";

    public Conduit() {
        super("ancientspellcraft", "conduit", EnumAction.BLOCK, true);
        this.addProperties(new String[]{"duration", TRANSFER_EFFICIENCY, TRANSFER_AMOUNT_PER_TICK});
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    protected SoundEvent[] createSounds() {
        return this.createContinuousSpellSounds();
    }

    protected void playSound(World world, EntityLivingBase entity, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, entity, ticksInUse);
    }

    protected void playSound(World world, double x, double y, double z, int ticksInUse, int duration, SpellModifiers modifiers, String ... sounds) {
        this.playSoundLoop(world, x, y, z, ticksInUse, duration);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        this.performEffect(world, caster.func_174824_e(0.0f).func_178786_a(0.0, 0.1, 0.0), (EntityLivingBase)caster, modifiers, ticksInUse);
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return false;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return false;
    }

    private void performEffect(World world, Vec3d centre, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int ticksInUse) {
        if (caster instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)caster;
            if (player.func_184614_ca().func_77973_b() instanceof ItemWand && (player.func_184592_cb().func_77973_b() instanceof ItemWand || ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.ring_mana_transfer))) {
                ItemStack sourceWandStack = player.func_184614_ca();
                ItemStack targetWandStack = player.func_184592_cb();
                ItemWand sourceWand = (ItemWand)sourceWandStack.func_77973_b();
                ItemWand targetWand = (ItemWand)targetWandStack.func_77973_b();
                if (!Wizardry.settings.legacyWandLevelling && ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_progression_orb)) {
                    if (targetWand.tier.level < Tier.MASTER.level) {
                        int sourceProgression = WandHelper.getProgression((ItemStack)sourceWandStack);
                        int targetProgression = WandHelper.getProgression((ItemStack)targetWandStack);
                        int amount = 10;
                        if (sourceProgression > 0) {
                            Tier nextTier = targetWand.tier.next();
                            int excess = WandHelper.getProgression((ItemStack)targetWandStack) - nextTier.getProgression();
                            if (excess >= 0 && excess < amount) {
                                caster.func_184185_a(WizardrySounds.ITEM_WAND_LEVELUP, 1.25f, 1.0f);
                                WizardryAdvancementTriggers.wand_levelup.triggerFor(player);
                                if (!world.field_72995_K) {
                                    caster.func_145747_a((ITextComponent)new TextComponentTranslation("item.ebwizardry:wand.levelup", new Object[]{targetWand.func_77653_i(targetWandStack), nextTier.getNameForTranslationFormatted()}));
                                }
                            } else if (sourceProgression > 10 && sourceWand.getMana(sourceWandStack) > 10) {
                                WandHelper.setProgression((ItemStack)targetWandStack, (int)(targetProgression + 10));
                                WandHelper.setProgression((ItemStack)sourceWandStack, (int)(sourceProgression - 10));
                                sourceWand.consumeMana(sourceWandStack, 10, (EntityLivingBase)player);
                                if (world.field_72995_K) {
                                    Conduit.spawnParticle(player, true);
                                }
                            }
                        }
                    }
                } else if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.ring_mana_transfer)) {
                    Vec3d look = caster.func_70040_Z();
                    double Y_OFFSET = 0.25;
                    Vec3d origin = new Vec3d(caster.field_70165_t, caster.field_70163_u + (double)caster.func_70047_e() - Y_OFFSET, caster.field_70161_v);
                    this.shootSpell(world, origin, look, player, ticksInUse, modifiers);
                } else if (!sourceWand.isManaEmpty(sourceWandStack) && !targetWand.isManaFull(targetWandStack)) {
                    int amount = this.getProperty(TRANSFER_AMOUNT_PER_TICK).intValue();
                    sourceWand.consumeMana(sourceWandStack, amount, (EntityLivingBase)player);
                    int newAmount = (int)((float)amount * this.getProperty(TRANSFER_EFFICIENCY).floatValue());
                    sourceWand.rechargeMana(targetWandStack, newAmount);
                    if (world.field_72995_K) {
                        Conduit.spawnParticle(player, true);
                    }
                }
            } else if (!player.field_70170_p.field_72995_K) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:conduit.no_wand", new Object[0]), true);
            }
        }
    }

    private static void spawnParticle(EntityPlayer player, boolean progression) {
        double speed = (double)(player.field_70170_p.field_73012_v.nextBoolean() ? 1 : -1) * 0.1;
        double radius = player.field_70170_p.field_73012_v.nextDouble() * 2.0;
        float angle = player.field_70170_p.field_73012_v.nextFloat() * (float)Math.PI * 2.0f;
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.FLASH).pos(player.field_70165_t + radius / 3.0 * (double)MathHelper.func_76134_b((float)angle), player.field_70163_u, player.field_70161_v + radius / 3.0 * (double)MathHelper.func_76126_a((float)angle)).vel(0.0, 0.05, 0.0).scale(0.7f).time(48 + player.field_70170_p.field_73012_v.nextInt(12)).spin(1.5, speed).clr(121, 219, 9).spawn(player.field_70170_p);
    }

    protected void shootSpell(World world, Vec3d origin, Vec3d direction, @Nullable EntityPlayer caster, int ticksInUse, SpellModifiers modifiers) {
        boolean ignoreLivingEntities;
        double range = 10.0;
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)0.0f, (boolean)false, (boolean)true, (boolean)false, Entity.class, (Predicate)((ignoreLivingEntities = false) ? EntityUtils::isLiving : RayTracer.ignoreEntityFilter((Entity)caster)));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.ENTITY) {
            this.onEntityHit(world, rayTrace.field_72308_g, rayTrace.field_72307_f, (EntityLivingBase)caster, origin, ticksInUse, modifiers);
        }
    }

    protected void onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        EntityPlayer targetPlayer;
        if (target instanceof EntityPlayer && !(targetPlayer = (EntityPlayer)target).func_184614_ca().func_190926_b() && targetPlayer.func_184614_ca().func_77973_b() instanceof ItemWand && caster.func_184614_ca().func_77973_b() instanceof ItemWand) {
            ItemStack sourceWandStack;
            ItemWand targetWand = (ItemWand)targetPlayer.func_184614_ca().func_77973_b();
            ItemStack targetWandStack = targetPlayer.func_184614_ca();
            ItemWand sourceWand = (ItemWand)caster.func_184614_ca().func_77973_b();
            if (!sourceWand.isManaEmpty(sourceWandStack = caster.func_184614_ca()) && !targetWand.isManaFull(targetWandStack)) {
                int amount = this.getProperty(TRANSFER_AMOUNT_PER_TICK).intValue();
                sourceWand.consumeMana(sourceWandStack, amount, caster);
                int newAmount = (int)((float)amount * this.getProperty(TRANSFER_EFFICIENCY).floatValue());
                sourceWand.rechargeMana(targetWandStack, newAmount);
                if (world.field_72995_K) {
                    Conduit.spawnParticle(targetPlayer, true);
                }
            }
        }
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

