/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASBlocks;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.SpellBuff;
import electroblob.wizardry.util.AllyDesignationSystem;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.MagicDamage;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Cryostasis
extends SpellBuff {
    public static final String ICE_DURATION = "ice_duration";

    public Cryostasis() {
        super("ancientspellcraft", "cryostasis", 11.0f, 215.0f, 222.0f, new Supplier[]{() -> WizardryPotions.frost, () -> MobEffects.field_76428_l, () -> MobEffects.field_76444_x});
        this.soundValues(1.0f, 1.0f, 0.0f);
        this.addProperties(new String[]{ICE_DURATION, "effect_duration", "effect_strength"});
    }

    protected boolean applyEffects(EntityLivingBase caster, SpellModifiers modifiers) {
        super.applyEffects(caster, modifiers);
        if (!caster.field_70170_p.field_72995_K && EntityUtils.canDamageBlocks((Entity)caster, (World)caster.field_70170_p)) {
            if (caster.func_70027_ad()) {
                caster.func_70066_B();
            }
            caster.func_70634_a((double)caster.func_180425_c().func_177958_n() + 0.5, (double)caster.func_180425_c().func_177956_o(), (double)caster.func_180425_c().func_177952_p() + 0.5);
            BlockPos pos = caster.func_180425_c();
            for (EntityLivingBase currentTarget : EntityUtils.getEntitiesWithinRadius((double)4.0, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)caster.field_70170_p, EntityLivingBase.class)) {
                if (!AllyDesignationSystem.isValidTarget((Entity)caster, (Entity)currentTarget) || MagicDamage.isEntityImmune((MagicDamage.DamageType)MagicDamage.DamageType.FROST, (Entity)currentTarget)) continue;
                EntityUtils.applyStandardKnockback((Entity)caster, (EntityLivingBase)currentTarget);
                EntityUtils.applyStandardKnockback((Entity)caster, (EntityLivingBase)currentTarget);
                currentTarget.func_70690_d(new PotionEffect(WizardryPotions.frost, (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade)), this.getProperty("effect_strength").intValue() + SpellBuff.getStandardBonusAmplifier((float)modifiers.get("potency"))));
            }
            for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos.func_177972_a(EnumFacing.SOUTH).func_177972_a(EnumFacing.EAST).func_177972_a(EnumFacing.DOWN), (BlockPos)pos.func_177967_a(EnumFacing.UP, 2).func_177972_a(EnumFacing.NORTH).func_177972_a(EnumFacing.WEST))) {
                if (currPos == caster.func_180425_c() || currPos == caster.func_180425_c().func_177972_a(EnumFacing.UP)) continue;
                int duration = (int)(this.getProperty("effect_duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade));
                if (!BlockUtils.canBlockBeReplaced((World)caster.field_70170_p, (BlockPos)currPos)) continue;
                caster.field_70170_p.func_175656_a(currPos, ASBlocks.HARD_FROSTED_ICE.func_176223_P());
                caster.field_70170_p.func_175684_a(currPos.func_185334_h(), ASBlocks.HARD_FROSTED_ICE, duration);
            }
            caster.field_70170_p.func_175698_g(caster.func_180425_c());
            caster.field_70170_p.func_175698_g(caster.func_180425_c().func_177972_a(EnumFacing.UP));
            if (caster instanceof EntityPlayer && ((EntityPlayer)caster).func_71024_bL().func_75121_c()) {
                ((EntityPlayer)caster).func_71024_bL().func_75122_a(5, 0.1f);
            }
        }
        return true;
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        if (world.field_72995_K) {
            float particleCount = 10.0f;
            for (int i = 0; i < 2; ++i) {
                double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                double y = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 1.0 + world.field_73012_v.nextDouble();
                double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(caster.field_70165_t, caster.func_174813_aQ().field_72338_b + 0.1, caster.field_70161_v).scale(2.0f).clr(117, 255, 250).spawn(world);
            }
        }
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

