/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.spell.SpellRayAS;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.util.SpellModifiers;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EmpoweringLink
extends SpellRayAS {
    public static final IStoredVariable<UUID> UUID_KEY = IStoredVariable.StoredVariable.ofUUID((String)"empoweringLinkTarget", (Persistence)Persistence.NEVER).withTicker(EmpoweringLink::update);
    public static final IStoredVariable<UUID> LAST_UUID_KEY = IStoredVariable.StoredVariable.ofUUID((String)"empoweringLinkLastTarget", (Persistence)Persistence.ALWAYS);

    public EmpoweringLink() {
        super("empowering_link", SpellActions.POINT, true);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{UUID_KEY, LAST_UUID_KEY});
    }

    private static UUID update(EntityPlayer player, UUID uuid) {
        EntityPlayer empoweredPlayer;
        if (player != null && player.field_70173_aa % 60 == 0 && uuid != null && (empoweredPlayer = player.field_70170_p.func_152378_a(uuid)) != null) {
            if (player.field_71093_bK != empoweredPlayer.field_71093_bK) {
                return null;
            }
            empoweredPlayer.func_70690_d(new PotionEffect(WizardryPotions.empowerment, 60, 0));
            empoweredPlayer.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 60, 0));
            empoweredPlayer.func_70690_d(new PotionEffect(MobEffects.field_76420_g, 60, 0));
            player.func_70690_d(new PotionEffect(ASPotions.magical_exhaustion, 60, 0));
            player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 60, 0));
            player.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 60, 0));
        }
        return uuid;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (target instanceof EntityPlayer && caster instanceof EntityPlayer) {
            WizardData data = WizardData.get((EntityPlayer)((EntityPlayer)caster));
            UUID uuid = (UUID)data.getVariable(UUID_KEY);
            if (uuid == target.func_110124_au()) {
                data.setVariable(UUID_KEY, null);
                return true;
            }
            data.setVariable(UUID_KEY, (Object)uuid);
            data.setVariable(LAST_UUID_KEY, (Object)uuid);
            return true;
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        EntityPlayer player;
        if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)(player = (EntityPlayer)caster), (Item)ASItems.ring_devotion)) {
            WizardData data = WizardData.get((EntityPlayer)player);
            UUID lastUUID = (UUID)data.getVariable(LAST_UUID_KEY);
            UUID currentUUID = (UUID)data.getVariable(UUID_KEY);
            if (lastUUID != null) {
                if (currentUUID != null && currentUUID != lastUUID) {
                    data.setVariable(UUID_KEY, (Object)lastUUID);
                } else if (currentUUID != null) {
                    data.setVariable(UUID_KEY, null);
                }
            }
        }
        return false;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return false;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        world.func_175688_a(EnumParticleTypes.FLAME, x, y, z, 0.0, 0.0, 0.0, new int[0]);
    }
}

