/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Extension
extends SpellRay
implements IClassSpell {
    public static final String MAX_BONUS_DURATION = "max_bonus_duration";

    public Extension() {
        super("ancientspellcraft", "extension", SpellActions.POINT, false);
        this.addProperties(new String[]{MAX_BONUS_DURATION});
    }

    public boolean affectEntity(EntityLivingBase target, World world) {
        if (!world.field_72995_K) {
            ArrayList<PotionEffect> potions = new ArrayList<PotionEffect>(target.func_70651_bq());
            ArrayList<String> blacklist = new ArrayList<String>(Arrays.asList(Settings.generalSettings.extension_spell_blacklist));
            if (!potions.isEmpty()) {
                potions.removeIf(p -> blacklist.contains(p.func_188419_a().getRegistryName().toString()));
            }
            if (!potions.isEmpty()) {
                PotionEffect oldEffect = (PotionEffect)potions.get(world.field_73012_v.nextInt(potions.size()));
                int oldDuration = oldEffect.func_76459_b();
                int newDuration = Math.min(oldDuration * 2, oldDuration + this.getProperty(MAX_BONUS_DURATION).intValue());
                PotionEffect newEffect = new PotionEffect(oldEffect.func_188419_a(), oldEffect.func_76458_c(), newDuration);
                target.func_184589_d(oldEffect.func_188419_a());
                target.func_70690_d(newEffect);
                return true;
            }
        }
        return false;
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null && caster.func_70093_af()) {
            return this.affectEntity(caster, world);
        }
        if (EntityUtils.isLiving((Entity)target)) {
            return this.affectEntity((EntityLivingBase)target, world);
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null && caster.func_70093_af()) {
            return this.affectEntity(caster, world);
        }
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        if (caster != null && caster.func_70093_af()) {
            return this.affectEntity(caster, world);
        }
        return false;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(5709413).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(2430473).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(740160).spawn(world);
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    @Override
    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book || item == WizardryItems.scroll;
    }
}

