/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFire;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Extinguish
extends Spell {
    public Extinguish(String modID, String name) {
        super(modID, name, EnumAction.NONE, false);
        this.addProperties(new String[]{"effect_radius"});
        this.soundValues(1.0f, 1.2f, 0.2f);
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        double radius = this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade);
        this.playSound(world, caster.field_70165_t, caster.field_70163_u, caster.field_70161_v, 0, 0, modifiers, new String[0]);
        List sphere = BlockUtils.getBlockSphere((BlockPos)caster.func_180425_c(), (double)(this.getProperty("effect_radius").floatValue() * modifiers.get(WizardryItems.blast_upgrade)));
        List targets = EntityUtils.getEntitiesWithinRadius((double)radius, (double)caster.field_70165_t, (double)caster.field_70163_u, (double)caster.field_70161_v, (World)world, EntityLivingBase.class);
        for (EntityLivingBase target : targets) {
            if (!target.func_70027_ad()) continue;
            target.func_70066_B();
        }
        for (BlockPos pos : sphere) {
            Block block = world.func_180495_p(pos).func_177230_c();
            if (!(block instanceof BlockFire)) continue;
            world.func_175698_g(pos);
        }
        if (caster.func_70027_ad()) {
            caster.func_70066_B();
        }
        if (!caster.func_70644_a(MobEffects.field_76426_n)) {
            caster.func_70690_d(new PotionEffect(MobEffects.field_76426_n, 60));
        }
        if (world.field_72995_K) {
            float particleCount = 10.0f;
            float r = 0.0f;
            float g = 0.0f;
            float b = 237.0f;
            int i = 0;
            while ((float)i < particleCount) {
                double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                double y = caster.func_174813_aQ().field_72338_b + (double)caster.func_70047_e() - 1.0 + world.field_73012_v.nextDouble();
                double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_BUBBLE).pos(x, y, z).vel(0.0, 0.1, 0.4).clr(r, g, b).spawn(world);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_BUBBLE).pos(x, y, z).vel(0.0, 0.1, -0.4).clr(r, g, b).spawn(world);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_BUBBLE).pos(x, y, z).vel(0.4, 0.1, 0.0).clr(r, g, b).spawn(world);
                ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.MAGIC_BUBBLE).pos(x, y, z).vel(-0.4, 0.1, 0.0).clr(r, g, b).spawn(world);
                ++i;
            }
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPHERE).pos(caster.field_70165_t, caster.func_174813_aQ().field_72338_b + 0.1, caster.field_70161_v).scale((float)radius * 0.8f).clr(0.1f, 0.1f, 1.0f).spawn(world);
        }
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

