/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.BlockMagicMushroom;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class FairyRing
extends Spell {
    public FairyRing() {
        super("ancientspellcraft", "fairy_ring", SpellActions.SUMMON, false);
        this.addProperties(new String[]{"effect_radius", "duration", "damage"});
    }

    public boolean requiresPacket() {
        return false;
    }

    public boolean canBeCastBy(EntityLiving npc, boolean override) {
        return true;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!FairyRing.summonMushroomRing(world, (EntityLivingBase)caster, caster.func_180425_c(), modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (!FairyRing.summonMushroomRing(world, (EntityLivingBase)caster, caster.func_180425_c(), modifiers)) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        if (!FairyRing.summonMushroomRing(world, null, new BlockPos(x, y, z).func_177972_a(direction), modifiers)) {
            return false;
        }
        this.playSound(world, x, y, z, ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    public static boolean summonMushroomRing(World world, @Nullable EntityLivingBase caster, BlockPos origin, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            double radius = ASSpells.fairy_ring.getProperty("effect_radius").doubleValue() * (double)modifiers.get(WizardryItems.blast_upgrade);
            ArrayList<BlockPos> ring = new ArrayList<BlockPos>((int)(7.0 * radius));
            int x = -((int)radius);
            while ((double)x <= radius) {
                int z = -((int)radius);
                while ((double)z <= radius) {
                    Integer y;
                    double distance = MathHelper.func_76129_c((float)(x * x + z * z));
                    if (!(distance > radius) && !(distance < radius - 1.5) && (y = BlockUtils.getNearestSurface((World)world, (BlockPos)origin.func_177982_a(x, 0, z), (EnumFacing)EnumFacing.UP, (int)((int)radius), (boolean)true, (BlockUtils.SurfaceCriteria)BlockUtils.SurfaceCriteria.BUILDABLE)) != null) {
                        ring.add(new BlockPos(origin.func_177958_n() + x, y.intValue(), origin.func_177952_p() + z));
                    }
                    ++z;
                }
                ++x;
            }
            if (ring.isEmpty()) {
                return false;
            }
            boolean singleType = false;
            BlockMagicMushroom mushroom = BlockMagicMushroom.getRandomMushroom(0.05f, 0.03f);
            if ((double)world.field_73012_v.nextFloat() < 0.05) {
                singleType = true;
            }
            int lifetime = (int)(ASSpells.fairy_ring.getProperty("duration").floatValue() * modifiers.get(WizardryItems.duration_upgrade) * 5.0f);
            for (BlockPos pos : ring) {
                if (!singleType) {
                    mushroom = BlockMagicMushroom.getRandomMushroom(0.05f, 0.03f);
                }
                BlockMagicMushroom.tryPlaceMushroom(world, pos, caster, mushroom, lifetime, modifiers);
            }
        }
        return true;
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

