/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.util.SpellcastUtils;
import electroblob.wizardry.entity.living.EntityEvilWizard;
import electroblob.wizardry.entity.living.EntityWizard;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class ForcedChannel
extends SpellRay
implements IClassSpell {
    public static final String MAX_TIER = "max_tier";

    public ForcedChannel() {
        super("ancientspellcraft", "forced_channel", SpellActions.POINT, false);
        this.soundValues(1.0f, 1.1f, 0.2f);
        this.addProperties(new String[]{MAX_TIER});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K && EntityUtils.isLiving((Entity)target)) {
            EntityLivingBase livingTarget = (EntityLivingBase)target;
            if (target instanceof EntityWizard || target instanceof EntityEvilWizard) {
                return this.tryChannelSpell(livingTarget.func_184614_ca(), caster, (EntityWizard)livingTarget);
            }
            if (livingTarget.func_184614_ca().func_77973_b() instanceof ISpellCastingItem) {
                return this.tryChannelSpell(livingTarget.func_184614_ca(), caster, null);
            }
            if (livingTarget.func_184592_cb().func_77973_b() instanceof ISpellCastingItem) {
                return this.tryChannelSpell(livingTarget.func_184592_cb(), caster, null);
            }
        }
        return true;
    }

    private boolean tryChannelSpell(ItemStack fromStack, EntityLivingBase caster, EntityWizard wizard) {
        if (!(caster instanceof EntityPlayer)) {
            return false;
        }
        Spell spell = ((ISpellCastingItem)fromStack.func_77973_b()).getCurrentSpell(fromStack);
        if (wizard != null) {
            Random wizzyRand = new Random(Math.abs(wizard.func_110124_au().hashCode()));
            spell = (Spell)wizard.getSpells().get(Math.min(1, wizzyRand.nextInt(wizard.getSpells().size())));
        }
        if (spell.getTier().ordinal() <= this.getProperty(MAX_TIER).intValue()) {
            if (!(spell instanceof IClassSpell)) {
                return SpellcastUtils.tryCastSpellAsPlayer((EntityPlayer)caster, spell, caster.func_184600_cs(), AncientSpellcraft.SAGE_ITEM, new SpellModifiers(), 80);
            }
        } else if (caster instanceof EntityPlayer) {
            ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".too_strong_spell", new Object[0]), true);
        }
        return false;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return false;
    }

    protected boolean onMiss(World world, EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(5709413).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DARK_MAGIC).pos(x, y, z).clr(2430473).spawn(world);
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).time(12 + world.field_73012_v.nextInt(8)).clr(740160).spawn(world);
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    @Override
    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book || item == WizardryItems.scroll;
    }
}

