/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.BlockSageLectern;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.SpellLecternInteract;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.RayTracer;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class Identify
extends SpellLecternInteract {
    public static final String SUCCESS_CHANCE = "success_chance";

    public Identify() {
        super("identify", SpellActions.POINT, true);
        this.addProperties(new String[]{SUCCESS_CHANCE});
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (!Identify.isLecternBlock(world, pos)) {
                return false;
            }
            int minTicks = 100;
            this.spawnLecternParticles(world, ticksInUse, pos, minTicks);
            if (ticksInUse < minTicks) {
                return true;
            }
            EntityPlayer player = (EntityPlayer)caster;
            if (Identify.isLecternBlock(world, pos)) {
                int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(Element.MAGIC);
                ItemStack stack = BlockSageLectern.getItemOnLectern(world, pos);
                if (stack.func_77973_b() instanceof ItemSpellBook && !(stack.func_77973_b() instanceof IClassSpell)) {
                    Spell spell = Spell.byMetadata((int)stack.func_77960_j());
                    WizardData data = WizardData.get((EntityPlayer)player);
                    colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(spell.getElement());
                    if (world.field_72995_K) {
                        for (int i = 0; i < 2; ++i) {
                            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos((double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat())).vel(0.0, 0.05 + (double)world.field_73012_v.nextFloat() * 0.1, 0.0).clr(colours[1]).fade(colours[2]).time(40).shaded(false).spawn(world);
                        }
                    }
                    if (!data.hasSpellBeenDiscovered(spell)) {
                        if (world.field_73012_v.nextFloat() <= this.getProperty(SUCCESS_CHANCE).floatValue() && data.discoverSpell(spell)) {
                            data.sync();
                            if (!world.field_72995_K) {
                                player.func_145747_a((ITextComponent)new TextComponentTranslation("spell.discover", new Object[]{spell.getNameForTranslationFormatted()}));
                            }
                            return true;
                        }
                    } else if (!world.field_72995_K) {
                        player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".known_spell", new Object[0]), true);
                    }
                    return false;
                }
                if (!world.field_72995_K) {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".no_valid_book", new Object[0]), true);
                }
                return false;
            }
            ASUtils.sendMessage((Entity)player, "generic.ancientspellcraft:spell_lectern_interact.no_lectern", true, new Object[0]);
        }
        return true;
    }

    @Override
    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        double range = this.getRange(world, origin, direction, caster, ticksInUse, modifiers);
        Vec3d endpoint = origin.func_178787_e(direction.func_186678_a(range));
        RayTraceResult rayTrace = RayTracer.rayTrace((World)world, (Vec3d)origin, (Vec3d)endpoint, (float)this.aimAssist, (boolean)this.hitLiquids, (boolean)this.ignoreUncollidables, (boolean)false, Entity.class, (Predicate)(this.ignoreLivingEntities ? EntityUtils::isLiving : RayTracer.ignoreEntityFilter((Entity)caster)));
        if (rayTrace != null && rayTrace.field_72313_a == RayTraceResult.Type.BLOCK && Identify.isLecternBlock(world, rayTrace.func_178782_a())) {
            return false;
        }
        if (caster instanceof EntityPlayer && !world.field_72995_K) {
            ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell." + this.getUnlocalisedName() + ".no_lectern", new Object[0]), true);
        }
        return true;
    }

    @Override
    protected void spawnParticle(World world, double x, double y, double z, double vx, double vy, double vz) {
    }
}

