/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.Settings;
import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.item.ISpellCastingItem;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Mine;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.BlockUtils;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class MineAS
extends Mine {
    private static final Method getSilkTouchDrop = ObfuscationReflectionHelper.findMethod(Block.class, (String)"func_180643_i", ItemStack.class, (Class[])new Class[]{IBlockState.class});

    public MineAS() {
        AncientSpellcraft.logger.info("Overriding default Electroblobs's Wizardry spell " + this.getRegistryName() + " to apply changes by Ancient Spellcraft.");
        int id = Settings.spellCompatSettings.mineSpellNetworkID;
        ObfuscationReflectionHelper.setPrivateValue(Spell.class, (Object)((Object)this), (Object)id, (String)"id");
        int nextSpellId = (Integer)ObfuscationReflectionHelper.getPrivateValue(Spell.class, (Object)((Object)this), (String)"nextSpellId");
        ObfuscationReflectionHelper.setPrivateValue(Spell.class, (Object)((Object)this), (Object)(--nextSpellId), (String)"nextSpellId");
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (caster.func_184614_ca().func_77973_b() instanceof ISpellCastingItem) {
                caster.func_184609_a(EnumHand.MAIN_HAND);
            } else if (caster.func_184592_cb().func_77973_b() instanceof ISpellCastingItem) {
                caster.func_184609_a(EnumHand.OFF_HAND);
            }
        }
        if (!world.field_72995_K) {
            if (BlockUtils.isBlockUnbreakable((World)world, (BlockPos)pos)) {
                return false;
            }
            if (!EntityUtils.canDamageBlocks((Entity)caster, (World)world)) {
                return false;
            }
            IBlockState state = world.func_180495_p(pos);
            int harvestLevel = (int)((modifiers.get("potency") - 1.0f) / Constants.POTENCY_INCREASE_PER_TIER + 0.5f);
            if (harvestLevel > 0) {
                --harvestLevel;
            }
            if (state.func_177230_c().getHarvestLevel(state) <= harvestLevel || harvestLevel >= 3) {
                boolean flag = false;
                int blastUpgradeCount = (int)((modifiers.get(WizardryItems.blast_upgrade) - 1.0f) / Constants.BLAST_RADIUS_INCREASE_PER_LEVEL + 0.5f);
                float radius = 0.5f + 0.73f * (float)blastUpgradeCount;
                List sphere = BlockUtils.getBlockSphere((BlockPos)pos, (double)radius);
                for (BlockPos pos1 : sphere) {
                    IBlockState state1;
                    if (BlockUtils.isBlockUnbreakable((World)world, (BlockPos)pos1) || (state1 = world.func_180495_p(pos1)).func_177230_c().getHarvestLevel(state1) > harvestLevel && harvestLevel < 3) continue;
                    if (caster instanceof EntityPlayerMP) {
                        boolean silkTouch = state1.func_177230_c().canSilkHarvest(world, pos1, state1, (EntityPlayer)caster) && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)WizardryItems.charm_silk_touch);
                        boolean hasFortune = ItemNewArtefact.isNewArtefactActive((EntityPlayer)caster, ASItems.head_fortune);
                        int xp = BlockUtils.checkBlockBreakXP((Entity)caster, (World)world, (BlockPos)pos);
                        if (xp < 0) continue;
                        if (silkTouch) {
                            ItemStack stack;
                            flag = world.func_175655_b(pos1, false);
                            if (!flag || (stack = MineAS.getSilkTouchDrop(state1)) == null) continue;
                            Block.func_180635_a((World)world, (BlockPos)pos1, (ItemStack)stack);
                            continue;
                        }
                        if (hasFortune) {
                            state1.func_177230_c().func_176226_b(world, pos1, state1, Math.min(harvestLevel, 3));
                            flag = world.func_175655_b(pos1, false);
                        } else {
                            flag = world.func_175655_b(pos1, true);
                        }
                        if (!flag) continue;
                        state1.func_177230_c().func_180637_b(world, pos1, xp);
                        continue;
                    }
                    if (!BlockUtils.canBreakBlock((Entity)caster, (World)world, (BlockPos)pos)) continue;
                    flag = world.func_175655_b(pos1, true) || flag;
                }
                return flag;
            }
        } else {
            return true;
        }
        return false;
    }

    private static ItemStack getSilkTouchDrop(IBlockState state) {
        try {
            return (ItemStack)getSilkTouchDrop.invoke((Object)state.func_177230_c(), state);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Wizardry.logger.error("Error while reflectively retrieving silk touch drop", (Throwable)e);
            return null;
        }
    }
}

