/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.BlockSageLectern;
import com.windanesz.ancientspellcraft.item.ItemEmptyMysticSpellBook;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.spell.Experiment;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.SpellLecternInteract;
import com.windanesz.ancientspellcraft.tileentity.TileSageLectern;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class PerfectTheory
extends SpellLecternInteract
implements IClassSpell {
    private static final IStoredVariable<NBTTagCompound> PERFECT_THEORY = IStoredVariable.StoredVariable.ofNBT((String)"perfectTheoryData", (Persistence)Persistence.ALWAYS).setSynced();

    public PerfectTheory() {
        super("perfect_theory", SpellActions.SUMMON, true);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{PERFECT_THEORY});
    }

    private static NBTTagCompound getData(EntityPlayer player) {
        NBTTagCompound nbt;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null && (nbt = (NBTTagCompound)data.getVariable(PERFECT_THEORY)) != null) {
            return nbt;
        }
        return new NBTTagCompound();
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (!PerfectTheory.isLecternBlock(world, pos)) {
                return false;
            }
            int minTicks = 100;
            this.spawnLecternParticles(world, ticksInUse, pos, minTicks);
            if (ticksInUse < minTicks) {
                return true;
            }
            EntityPlayer player = (EntityPlayer)caster;
            if (PerfectTheory.isLecternBlock(world, pos)) {
                ItemStack stack = BlockSageLectern.getItemOnLectern(world, pos);
                if (stack.func_77973_b() instanceof ItemEmptyMysticSpellBook) {
                    WizardData data = WizardData.get((EntityPlayer)player);
                    int theoryPoints = Experiment.getTheoryPoints(player);
                    if (theoryPoints < 1) {
                        ASUtils.sendMessage((Entity)player, "generic.ancientspellcraft:spell_lectern_interact.no_theory_points", true, new Object[0]);
                        return false;
                    }
                    if (!world.field_72995_K) {
                        Spell spell = ASSpells.perfect_theory_spell;
                        TileEntity tile = world.func_175625_s(pos);
                        if (tile instanceof TileSageLectern) {
                            ItemStack book = new ItemStack(ASItems.mystic_spell_book, 1, spell.metadata());
                            NBTTagCompound theory = Experiment.getLastExperiment(player);
                            book.func_77982_d(theory);
                            ((TileSageLectern)tile).func_70299_a(0, book);
                        }
                        Experiment.consumeTheoryPoint(player, 1);
                        return true;
                    }
                    return false;
                }
                ASUtils.sendMessage((Entity)player, "spell." + this.getUnlocalisedName() + ".no_valid_book", true, new Object[0]);
                return false;
            }
            ASUtils.sendMessage((Entity)player, "generic.ancientspellcraft:spell_lectern_interact.no_lectern", true, new Object[0]);
        }
        return true;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    @Override
    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book || item == WizardryItems.scroll;
    }
}

