/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.AncientSpellcraft;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.util.ASUtils;
import com.windanesz.ancientspellcraft.util.WizardArmourUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.data.IStoredVariable;
import electroblob.wizardry.data.Persistence;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.tileentity.TileEntityBookshelf;
import electroblob.wizardry.util.NBTExtras;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.worldgen.MossifierTemplateProcessor;
import electroblob.wizardry.worldgen.MultiTemplateProcessor;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockStainedHardenedClay;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.ITemplateProcessor;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.FMLLog;

public class PocketLibrary
extends Spell
implements IClassSpell {
    public static final String FIRST_CAST = "first_cast";
    public static final String SIZE = "size";
    public static final String LIBRARY_BLOCKS = "libraryBlocks";
    public static final String CENTER_POS = "centerPos";
    public static final String SAVED_DATA = "savedData";
    private static final IStoredVariable<NBTTagCompound> POCKET_LIBRARY_DATA_NBT = IStoredVariable.StoredVariable.ofNBT((String)"pocketLibraryData", (Persistence)Persistence.ALWAYS).setSynced();
    private static final ResourceLocation POCKET_LIBRARY = new ResourceLocation("ancientspellcraft", "pocket_library");
    public static final String LIBRARY_IS_SUMMONED = "library_is_summoned";

    public PocketLibrary() {
        super("ancientspellcraft", "pocket_library", SpellActions.POINT_DOWN, false);
        WizardData.registerStoredVariables((IStoredVariable[])new IStoredVariable[]{POCKET_LIBRARY_DATA_NBT});
        this.addProperties(new String[]{SIZE});
    }

    public static boolean isFirstCast(NBTTagCompound nbt) {
        return !nbt.func_74764_b(FIRST_CAST) || nbt.func_74764_b(FIRST_CAST) && nbt.func_74767_n(FIRST_CAST);
    }

    public static NBTTagCompound getData(EntityPlayer player) {
        NBTTagCompound experimentData;
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null && (experimentData = (NBTTagCompound)data.getVariable(POCKET_LIBRARY_DATA_NBT)) != null) {
            return experimentData;
        }
        return new NBTTagCompound();
    }

    public static void saveData(EntityPlayer player, NBTTagCompound nbt) {
        WizardData data = WizardData.get((EntityPlayer)player);
        if (data != null) {
            data.setVariable(POCKET_LIBRARY_DATA_NBT, (Object)nbt);
            data.sync();
        }
    }

    private static float getBiomeMossiness(Biome biome) {
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DENSE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.JUNGLE)) {
            return 0.7f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WET)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.SWAMP)) {
            return 0.5f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.FOREST)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.LUSH)) {
            return 0.3f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DRY)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.DEAD)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.WASTELAND)) {
            return 0.0f;
        }
        if (BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            return 0.0f;
        }
        return 0.1f;
    }

    public static boolean isLibrarySummoned(EntityPlayer player) {
        NBTTagCompound nbt = PocketLibrary.getData(player);
        return nbt.func_74764_b(LIBRARY_IS_SUMMONED) && nbt.func_74767_n(LIBRARY_IS_SUMMONED);
    }

    public static void changeLibrarySummonedStatus(EntityPlayer player, NBTTagCompound nbt, boolean isSummoned) {
        nbt.func_74757_a(LIBRARY_IS_SUMMONED, isSummoned);
        PocketLibrary.saveData(player, nbt);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (PocketLibrary.isFirstCast(PocketLibrary.getData(caster))) {
            return this.spawnStructureInitially(caster, world);
        }
        if (PocketLibrary.isLibrarySummoned(caster)) {
            BlockPos libraryPosition = NBTUtil.func_186861_c((NBTTagCompound)PocketLibrary.getData(caster).func_74775_l(CENTER_POS));
            double distance = Math.sqrt(caster.func_180425_c().func_177951_i((Vec3i)libraryPosition));
            if (distance > 3.0) {
                ASUtils.sendMessage((Entity)caster, "spell.ancientspellcraft:pocket_library.too_far_away", true, new Object[0]);
                return false;
            }
            Wizardry.proxy.playBlinkEffect(caster);
            return this.packStructure(caster, world);
        }
        Wizardry.proxy.playBlinkEffect(caster);
        boolean f = this.spawnStructure(caster, world);
        if (!world.field_72995_K) {
            caster.func_70634_a((double)caster.func_180425_c().func_177958_n() + 0.5, caster.field_70163_u + 1.0, (double)caster.func_180425_c().func_177952_p() + 0.5);
        }
        return f;
    }

    @Override
    public ItemWizardArmour.ArmourClass getArmourClass() {
        return ItemWizardArmour.ArmourClass.SAGE;
    }

    @Override
    public boolean applicableForItem(Item item) {
        return item == ASItems.mystic_spell_book || item == WizardryItems.scroll;
    }

    private boolean spawnStructureInitially(EntityPlayer caster, World world) {
        if (!world.field_72995_K) {
            NBTTagCompound data = PocketLibrary.getData(caster);
            Template template = world.func_72860_G().func_186340_h().func_186237_a(world.func_73046_m(), POCKET_LIBRARY);
            BlockPos size = template.func_186259_a();
            if (size.func_177958_n() == 0 || size.func_177956_o() == 0 || size.func_177952_p() == 0) {
                AncientSpellcraft.logger.warn("Structure template file {} is missing or empty!", (Object)POCKET_LIBRARY);
            }
            int triesLeft = 10;
            EnumDyeColor color = EnumDyeColor.values()[world.field_73012_v.nextInt(EnumDyeColor.values().length)];
            switch (WizardArmourUtils.getFullSetElementForClass((EntityLivingBase)caster, ItemWizardArmour.ArmourClass.SAGE)) {
                case MAGIC: {
                    color = EnumDyeColor.GRAY;
                    break;
                }
                case FIRE: {
                    color = EnumDyeColor.ORANGE;
                    break;
                }
                case ICE: {
                    color = EnumDyeColor.LIGHT_BLUE;
                    break;
                }
                case LIGHTNING: {
                    color = EnumDyeColor.BLUE;
                    break;
                }
                case NECROMANCY: {
                    color = EnumDyeColor.PURPLE;
                    break;
                }
                case EARTH: {
                    color = EnumDyeColor.BROWN;
                    break;
                }
                case SORCERY: {
                    color = EnumDyeColor.CYAN;
                    break;
                }
                case HEALING: {
                    color = EnumDyeColor.YELLOW;
                }
            }
            EnumDyeColor colour = color;
            Biome biome = world.func_180494_b(caster.func_180425_c());
            float mossiness = PocketLibrary.getBiomeMossiness(biome);
            HashSet blocksPlaced = new HashSet();
            Rotation rotation = Rotation.NONE;
            PlacementSettings settings = new PlacementSettings().func_186220_a(rotation);
            MultiTemplateProcessor processor = new MultiTemplateProcessor(true, new ITemplateProcessor[]{(w, p, i) -> i.field_186243_b.func_177230_c() instanceof BlockStainedHardenedClay ? new Template.BlockInfo(i.field_186242_a, i.field_186243_b.func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)colour), i.field_186244_c) : i, new MossifierTemplateProcessor(mossiness, 0.04f, caster.func_180425_c().func_177956_o() + 1), (w, p, i) -> {
                if (i.field_186243_b.func_177230_c() != Blocks.field_150350_a) {
                    blocksPlaced.add(p);
                }
                return i;
            }});
            BlockPos pos = caster.func_180425_c().func_177967_a(EnumFacing.WEST, 4).func_177967_a(EnumFacing.NORTH, 4);
            for (BlockPos currTestPos : BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177967_a(EnumFacing.UP, 15).func_177967_a(EnumFacing.SOUTH, 7).func_177967_a(EnumFacing.EAST, 7))) {
                if (world.func_175678_i(currTestPos)) continue;
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:ice_tower.no_room", new Object[0]), true);
                return false;
            }
            template.func_189960_a(world, caster.func_180425_c().func_177967_a(EnumFacing.WEST, 4).func_177967_a(EnumFacing.NORTH, 4), (ITemplateProcessor)processor, settings, 18);
            NBTTagCompound blocks = new NBTTagCompound();
            if (blocksPlaced != null && blocksPlaced.size() > 0) {
                NBTExtras.storeTagSafely((NBTTagCompound)blocks, (String)LIBRARY_BLOCKS, (NBTBase)NBTExtras.listToNBT(blocksPlaced, NBTUtil::func_186859_a));
                data.func_74782_a(LIBRARY_BLOCKS, (NBTBase)blocks);
                NBTTagCompound centerPos = NBTUtil.func_186859_a((BlockPos)caster.func_180425_c());
                data.func_74782_a(CENTER_POS, (NBTBase)centerPos);
                data.func_74757_a(FIRST_CAST, false);
                PocketLibrary.changeLibrarySummonedStatus(caster, data, true);
                PocketLibrary.saveData(caster, data);
            }
            caster.func_70634_a((double)caster.func_180425_c().func_177958_n() + 0.5, caster.field_70163_u + 1.0, (double)caster.func_180425_c().func_177952_p() + 0.5);
        }
        if (world.field_72995_K) {
            for (int i2 = 0; i2 < 10; ++i2) {
                double dx = caster.field_70165_t;
                double dy = caster.field_70163_u + (double)(2.0f * world.field_73012_v.nextFloat());
                double dz = caster.field_70161_v;
                world.func_175688_a(EnumParticleTypes.PORTAL, dx, dy, dz, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, world.field_73012_v.nextDouble() - 0.5, new int[0]);
            }
            Wizardry.proxy.playBlinkEffect(caster);
        }
        return true;
    }

    private boolean packStructure(EntityPlayer caster, World world) {
        if (!world.field_72995_K) {
            NBTTagCompound data = PocketLibrary.getData(caster);
            NBTTagCompound nbtData = PocketLibrary.getData(caster);
            if (nbtData.func_74764_b(LIBRARY_BLOCKS)) {
                BlockPos centerPos = NBTUtil.func_186861_c((NBTTagCompound)nbtData.func_74775_l(CENTER_POS));
                NBTTagCompound compound = nbtData.func_74775_l(LIBRARY_BLOCKS);
                NBTTagList tagList = compound.func_150295_c(LIBRARY_BLOCKS, 10);
                if (!tagList.func_82582_d()) {
                    HashSet blocksPlaced = new HashSet(NBTExtras.NBTToList((NBTTagList)tagList, NBTUtil::func_186861_c));
                    NBTTagCompound compound1 = new NBTTagCompound();
                    NBTTagList nbttaglist2 = new NBTTagList();
                    ArrayList tileEntityList = new ArrayList();
                    ArrayList blockStateList = new ArrayList();
                    NBTTagList blockDataList = new NBTTagList();
                    blocksPlaced.forEach(b -> {
                        TileEntity tile = world.func_175625_s(b);
                        if (this.isAllowedTile(tile)) {
                            tileEntityList.add(tile);
                        }
                    });
                    blocksPlaced.forEach(b -> {
                        if (world.func_175625_s(b) == null || this.isAllowedTile(world.func_175625_s(b))) {
                            NBTTagCompound blockData = new NBTTagCompound();
                            NBTTagCompound state = new NBTTagCompound();
                            NBTUtil.func_190009_a((NBTTagCompound)state, (IBlockState)world.func_180495_p(b));
                            blockData.func_74782_a("state", (NBTBase)state);
                            blockData.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)b.func_177973_b((Vec3i)centerPos)));
                            blockDataList.func_74742_a((NBTBase)blockData);
                        } else {
                            NBTTagCompound blockData = new NBTTagCompound();
                            NBTTagCompound state = new NBTTagCompound();
                            NBTUtil.func_190009_a((NBTTagCompound)state, (IBlockState)Blocks.field_150350_a.func_176223_P());
                            blockData.func_74782_a("state", (NBTBase)state);
                            blockData.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)b.func_177973_b((Vec3i)centerPos)));
                            blockDataList.func_74742_a((NBTBase)blockData);
                        }
                    });
                    compound1.func_74782_a("Blocks", (NBTBase)blockDataList);
                    for (TileEntity tileentity : tileEntityList) {
                        if (!this.isAllowedTile(tileentity)) continue;
                        try {
                            NBTTagCompound nbttagcompound3 = tileentity.func_189515_b(new NBTTagCompound());
                            nbttagcompound3.func_74768_a("x", tileentity.func_174877_v().func_177973_b((Vec3i)centerPos).func_177958_n());
                            nbttagcompound3.func_74768_a("y", tileentity.func_174877_v().func_177973_b((Vec3i)centerPos).func_177956_o());
                            nbttagcompound3.func_74768_a("z", tileentity.func_174877_v().func_177973_b((Vec3i)centerPos).func_177952_p());
                            nbttaglist2.func_74742_a((NBTBase)nbttagcompound3);
                        }
                        catch (Exception e) {
                            FMLLog.log.error("A TileEntity type {} has throw an exception trying to write state. It will not persist. Report this to the mod author", (Object)tileentity.getClass().getName(), (Object)e);
                        }
                    }
                    compound1.func_74782_a("TileEntities", (NBTBase)nbttaglist2);
                    nbtData.func_74782_a(SAVED_DATA, (NBTBase)compound1);
                    PocketLibrary.changeLibrarySummonedStatus(caster, data, false);
                    PocketLibrary.saveData(caster, data);
                    if (!blocksPlaced.isEmpty()) {
                        blocksPlaced.forEach(b -> {
                            if (this.isAllowedTile(world.func_175625_s(b))) {
                                world.func_175713_t(b);
                            }
                        });
                        blocksPlaced.forEach(b -> {
                            if (world.func_180495_p(b).func_177230_c() instanceof BlockTorch) {
                                world.func_175698_g(b);
                            }
                        });
                        blocksPlaced.forEach(b -> {
                            if (world.func_180495_p(b).func_177230_c() instanceof BlockDoor && world.func_180495_p(b).func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
                                world.func_175698_g(b);
                            }
                        });
                        blocksPlaced.forEach(b -> {
                            if (world.func_175625_s(b) == null || this.isAllowedTile(world.func_175625_s(b))) {
                                world.func_175698_g(b);
                            }
                        });
                    }
                }
            }
        }
        return true;
    }

    private boolean spawnStructure(EntityPlayer caster, World world) {
        if (!world.field_72995_K) {
            NBTTagCompound data = PocketLibrary.getData(caster);
            BlockPos pos = caster.func_180425_c().func_177967_a(EnumFacing.WEST, 4).func_177967_a(EnumFacing.NORTH, 4);
            for (BlockPos currTestPos : BlockPos.func_177980_a((BlockPos)pos, (BlockPos)pos.func_177967_a(EnumFacing.UP, 15).func_177967_a(EnumFacing.SOUTH, 7).func_177967_a(EnumFacing.EAST, 7))) {
                if (world.func_175678_i(currTestPos)) continue;
                caster.func_146105_b((ITextComponent)new TextComponentTranslation("spell.ancientspellcraft:pocket_library.no_room", new Object[0]), true);
                return false;
            }
            NBTTagCompound nbtData = PocketLibrary.getData(caster);
            if (data.func_74764_b(SAVED_DATA)) {
                BlockPos currPos;
                BlockPos relativePos;
                IBlockState oldState;
                HashSet<BlockPos> blocksPlaced = new HashSet<BlockPos>();
                BlockPos centerPos = caster.func_180425_c();
                NBTTagCompound savedData = nbtData.func_74775_l(SAVED_DATA);
                NBTTagList blockTagList = savedData.func_150295_c("Blocks", 10);
                ArrayList blockList = new ArrayList();
                blockTagList.forEach(entry -> {
                    if (entry instanceof NBTTagCompound) {
                        blockList.add((NBTTagCompound)entry);
                    }
                });
                ArrayList remainingBlockList = new ArrayList(blockList);
                for (Object compound : blockList) {
                    oldState = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("state"));
                    if (oldState.func_177230_c() instanceof BlockTorch || oldState.func_177230_c() instanceof BlockDoor) continue;
                    relativePos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos"));
                    currPos = relativePos.func_177971_a((Vec3i)centerPos);
                    world.func_175656_a(currPos, oldState);
                    blocksPlaced.add(currPos);
                    remainingBlockList.remove(compound);
                }
                for (Object compound : remainingBlockList) {
                    oldState = NBTUtil.func_190008_d((NBTTagCompound)compound.func_74775_l("state"));
                    relativePos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos"));
                    currPos = relativePos.func_177971_a((Vec3i)centerPos);
                    world.func_175656_a(currPos, oldState);
                    blocksPlaced.add(currPos);
                }
                NBTTagList tileTagList = savedData.func_150295_c("TileEntities", 10);
                for (NBTBase nbtBase : tileTagList) {
                    if (!(nbtBase instanceof NBTTagCompound)) continue;
                    NBTTagCompound tileNBT = (NBTTagCompound)nbtBase;
                    BlockPos relativePos2 = new BlockPos(tileNBT.func_74762_e("x"), tileNBT.func_74762_e("y"), tileNBT.func_74762_e("z"));
                    BlockPos currPos2 = relativePos2.func_177971_a((Vec3i)centerPos);
                    world.func_175690_a(currPos2, TileEntity.func_190200_a((World)world, (NBTTagCompound)tileNBT));
                }
                NBTTagCompound blocks = new NBTTagCompound();
                if (blocksPlaced != null && blocksPlaced.size() > 0) {
                    NBTExtras.storeTagSafely((NBTTagCompound)blocks, (String)LIBRARY_BLOCKS, (NBTBase)NBTExtras.listToNBT(blocksPlaced, NBTUtil::func_186859_a));
                    nbtData.func_74782_a(LIBRARY_BLOCKS, (NBTBase)blocks);
                    NBTTagCompound centerPosNBT = NBTUtil.func_186859_a((BlockPos)caster.func_180425_c());
                    nbtData.func_74782_a(CENTER_POS, (NBTBase)centerPosNBT);
                    nbtData.func_74757_a(FIRST_CAST, false);
                    PocketLibrary.changeLibrarySummonedStatus(caster, nbtData, true);
                    PocketLibrary.saveData(caster, nbtData);
                }
            }
        }
        return true;
    }

    public boolean isAllowedTile(TileEntity tile) {
        return tile instanceof TileEntityBookshelf;
    }

    public int getStructureRadius() {
        return 13;
    }
}

