/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.item.ItemBattlemageSword;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.Runeword;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.InventoryUtils;
import electroblob.wizardry.util.SpellModifiers;
import java.util.HashMap;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RunewordImbue
extends Runeword {
    public static final String POTION_TAG = "Potion";

    public RunewordImbue() {
        super("runeword_imbue", SpellActions.POINT_UP, false);
        this.addProperties(new String[]{"effect_duration", "charges"});
    }

    @Override
    public boolean onAboutToHitEntity(World world, EntityLivingBase caster, EntityLivingBase target, EnumHand hand, ItemStack sword, SpellModifiers modifiers, boolean charged) {
        NBTTagCompound imbuement;
        HashMap<Runeword, NBTTagCompound> data = ItemBattlemageSword.getTemporaryRunewordData(sword);
        if (data.containsKey(this) && (imbuement = data.get(this)).func_74764_b(POTION_TAG)) {
            PotionEffect effect = new PotionEffect((Potion)ForgeRegistries.POTIONS.getValue(new ResourceLocation(imbuement.func_74779_i(POTION_TAG))), (int)((float)this.getProperty("effect_duration").intValue() * modifiers.get(WizardryItems.duration_upgrade)));
            target.func_70690_d(effect);
            this.spendCharge(sword);
        }
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!world.field_72995_K) {
            for (ItemStack stack : InventoryUtils.getHotbar((EntityPlayer)caster)) {
                if (!(stack.func_77973_b() instanceof ItemPotion)) continue;
                for (PotionEffect potioneffect : PotionUtils.func_185189_a((ItemStack)stack)) {
                    if (potioneffect.func_188419_a().func_76403_b()) continue;
                    int charges = this.getChargeCount((EntityLivingBase)caster);
                    if (ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.charm_glyph_imbuement)) {
                        charges *= 6;
                    }
                    ItemBattlemageSword.setActiveRuneword(caster.func_184586_b(hand), this, charges);
                    NBTTagCompound imbuement = new NBTTagCompound();
                    imbuement.func_74778_a(POTION_TAG, potioneffect.func_188419_a().getRegistryName().toString());
                    ItemBattlemageSword.setTemporaryRuneWordData(caster.func_184586_b(hand), this, imbuement);
                    stack.func_190918_g(1);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return super.cast(world, caster, hand, ticksInUse, target, modifiers);
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return false;
    }
}

