/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.spell.Runeword;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RunewordSelfBuff
extends Runeword {
    protected final Supplier<Potion>[] effects;
    protected Set<Potion> potionSet;
    protected final float r;
    protected final float g;
    protected final float b;
    protected float particleCount = 10.0f;

    public RunewordSelfBuff(String name, float r, float g, float b, Supplier<Potion> ... effects) {
        super(name, SpellActions.POINT_UP, false);
        this.effects = effects;
        this.r = r;
        this.g = g;
        this.b = b;
        this.npcSelector((e, o) -> true);
    }

    public void init() {
        this.potionSet = Arrays.stream(this.effects).map(Supplier::get).collect(Collectors.toSet());
        for (Potion potion : this.potionSet) {
            this.addProperties(new String[]{RunewordSelfBuff.getStrengthKey(potion)});
            if (potion.func_76403_b()) continue;
            this.addProperties(new String[]{RunewordSelfBuff.getDurationKey(potion)});
        }
    }

    public Set<Potion> getPotionSet() {
        return Collections.unmodifiableSet(this.potionSet);
    }

    protected static String getDurationKey(Potion potion) {
        return potion.getRegistryName().func_110623_a() + "_duration";
    }

    protected static String getStrengthKey(Potion potion) {
        return potion.getRegistryName().func_110623_a() + "_strength";
    }

    public RunewordSelfBuff particleCount(int particleCount) {
        this.particleCount = particleCount;
        return this;
    }

    public boolean canBeCastBy(TileEntityDispenser dispenser) {
        return true;
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!this.applyEffects((EntityLivingBase)caster, modifiers) && !world.field_72995_K) {
            return false;
        }
        if (world.field_72995_K) {
            this.spawnParticles(world, (EntityLivingBase)caster, modifiers);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        if (caster.func_193076_bZ().keySet().containsAll(this.potionSet)) {
            return false;
        }
        if (!this.applyEffects((EntityLivingBase)caster, modifiers) && !world.field_72995_K) {
            return false;
        }
        if (world.field_72995_K) {
            this.spawnParticles(world, (EntityLivingBase)caster, modifiers);
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    @Override
    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        AxisAlignedBB boundingBox = new AxisAlignedBB(new BlockPos(x, y, z));
        List entities = world.func_72872_a(EntityLivingBase.class, boundingBox);
        float distance = -1.0f;
        EntityLivingBase nearestEntity = null;
        for (EntityLivingBase entity : entities) {
            float newDistance = (float)entity.func_70011_f(x, y, z);
            if (distance != -1.0f && !(newDistance < distance)) continue;
            distance = newDistance;
            nearestEntity = entity;
        }
        if (nearestEntity == null) {
            return false;
        }
        if (!this.applyEffects(nearestEntity, modifiers) && !world.field_72995_K) {
            return false;
        }
        if (world.field_72995_K) {
            this.spawnParticles(world, nearestEntity, modifiers);
        }
        this.playSound(world, x - (double)direction.func_82601_c(), y - (double)direction.func_96559_d(), z - (double)direction.func_82599_e(), ticksInUse, duration, modifiers, new String[0]);
        return true;
    }

    protected boolean applyEffects(EntityLivingBase caster, SpellModifiers modifiers) {
        int bonusAmplifier = this.getBonusAmplifier(modifiers.get("potency"));
        for (Potion potion : this.potionSet) {
            caster.func_70690_d(new PotionEffect(potion, potion.func_76403_b() ? 1 : (int)(this.getProperty(RunewordSelfBuff.getDurationKey(potion)).floatValue() * modifiers.get(WizardryItems.duration_upgrade)), (int)this.getProperty(RunewordSelfBuff.getStrengthKey(potion)).floatValue() + bonusAmplifier, false, true));
        }
        return true;
    }

    protected int getBonusAmplifier(float potencyModifier) {
        return RunewordSelfBuff.getStandardBonusAmplifier(potencyModifier);
    }

    public static int getStandardBonusAmplifier(float potencyModifier) {
        return (int)((double)(potencyModifier - 1.0f) / 0.4);
    }

    protected void spawnParticles(World world, EntityLivingBase caster, SpellModifiers modifiers) {
        int i = 0;
        while ((float)i < this.particleCount) {
            double x = caster.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            double y = caster.field_70163_u + (double)caster.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
            double z = caster.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(this.r, this.g, this.b).spawn(world);
            ++i;
        }
        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.BUFF).entity((Entity)caster).clr(this.r, this.g, this.b).spawn(world);
    }
}

