/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.block.BlockSageLectern;
import com.windanesz.ancientspellcraft.item.ItemEmptyMysticSpellBook;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASSpells;
import com.windanesz.ancientspellcraft.spell.Experiment;
import com.windanesz.ancientspellcraft.spell.IClassSpell;
import com.windanesz.ancientspellcraft.spell.SpellLecternInteract;
import com.windanesz.ancientspellcraft.tileentity.TileSageLectern;
import com.windanesz.ancientspellcraft.util.ASUtils;
import electroblob.wizardry.Wizardry;
import electroblob.wizardry.block.BlockReceptacle;
import electroblob.wizardry.constants.Element;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.item.ItemWizardArmour;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import electroblob.wizardry.util.SpellProperties;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Scribe
extends SpellLecternInteract {
    public Scribe() {
        super("scribe", SpellActions.POINT, true);
    }

    public static List<Spell> getAllSageSpells() {
        return Spell.getSpells(s -> s instanceof IClassSpell && ((IClassSpell)s).getArmourClass() == ItemWizardArmour.ArmourClass.SAGE);
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (caster instanceof EntityPlayer) {
            if (!Scribe.isLecternBlock(world, pos)) {
                return false;
            }
            int minTicks = 100;
            this.spawnLecternParticles(world, ticksInUse, pos, minTicks);
            if (ticksInUse < minTicks) {
                return true;
            }
            EntityPlayer player = (EntityPlayer)caster;
            if (Scribe.isLecternBlock(world, pos)) {
                ItemStack stack;
                int[] colours = (int[])BlockReceptacle.PARTICLE_COLOURS.get(Element.MAGIC);
                if (world.field_72995_K) {
                    int i = 0;
                    while ((double)i < (double)ticksInUse * 0.1 * 2.0) {
                        ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.DUST).pos((double)((float)pos.func_177958_n() + world.field_73012_v.nextFloat()), (double)(pos.func_177956_o() + 1), (double)((float)pos.func_177952_p() + world.field_73012_v.nextFloat())).vel(0.0, 0.05 + (double)world.field_73012_v.nextFloat() * 0.1, 0.0).clr(colours[1]).fade(colours[2]).time(40).shaded(false).spawn(world);
                        ++i;
                    }
                }
                if ((stack = BlockSageLectern.getItemOnLectern(world, pos)).func_77973_b() instanceof ItemEmptyMysticSpellBook) {
                    List spells;
                    WizardData data = WizardData.get((EntityPlayer)player);
                    int theoryPoints = Experiment.getTheoryPoints(player);
                    if (theoryPoints < 1) {
                        ASUtils.sendMessage((Entity)player, "generic.ancientspellcraft:spell_lectern_interact.no_theory_points", true, new Object[0]);
                        return false;
                    }
                    if (ItemArtefact.isArtefactActive((EntityPlayer)player, (Item)ASItems.charm_elemental_alkahest) && world.field_73012_v.nextFloat() < 0.2f) {
                        spells = Spell.getSpells(s -> !(s instanceof IClassSpell) && s.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.BOOK}) && s.isEnabled(new SpellProperties.Context[]{SpellProperties.Context.LOOTING}));
                        spells.removeIf(arg_0 -> ((WizardData)data).hasSpellBeenDiscovered(arg_0));
                    } else {
                        spells = Scribe.getAllSageSpells();
                        spells.removeIf(arg_0 -> ((WizardData)data).hasSpellBeenDiscovered(arg_0));
                        spells.removeIf(s -> s == ASSpells.perfect_theory_spell);
                    }
                    if (!world.field_72995_K && !spells.isEmpty()) {
                        Spell randomSpell = (Spell)spells.get(world.field_73012_v.nextInt(spells.size()));
                        TileEntity tile = world.func_175625_s(pos);
                        if (tile instanceof TileSageLectern) {
                            ((TileSageLectern)tile).func_70299_a(0, ASUtils.getSpellBookForSpell(randomSpell));
                        }
                        Experiment.consumeTheoryPoint(player, 1);
                        if (player.func_184587_cr()) {
                            player.func_184811_cZ().func_185145_a(player.func_184586_b(player.func_184600_cs()).func_77973_b(), 10);
                            player.func_184597_cx();
                        }
                        return true;
                    }
                    return false;
                }
                ASUtils.sendMessage((Entity)player, "generic.ancientspellcraft:spell_lectern_interact.needs_empty_book", true, new Object[0]);
                return false;
            }
            ASUtils.sendMessage((Entity)player, "generic.ancientspellcraft:spell_lectern_interact.no_lectern", true, new Object[0]);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public String getDescription() {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            return Wizardry.proxy.translate(this.getDescriptionTranslationKey(), new Object[]{Experiment.getTheoryPoints((EntityPlayer)player)});
        }
        return super.getDescription();
    }
}

