/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.entity.living.EntityAnimatedItem;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.spell.Animate;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SpectralArmy
extends Animate {
    public SpectralArmy() {
        super("ancientspellcraft", "spectral_army");
    }

    @Override
    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (!this.spawnMinions(world, (EntityLivingBase)caster, modifiers, !ItemArtefact.isArtefactActive((EntityPlayer)caster, (Item)ASItems.charm_spectral_army))) {
            return false;
        }
        this.playSound(world, (EntityLivingBase)caster, ticksInUse, -1, modifiers, new String[0]);
        return true;
    }

    protected void addMinionExtras(EntityAnimatedItem minion, BlockPos pos, @Nullable EntityLivingBase caster, SpellModifiers modifiers, int alreadySpawned) {
        IAttributeInstance attack_speed;
        IAttributeInstance speed;
        IAttributeInstance attack_damage;
        super.addMinionExtras((EntityLiving)minion, pos, caster, modifiers, alreadySpawned);
        minion.func_184201_a(EntityEquipmentSlot.HEAD, SpectralArmy.conjureItem(modifiers, WizardryItems.spectral_helmet));
        minion.func_184201_a(EntityEquipmentSlot.CHEST, SpectralArmy.conjureItem(modifiers, WizardryItems.spectral_chestplate));
        minion.func_184201_a(EntityEquipmentSlot.LEGS, SpectralArmy.conjureItem(modifiers, WizardryItems.spectral_leggings));
        minion.func_184201_a(EntityEquipmentSlot.FEET, SpectralArmy.conjureItem(modifiers, WizardryItems.spectral_boots));
        minion.func_184201_a(EntityEquipmentSlot.MAINHAND, SpectralArmy.conjureItem(modifiers, Items.field_190931_a));
        minion.setHasArmour(true);
        if (caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)ASItems.charm_spectral_army)) {
            minion.func_184201_a(EntityEquipmentSlot.MAINHAND, SpectralArmy.conjureItem(modifiers, WizardryItems.spectral_sword));
            minion.func_184201_a(EntityEquipmentSlot.OFFHAND, SpectralArmy.conjureItem(modifiers, ASItems.spectral_shield));
        }
        if (!((attack_damage = minion.func_110148_a(SharedMonsterAttributes.field_111264_e)) == null || caster instanceof EntityPlayer && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)ASItems.charm_spectral_army))) {
            attack_damage.func_111121_a(new AttributeModifier("potency", 1.2, 1));
        }
        if ((speed = minion.func_110148_a(SharedMonsterAttributes.field_111263_d)) != null) {
            speed.func_111121_a(new AttributeModifier("speed_modifier", -0.5, 1));
        }
        if ((attack_speed = minion.func_110148_a(SharedMonsterAttributes.field_188790_f)) != null) {
            attack_speed.func_111121_a(new AttributeModifier("attack_speed_modifier", 0.5, 1));
        }
        minion.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111121_a(new AttributeModifier("minion_health", 0.5 * (double)modifiers.get("minion_health") - 1.0, 2));
        minion.func_70606_j(minion.func_110138_aP());
    }
}

