/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.integration.artemislib.ASArtemisLibIntegration;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.registry.ASPotions;
import com.windanesz.ancientspellcraft.spell.SpellBuffAS;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.util.SpellModifiers;
import java.util.function.Supplier;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class SpellResizeSelf
extends SpellBuffAS {
    public SpellResizeSelf(String name, float r, float g, float b, Supplier<Potion> ... effects) {
        super(name, r, g, b, effects);
        if (!ASArtemisLibIntegration.enabled()) {
            this.setEnabled(false);
        }
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ASArtemisLibIntegration.enabled()) {
            return super.cast(world, caster, hand, ticksInUse, modifiers);
        }
        if (!world.field_72995_K) {
            caster.func_146105_b((ITextComponent)new TextComponentTranslation("tooltip.ancientspellcraft:missing_artemislib.disabled_spell", new Object[0]), false);
        }
        return false;
    }

    public boolean cast(World world, EntityLiving caster, EnumHand hand, int ticksInUse, EntityLivingBase target, SpellModifiers modifiers) {
        return ASArtemisLibIntegration.enabled() && super.cast(world, caster, hand, ticksInUse, target, modifiers);
    }

    public boolean cast(World world, double x, double y, double z, EnumFacing direction, int ticksInUse, int duration, SpellModifiers modifiers) {
        return ASArtemisLibIntegration.enabled() && super.cast(world, x, y, z, direction, ticksInUse, duration, modifiers);
    }

    protected boolean applyEffects(EntityLivingBase caster, SpellModifiers modifiers) {
        if (caster != null) {
            int modifier = caster.func_70093_af() ? 0 : 1;
            for (Potion potion : this.potionSet) {
                int duration = (int)(this.getProperty(SpellResizeSelf.getDurationKey((Potion)potion)).floatValue() * modifiers.get(WizardryItems.duration_upgrade));
                if (caster instanceof EntityPlayer && (potion == ASPotions.shrinkage && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)ASItems.ring_permanent_shrinkage) || potion == ASPotions.growth && ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)ASItems.ring_permanent_growth))) {
                    duration = Integer.MAX_VALUE;
                }
                caster.func_70690_d(new PotionEffect(potion, duration, modifier, false, false));
            }
        }
        return true;
    }

    @Override
    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

