/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.item.ItemNewArtefact;
import com.windanesz.ancientspellcraft.registry.ASItems;
import com.windanesz.ancientspellcraft.util.SpellcastUtils;
import electroblob.wizardry.event.SpellCastEvent;
import electroblob.wizardry.item.ItemArtefact;
import electroblob.wizardry.registry.Spells;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class SpringCharge
extends Spell {
    public static final String HORIZONTAL_SPEED = "horizontal_speed";
    public static final String VERTICAL_SPEED = "vertical_speed";

    public SpringCharge() {
        super("ancientspellcraft", "spring_charge", EnumAction.NONE, true);
        this.addProperties(new String[]{HORIZONTAL_SPEED, VERTICAL_SPEED});
        this.soundValues(0.5f, 1.0f, 0.0f);
    }

    public boolean cast(World world, EntityPlayer caster, EnumHand hand, int ticksInUse, SpellModifiers modifiers) {
        if (ticksInUse > 3 && !caster.field_70122_E && caster.func_184587_cr()) {
            caster.func_184597_cx();
        }
        if (ticksInUse > 40 && caster.func_184587_cr()) {
            caster.func_184597_cx();
        }
        if (world.field_72995_K) {
            ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARK).pos(caster.field_70165_t + world.field_73012_v.nextDouble() / 5.0 * (double)((float)ticksInUse / 10.0f) * (double)(world.field_73012_v.nextBoolean() ? -1 : 1), caster.field_70163_u + (0.3 + world.field_73012_v.nextDouble() / 5.0 * (double)((float)ticksInUse / 10.0f) * (double)(world.field_73012_v.nextBoolean() ? -1 : 1)), caster.field_70161_v + world.field_73012_v.nextDouble() / 5.0 * (double)((float)ticksInUse / 10.0f) * (double)(world.field_73012_v.nextBoolean() ? -1 : 1)).time(4).spawn(world);
        }
        return caster.field_70122_E;
    }

    public void finishCasting(World world, @Nullable EntityLivingBase caster, double x, double y, double z, @Nullable EnumFacing direction, int ticksInUse, SpellModifiers modifiers) {
        super.finishCasting(world, caster, x, y, z, direction, ticksInUse, modifiers);
        float reduct = 1.0f;
        if (caster instanceof EntityPlayer) {
            if (!caster.field_70122_E && !ItemArtefact.isArtefactActive((EntityPlayer)((EntityPlayer)caster), (Item)ASItems.ring_cloudwalker)) {
                return;
            }
            if (!caster.field_70122_E) {
                ticksInUse = 2;
                reduct = 0.5f;
            }
        }
        ticksInUse = Math.min(40, ticksInUse);
        if (caster != null) {
            caster.field_70181_x = this.getProperty(VERTICAL_SPEED).floatValue() * modifiers.get("potency") * (float)ticksInUse * reduct;
            double horizontalSpeed = this.getProperty(HORIZONTAL_SPEED).floatValue();
            caster.func_70024_g(caster.func_70040_Z().field_72450_a * horizontalSpeed * (double)ticksInUse, 0.0, caster.func_70040_Z().field_72449_c * horizontalSpeed * (double)ticksInUse);
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double xa = caster.field_70165_t + (double)world.field_73012_v.nextFloat() - 0.5;
                    double ya = caster.field_70163_u;
                    double za = caster.field_70161_v + (double)world.field_73012_v.nextFloat() - 0.5;
                    world.func_175688_a(EnumParticleTypes.CLOUD, xa, ya, za, 0.0, 0.0, 0.0, new int[0]);
                }
            }
        }
        if (ticksInUse > 5 && caster instanceof EntityPlayer && caster.field_70122_E && ItemNewArtefact.isNewArtefactActive((EntityPlayer)caster, ASItems.belt_spring_charge)) {
            SpellModifiers modifiers1 = new SpellModifiers();
            modifiers1.set(WizardryItems.blast_upgrade, (float)ticksInUse * 0.1f, true);
            modifiers1.set("potency", 0.5f, true);
            SpellcastUtils.tryCastSpellAsPlayer((EntityPlayer)caster, Spells.lightning_pulse, EnumHand.MAIN_HAND, SpellCastEvent.Source.WAND, modifiers1, 0);
        }
    }

    public boolean applicableForItem(Item item) {
        return item == ASItems.ancient_spellcraft_spell_book || item == ASItems.ancient_spellcraft_scroll;
    }
}

