/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.spell;

import com.windanesz.ancientspellcraft.registry.ASEnchantments;
import electroblob.wizardry.constants.Constants;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.SpellActions;
import electroblob.wizardry.registry.WizardryEnchantments;
import electroblob.wizardry.registry.WizardryItems;
import electroblob.wizardry.registry.WizardryPotions;
import electroblob.wizardry.spell.ImbueWeapon;
import electroblob.wizardry.spell.SpellRay;
import electroblob.wizardry.util.EntityUtils;
import electroblob.wizardry.util.ParticleBuilder;
import electroblob.wizardry.util.SpellModifiers;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class WarpWeapon
extends SpellRay {
    public WarpWeapon() {
        super("ancientspellcraft", "warp_weapon", SpellActions.IMBUE, false);
        this.addProperties(new String[]{"effect_duration"});
    }

    protected boolean onEntityHit(World world, Entity target, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        if (EntityUtils.isLiving((Entity)target)) {
            if (!world.field_72995_K) {
                if (target instanceof EntityLivingBase) {
                    EnumDegradedItem type;
                    ItemStack stack;
                    EntityLivingBase livingTarget = (EntityLivingBase)target;
                    if (livingTarget.func_70644_a(WizardryPotions.ward) && caster instanceof EntityPlayer) {
                        ((EntityPlayer)caster).func_146105_b((ITextComponent)new TextComponentTranslation("spell.resist", new Object[]{target.func_70005_c_(), this.getNameForTranslationFormatted()}), true);
                        livingTarget.func_184589_d(WizardryPotions.ward);
                        return true;
                    }
                    if (!livingTarget.func_184614_ca().func_190926_b() && (ImbueWeapon.isSword((ItemStack)livingTarget.func_184614_ca()) || ImbueWeapon.isBow((ItemStack)livingTarget.func_184614_ca()))) {
                        stack = livingTarget.func_184614_ca();
                    } else if (!livingTarget.func_184592_cb().func_190926_b() && (ImbueWeapon.isSword((ItemStack)livingTarget.func_184592_cb()) || ImbueWeapon.isBow((ItemStack)livingTarget.func_184592_cb()))) {
                        stack = livingTarget.func_184592_cb();
                    } else {
                        return false;
                    }
                    EnumDegradedItem enumDegradedItem = type = ImbueWeapon.isSword((ItemStack)stack) ? EnumDegradedItem.SWORD : EnumDegradedItem.BOW;
                    if (livingTarget instanceof EntityPlayer) {
                        int duration = (int)(600.0f * modifiers.get(WizardryItems.duration_upgrade));
                        System.out.println(duration);
                        WizardData.get((EntityPlayer)((EntityPlayer)livingTarget)).setImbuementDuration(ASEnchantments.degrade_sword, duration);
                    }
                    int level = modifiers.get("potency") == 1.0f ? 1 : (int)((modifiers.get("potency") - 1.0f) / Constants.POTENCY_INCREASE_PER_TIER + 0.5f);
                    System.out.println("level: " + level);
                    stack.func_77966_a(ASEnchantments.degrade_sword, level);
                }
                this.playSound(world, caster, ticksInUse, -1, modifiers, new String[0]);
                return true;
            }
            if (world.field_72995_K) {
                for (int i = 0; i < 10; ++i) {
                    double x = target.field_70165_t + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    double y = target.field_70163_u + (double)target.func_70047_e() - 0.5 + world.field_73012_v.nextDouble();
                    double z = target.field_70161_v + world.field_73012_v.nextDouble() * 2.0 - 1.0;
                    ParticleBuilder.create((ResourceLocation)ParticleBuilder.Type.SPARKLE).pos(x, y, z).vel(0.0, 0.1, 0.0).clr(0.9f, 0.7f, 1.0f).spawn(world);
                }
            }
        }
        return true;
    }

    protected boolean onBlockHit(World world, BlockPos pos, EnumFacing side, Vec3d hit, @Nullable EntityLivingBase caster, Vec3d origin, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    protected boolean onMiss(World world, @Nullable EntityLivingBase caster, Vec3d origin, Vec3d direction, int ticksInUse, SpellModifiers modifiers) {
        return true;
    }

    private static enum EnumDegradedItem {
        BOW(WizardryEnchantments.magic_bow, ASEnchantments.degrade_bow),
        SWORD(WizardryEnchantments.magic_sword, ASEnchantments.degrade_sword);

        Enchantment beneficialEnchant;
        Enchantment debuff;

        private EnumDegradedItem(Enchantment beneficialEnchant, Enchantment debuff) {
            this.beneficialEnchant = beneficialEnchant;
            this.debuff = debuff;
        }
    }
}

