/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.tileentity;

import com.windanesz.ancientspellcraft.client.gui.ContainerScribingDesk;
import com.windanesz.ancientspellcraft.item.ItemRelic;
import com.windanesz.ancientspellcraft.registry.ASItems;
import electroblob.wizardry.data.WizardData;
import electroblob.wizardry.item.ItemCrystal;
import electroblob.wizardry.item.ItemScroll;
import electroblob.wizardry.item.ItemSpellBook;
import electroblob.wizardry.spell.Spell;
import electroblob.wizardry.util.NBTExtras;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;

public class TileScribingDesk
extends TileEntity
implements IInventory,
ITickable {
    private NonNullList<ItemStack> inventory;
    private int researchDuration;
    private int researchProgress;
    public int currentHintId = 0;
    public int ready = 0;
    private boolean changedResearchState = false;
    private boolean inUse = false;
    private EntityPlayer currentPlayer;
    private WizardData playerWizardData;
    private NonNullList<ItemStack> furnaceItemStacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
    public float rotation;

    public WizardData getPlayerWizardData() {
        return this.playerWizardData;
    }

    public TileScribingDesk() {
        this.inventory = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
    }

    public void setInUse(boolean inUse) {
        this.inUse = inUse;
    }

    public EntityPlayer getCurrentPlayer() {
        return this.currentPlayer;
    }

    public void setCurrentPlayer(EntityPlayer currentPlayer) {
        this.currentPlayer = currentPlayer;
    }

    public String func_70005_c_() {
        return "container.ancientspellcraft:sphere_cognizance";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        NBTTagList inventoryList = compound.func_150295_c("Inventory", 10);
        for (int i = 0; i < inventoryList.func_74745_c(); ++i) {
            NBTTagCompound tag = inventoryList.func_150305_b(i);
            byte slot = tag.func_74771_c("Slot");
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, new ItemStack(tag));
        }
        this.researchDuration = compound.func_74765_d("researchDuration");
        this.researchProgress = compound.func_74765_d("researchProgress");
        this.currentHintId = compound.func_74765_d("currentHintId");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        NBTTagList inventoryList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(tag);
            inventoryList.func_74742_a((NBTBase)tag);
        }
        compound.func_74768_a("researchDuration", (int)((short)this.researchDuration));
        compound.func_74768_a("researchProgress", (int)((short)this.researchProgress));
        compound.func_74768_a("currentHintId", (int)((short)this.currentHintId));
        compound.func_74768_a("currentHintTypeId", (int)((short)this.ready));
        NBTExtras.storeTagSafely((NBTTagCompound)compound, (String)"Inventory", (NBTBase)inventoryList);
        return compound;
    }

    public final NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public Spell getCurrentSpell() {
        if (this.getInputStack().func_77952_i() != Short.MAX_VALUE) {
            return Spell.byMetadata((int)this.getInputStack().func_77952_i());
        }
        return null;
    }

    public ItemStack getCrystalStack() {
        return (ItemStack)this.inventory.get(ContainerScribingDesk.CRYSTAL_SLOT);
    }

    public ItemStack getInputStack() {
        return (ItemStack)this.inventory.get(1);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.inUse && this.currentPlayer != null) {
            ItemStack relic;
            boolean craftBook = false;
            if (this.hasCrystalForFuel() && ItemStack.func_185132_d((ItemStack)((ItemStack)this.inventory.get(ContainerScribingDesk.INK_SLOT)), (ItemStack)new ItemStack(Items.field_151100_aR, 1, 0)) && this.inventory.get(ContainerScribingDesk.RELIC_SLOT) != null && ((ItemStack)this.inventory.get(ContainerScribingDesk.RELIC_SLOT)).func_77973_b() instanceof ItemRelic && ItemRelic.isResearched(relic = (ItemStack)this.inventory.get(ContainerScribingDesk.RELIC_SLOT)) && ((ItemStack)this.inventory.get(ContainerScribingDesk.BOOK_SLOT)).func_77973_b() == Items.field_151122_aG) {
                List<ItemStack> componentList = ItemRelic.getSpellComponentItems(relic);
                int matches = 0;
                if (componentList != null && !componentList.isEmpty()) {
                    for (int i = 0; i < componentList.size(); ++i) {
                        ItemStack stack = componentList.get(i);
                        ItemStack currItem = (ItemStack)this.inventory.get(i);
                        if (!ItemStack.func_185132_d((ItemStack)currItem, (ItemStack)stack)) continue;
                        ++matches;
                    }
                    if (componentList.size() == matches) {
                        this.ready = 1;
                        craftBook = true;
                    }
                }
            }
            int n = this.ready = craftBook ? 1 : 0;
        }
        if (this.changedResearchState) {
            this.func_70296_d();
        }
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCrystalForFuel() {
        boolean b;
        boolean bl = b = this.getCrystalStack() != null && !this.getCrystalStack().func_190926_b() && this.getCrystalStack().func_77973_b() instanceof ItemCrystal;
        return b && this.getCrystalStack().func_190916_E() >= this.getResearchCost(this.getCurrentSpell());
    }

    public int getResearchCost(Spell spell) {
        switch (spell.getTier()) {
            case NOVICE: {
                return 1;
            }
            case APPRENTICE: {
                return 1;
            }
            case ADVANCED: {
                return 1;
            }
            case MASTER: {
                return 2;
            }
        }
        return 1;
    }

    public void craftBook() {
        WizardData data;
        this.func_70298_a(ContainerScribingDesk.CRYSTAL_SLOT, 1);
        this.func_70298_a(ContainerScribingDesk.INGREDIENT_1_SLOT, 1);
        this.func_70298_a(ContainerScribingDesk.INGREDIENT_2_SLOT, 1);
        this.func_70298_a(ContainerScribingDesk.INGREDIENT_3_SLOT, 1);
        this.func_70298_a(ContainerScribingDesk.BOOK_SLOT, 1);
        ItemStack relic = this.func_70301_a(ContainerScribingDesk.RELIC_SLOT);
        Spell spell = ItemRelic.getSpell(relic);
        this.func_70298_a(ContainerScribingDesk.RELIC_SLOT, 1);
        this.func_70298_a(ContainerScribingDesk.INK_SLOT, 1);
        ItemStack spellBook = new ItemStack(ASItems.ancient_spell_book, 1, spell.metadata());
        this.func_70299_a(ContainerScribingDesk.BOOK_SLOT, spellBook);
        if (WizardData.get((EntityPlayer)this.currentPlayer) != null && !(data = WizardData.get((EntityPlayer)this.currentPlayer)).hasSpellBeenDiscovered(spell)) {
            data.discoverSpell(spell);
            data.sync();
            if (!this.field_145850_b.field_72995_K) {
                this.currentPlayer.func_145747_a((ITextComponent)new TextComponentTranslation("spell.discover", new Object[]{spell.getNameForTranslationFormatted()}));
            }
        }
    }

    public int func_70302_i_() {
        return 7;
    }

    public boolean func_191420_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.inventory.get(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.inventory, (int)slot, (int)amount);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.furnaceItemStacks, (int)index);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        ItemStack itemstack = (ItemStack)this.inventory.get(slot);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemstack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemstack);
        this.inventory.set(slot, (Object)stack);
        if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (slot == ContainerScribingDesk.CRYSTAL_SLOT) {
            // empty if block
        }
        if (slot == ContainerScribingDesk.BOOK_SLOT) {
            this.researchProgress = 0;
            this.currentHintId = 0;
            this.ready = 0;
        }
        this.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        boolean withinDistance = this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_174831_c(this.field_174879_c) < 64.0;
        return withinDistance && (!this.inUse || player == this.getCurrentPlayer());
    }

    public void func_174889_b(EntityPlayer player) {
        this.setInUse(true);
        this.setCurrentPlayer(player);
        this.setPlayerWizardData(player);
    }

    public void setPlayerWizardData(EntityPlayer player) {
        this.playerWizardData = WizardData.get((EntityPlayer)player);
    }

    public void func_174886_c(EntityPlayer player) {
        this.setInUse(false);
        this.setCurrentPlayer(null);
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_94041_b(int slotNumber, ItemStack stack) {
        if (stack == ItemStack.field_190927_a) {
            return true;
        }
        if (slotNumber == ContainerScribingDesk.CRYSTAL_SLOT) {
            return stack.func_77973_b() instanceof ItemCrystal;
        }
        if (slotNumber == ContainerScribingDesk.BOOK_SLOT) {
            return stack.func_77973_b() instanceof ItemRelic || stack.func_77973_b() instanceof ItemSpellBook || stack.func_77973_b() instanceof ItemScroll;
        }
        return false;
    }

    public int func_174890_g() {
        return 3;
    }

    public int func_174887_a_(int id) {
        switch (id) {
            case 0: {
                return this.researchProgress;
            }
            case 1: {
                return this.researchDuration;
            }
            case 2: {
                return this.ready;
            }
        }
        return 0;
    }

    public void func_174885_b(int id, int value) {
        switch (id) {
            case 0: {
                this.researchProgress = value;
                break;
            }
            case 1: {
                this.researchDuration = value;
                break;
            }
            case 2: {
                this.ready = value;
            }
        }
    }

    public void func_174888_l() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, ItemStack.field_190927_a);
        }
    }
}

