/*
 * Decompiled with CFR 0.152.
 */
package com.windanesz.ancientspellcraft.util;

public class LangUtils {
    public static String toElderFuthark(String string) {
        return ElderFuthark.getFuthark(string);
    }

    public static enum ElderFuthark {
        F("F", "\u16a1", "Feoh"),
        U("U", "\u16a2", "Uruz"),
        V("V", "\u16a2", "Uruz"),
        TH("TH", "\u16a6", "Thurisaz"),
        A("A", "\u16a8", "Ansuz"),
        R("R", "\u16b1", "Raido"),
        K("K", "\u16b2", "Kaunan"),
        C("C", "\u16b2", "Kaunan"),
        G("G", "\u16b7", "Gyfu"),
        W("W", "\u16b9", "Wynn"),
        H("H", "\u16ba", "Haglaz"),
        N("N", "\u16be", "Naudiz"),
        I("I", "\u16c1", "Isaz"),
        J("J", "\u16c3", "Jera"),
        Y("Y", "\u16c3", "Jera"),
        AE("AE", "\u16c7", "Ihwaz"),
        P("P", "\u16c8", "Peorth"),
        Z("Z", "\u16c9", "Algiz"),
        S("S", "\u16ca", "Sowilo"),
        T("T", "\u16cf", "Tiwaz"),
        B("B", "\u16d2", "Berkanan"),
        E("E", "\u16d6", "Ehwaz"),
        M("M", "\u16d7", "Mannaz"),
        L("L", "\u16da", "Laguz"),
        Q("Q", "\u16dc", "Yngvi"),
        O("O", "\u16df", "Odal"),
        D("D", "\u16de", "Dagaz"),
        COLON(":", "\u1365", ":");

        private final String latin;
        private String uniRune;
        private String runeName;

        private ElderFuthark(String latin, String uniRune, String runeName) {
            this.latin = latin;
            this.uniRune = uniRune;
        }

        private static String getUniRuneForChar(String string) {
            for (ElderFuthark f : ElderFuthark.values()) {
                if (!f.latin.equals(string.toUpperCase())) continue;
                return f.uniRune;
            }
            return string;
        }

        public static String getFuthark(String string) {
            StringBuilder target = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                target.append(ElderFuthark.getUniRuneForChar(string.substring(i, i + 1)));
            }
            return target.toString();
        }
    }
}

